/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-10-17 16:43:55 UTC)
 * on 2016-11-02 at 16:58:21 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A list of revisions of a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RevisionList extends com.google.api.client.json.GenericJson {

  /**
   * Identifies what kind of resource this is. Value: the fixed string "drive#revisionList".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The page token for the next page of revisions. This will be absent if the end of the revisions
   * list has been reached.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The full list of revisions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Revision> revisions;

  static {
    // hack to force ProGuard to consider Revision used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Revision.class);
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "drive#revisionList".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "drive#revisionList".
   * @param kind kind or {@code null} for none
   */
  public RevisionList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The page token for the next page of revisions. This will be absent if the end of the revisions
   * list has been reached.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The page token for the next page of revisions. This will be absent if the end of the revisions
   * list has been reached.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public RevisionList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The full list of revisions.
   * @return value or {@code null} for none
   */
  public java.util.List<Revision> getRevisions() {
    return revisions;
  }

  /**
   * The full list of revisions.
   * @param revisions revisions or {@code null} for none
   */
  public RevisionList setRevisions(java.util.List<Revision> revisions) {
    this.revisions = revisions;
    return this;
  }

  @Override
  public RevisionList set(String fieldName, Object value) {
    return (RevisionList) super.set(fieldName, value);
  }

  @Override
  public RevisionList clone() {
    return (RevisionList) super.clone();
  }

}
