/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.drive;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.drive.DriveRequest;
import com.google.api.services.drive.DriveRequestInitializer;
import com.google.api.services.drive.model.ChangeList;
import com.google.api.services.drive.model.Channel;
import com.google.api.services.drive.model.Comment;
import com.google.api.services.drive.model.CommentList;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.api.services.drive.model.GeneratedIds;
import com.google.api.services.drive.model.Permission;
import com.google.api.services.drive.model.PermissionList;
import com.google.api.services.drive.model.Reply;
import com.google.api.services.drive.model.ReplyList;
import com.google.api.services.drive.model.Revision;
import com.google.api.services.drive.model.RevisionList;
import com.google.api.services.drive.model.StartPageToken;
import com.google.api.services.drive.model.TeamDrive;
import com.google.api.services.drive.model.TeamDriveList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Drive
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "drive/v3/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/drive/v3/";

    public Drive(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Drive(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public About about() {
        return new About();
    }

    public Changes changes() {
        return new Changes();
    }

    public Channels channels() {
        return new Channels();
    }

    public Comments comments() {
        return new Comments();
    }

    public Files files() {
        return new Files();
    }

    public Permissions permissions() {
        return new Permissions();
    }

    public Replies replies() {
        return new Replies();
    }

    public Revisions revisions() {
        return new Revisions();
    }

    public Teamdrives teamdrives() {
        return new Teamdrives();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.18.0-rc of the Drive API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Drive.DEFAULT_ROOT_URL, Drive.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Drive build() {
            return new Drive(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDriveRequestInitializer(DriveRequestInitializer driveRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)driveRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Teamdrives {
        public Create create(String string, TeamDrive teamDrive) throws IOException {
            Create create = new Create(string, teamDrive);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Update update(String string, TeamDrive teamDrive) throws IOException {
            Update update = new Update(string, teamDrive);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DriveRequest<TeamDrive> {
            private static final String REST_PATH = "teamdrives/{teamDriveId}";
            @Key
            private String teamDriveId;

            protected Update(String string, TeamDrive teamDrive) {
                super(Drive.this, "PATCH", REST_PATH, (Object)teamDrive, TeamDrive.class);
                this.teamDriveId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter teamDriveId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public Update setTeamDriveId(String string) {
                this.teamDriveId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<TeamDriveList> {
            private static final String REST_PATH = "teamdrives";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(Drive.this, "GET", REST_PATH, null, TeamDriveList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<TeamDrive> {
            private static final String REST_PATH = "teamdrives/{teamDriveId}";
            @Key
            private String teamDriveId;

            protected Get(String string) {
                super(Drive.this, "GET", REST_PATH, null, TeamDrive.class);
                this.teamDriveId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter teamDriveId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public Get setTeamDriveId(String string) {
                this.teamDriveId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "teamdrives/{teamDriveId}";
            @Key
            private String teamDriveId;

            protected Delete(String string) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.teamDriveId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter teamDriveId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public Delete setTeamDriveId(String string) {
                this.teamDriveId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends DriveRequest<TeamDrive> {
            private static final String REST_PATH = "teamdrives";
            @Key
            private String requestId;

            protected Create(String string, TeamDrive teamDrive) {
                super(Drive.this, "POST", REST_PATH, (Object)teamDrive, TeamDrive.class);
                this.requestId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter requestId must be specified.");
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUserIp(String string) {
                return (Create)super.setUserIp(string);
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Create setRequestId(String string) {
                this.requestId = string;
                return this;
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class Revisions {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Update update(String string, String string2, Revision revision) throws IOException {
            Update update = new Update(string, string2, revision);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DriveRequest<Revision> {
            private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";
            @Key
            private String fileId;
            @Key
            private String revisionId;

            protected Update(String string, String string2, Revision revision) {
                super(Drive.this, "PATCH", REST_PATH, (Object)revision, Revision.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.revisionId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter revisionId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Update setRevisionId(String string) {
                this.revisionId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<RevisionList> {
            private static final String REST_PATH = "files/{fileId}/revisions";
            @Key
            private String fileId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Drive.this, "GET", REST_PATH, null, RevisionList.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<Revision> {
            private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";
            @Key
            private String fileId;
            @Key
            private String revisionId;
            @Key
            private Boolean acknowledgeAbuse;

            protected Get(String string, String string2) {
                super(Drive.this, "GET", REST_PATH, null, Revision.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.revisionId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter revisionId must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Get setRevisionId(String string) {
                this.revisionId = string;
                return this;
            }

            public Boolean getAcknowledgeAbuse() {
                return this.acknowledgeAbuse;
            }

            public Get setAcknowledgeAbuse(Boolean bl) {
                this.acknowledgeAbuse = bl;
                return this;
            }

            public boolean isAcknowledgeAbuse() {
                if (this.acknowledgeAbuse == null || this.acknowledgeAbuse == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.acknowledgeAbuse;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";
            @Key
            private String fileId;
            @Key
            private String revisionId;

            protected Delete(String string, String string2) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.revisionId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter revisionId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Delete setRevisionId(String string) {
                this.revisionId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Replies {
        public Create create(String string, String string2, Reply reply) throws IOException {
            Create create = new Create(string, string2, reply);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Update update(String string, String string2, String string3, Reply reply) throws IOException {
            Update update = new Update(string, string2, string3, reply);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DriveRequest<Reply> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private String replyId;

            protected Update(String string, String string2, String string3, Reply reply) {
                super(Drive.this, "PATCH", REST_PATH, (Object)reply, Reply.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter commentId must be specified.");
                this.replyId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter replyId must be specified.");
                this.checkRequiredParameter((Object)reply, "content");
                this.checkRequiredParameter(reply.getContent(), "Reply.getContent()");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Update setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            public String getReplyId() {
                return this.replyId;
            }

            public Update setReplyId(String string) {
                this.replyId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<ReplyList> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private Boolean includeDeleted;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(Drive.this, "GET", REST_PATH, null, ReplyList.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter commentId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public List setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public List setIncludeDeleted(Boolean bl) {
                this.includeDeleted = bl;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeDeleted;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<Reply> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private String replyId;
            @Key
            private Boolean includeDeleted;

            protected Get(String string, String string2, String string3) {
                super(Drive.this, "GET", REST_PATH, null, Reply.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter commentId must be specified.");
                this.replyId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter replyId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Get setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            public String getReplyId() {
                return this.replyId;
            }

            public Get setReplyId(String string) {
                this.replyId = string;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public Get setIncludeDeleted(Boolean bl) {
                this.includeDeleted = bl;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeDeleted;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private String replyId;

            protected Delete(String string, String string2, String string3) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter commentId must be specified.");
                this.replyId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter replyId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Delete setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            public String getReplyId() {
                return this.replyId;
            }

            public Delete setReplyId(String string) {
                this.replyId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends DriveRequest<Reply> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies";
            @Key
            private String fileId;
            @Key
            private String commentId;

            protected Create(String string, String string2, Reply reply) {
                super(Drive.this, "POST", REST_PATH, (Object)reply, Reply.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter commentId must be specified.");
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUserIp(String string) {
                return (Create)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Create setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Create setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class Permissions {
        public Create create(String string, Permission permission) throws IOException {
            Create create = new Create(string, permission);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Update update(String string, String string2, Permission permission) throws IOException {
            Update update = new Update(string, string2, permission);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DriveRequest<Permission> {
            private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";
            @Key
            private String fileId;
            @Key
            private String permissionId;
            @Key
            private Boolean removeExpiration;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean transferOwnership;

            protected Update(String string, String string2, Permission permission) {
                super(Drive.this, "PATCH", REST_PATH, (Object)permission, Permission.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.permissionId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter permissionId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getPermissionId() {
                return this.permissionId;
            }

            public Update setPermissionId(String string) {
                this.permissionId = string;
                return this;
            }

            public Boolean getRemoveExpiration() {
                return this.removeExpiration;
            }

            public Update setRemoveExpiration(Boolean bl) {
                this.removeExpiration = bl;
                return this;
            }

            public boolean isRemoveExpiration() {
                if (this.removeExpiration == null || this.removeExpiration == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.removeExpiration;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Update setSupportsTeamDrives(Boolean bl) {
                this.supportsTeamDrives = bl;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getTransferOwnership() {
                return this.transferOwnership;
            }

            public Update setTransferOwnership(Boolean bl) {
                this.transferOwnership = bl;
                return this;
            }

            public boolean isTransferOwnership() {
                if (this.transferOwnership == null || this.transferOwnership == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.transferOwnership;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<PermissionList> {
            private static final String REST_PATH = "files/{fileId}/permissions";
            @Key
            private String fileId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Boolean supportsTeamDrives;

            protected List(String string) {
                super(Drive.this, "GET", REST_PATH, null, PermissionList.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public List setSupportsTeamDrives(Boolean bl) {
                this.supportsTeamDrives = bl;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<Permission> {
            private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";
            @Key
            private String fileId;
            @Key
            private String permissionId;
            @Key
            private Boolean supportsTeamDrives;

            protected Get(String string, String string2) {
                super(Drive.this, "GET", REST_PATH, null, Permission.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.permissionId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter permissionId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getPermissionId() {
                return this.permissionId;
            }

            public Get setPermissionId(String string) {
                this.permissionId = string;
                return this;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Get setSupportsTeamDrives(Boolean bl) {
                this.supportsTeamDrives = bl;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";
            @Key
            private String fileId;
            @Key
            private String permissionId;
            @Key
            private Boolean supportsTeamDrives;

            protected Delete(String string, String string2) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.permissionId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter permissionId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getPermissionId() {
                return this.permissionId;
            }

            public Delete setPermissionId(String string) {
                this.permissionId = string;
                return this;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Delete setSupportsTeamDrives(Boolean bl) {
                this.supportsTeamDrives = bl;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends DriveRequest<Permission> {
            private static final String REST_PATH = "files/{fileId}/permissions";
            @Key
            private String fileId;
            @Key
            private String emailMessage;
            @Key
            private Boolean sendNotificationEmail;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean transferOwnership;

            protected Create(String string, Permission permission) {
                super(Drive.this, "POST", REST_PATH, (Object)permission, Permission.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.checkRequiredParameter((Object)permission, "content");
                this.checkRequiredParameter(permission.getRole(), "Permission.getRole()");
                this.checkRequiredParameter((Object)permission, "content");
                this.checkRequiredParameter(permission.getType(), "Permission.getType()");
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUserIp(String string) {
                return (Create)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Create setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getEmailMessage() {
                return this.emailMessage;
            }

            public Create setEmailMessage(String string) {
                this.emailMessage = string;
                return this;
            }

            public Boolean getSendNotificationEmail() {
                return this.sendNotificationEmail;
            }

            public Create setSendNotificationEmail(Boolean bl) {
                this.sendNotificationEmail = bl;
                return this;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Create setSupportsTeamDrives(Boolean bl) {
                this.supportsTeamDrives = bl;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getTransferOwnership() {
                return this.transferOwnership;
            }

            public Create setTransferOwnership(Boolean bl) {
                this.transferOwnership = bl;
                return this;
            }

            public boolean isTransferOwnership() {
                if (this.transferOwnership == null || this.transferOwnership == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.transferOwnership;
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class Files {
        public Copy copy(String string, File file) throws IOException {
            Copy copy = new Copy(string, file);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)copy);
            return copy;
        }

        public Create create(File file) throws IOException {
            Create create = new Create(file);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Create create(File file, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Create create = new Create(file, abstractInputStreamContent);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public EmptyTrash emptyTrash() throws IOException {
            EmptyTrash emptyTrash = new EmptyTrash();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)emptyTrash);
            return emptyTrash;
        }

        public Export export(String string, String string2) throws IOException {
            Export export = new Export(string, string2);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)export);
            return export;
        }

        public GenerateIds generateIds() throws IOException {
            GenerateIds generateIds = new GenerateIds();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)generateIds);
            return generateIds;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Update update(String string, File file) throws IOException {
            Update update = new Update(string, file);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        public Update update(String string, File file, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Update update = new Update(string, file, abstractInputStreamContent);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        public Watch watch(String string, Channel channel) throws IOException {
            Watch watch = new Watch(string, channel);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)watch);
            return watch;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Watch
        extends DriveRequest<Channel> {
            private static final String REST_PATH = "files/{fileId}/watch";
            @Key
            private String fileId;
            @Key
            private Boolean acknowledgeAbuse;
            @Key
            private Boolean supportsTeamDrives;

            protected Watch(String string, Channel channel) {
                super(Drive.this, "POST", REST_PATH, (Object)channel, Channel.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public Watch setAlt(String string) {
                return (Watch)super.setAlt(string);
            }

            public Watch setFields(String string) {
                return (Watch)super.setFields(string);
            }

            public Watch setKey(String string) {
                return (Watch)super.setKey(string);
            }

            public Watch setOauthToken(String string) {
                return (Watch)super.setOauthToken(string);
            }

            public Watch setPrettyPrint(Boolean bl) {
                return (Watch)super.setPrettyPrint(bl);
            }

            public Watch setQuotaUser(String string) {
                return (Watch)super.setQuotaUser(string);
            }

            public Watch setUserIp(String string) {
                return (Watch)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Watch setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public Boolean getAcknowledgeAbuse() {
                return this.acknowledgeAbuse;
            }

            public Watch setAcknowledgeAbuse(Boolean bl) {
                this.acknowledgeAbuse = bl;
                return this;
            }

            public boolean isAcknowledgeAbuse() {
                if (this.acknowledgeAbuse == null || this.acknowledgeAbuse == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.acknowledgeAbuse;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Watch setSupportsTeamDrives(Boolean bl) {
                this.supportsTeamDrives = bl;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public Watch set(String string, Object object) {
                return (Watch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}";
            @Key
            private String fileId;
            @Key
            private String addParents;
            @Key
            private Boolean keepRevisionForever;
            @Key
            private String ocrLanguage;
            @Key
            private String removeParents;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean useContentAsIndexableText;

            protected Update(String string, File file) {
                super(Drive.this, "PATCH", REST_PATH, (Object)file, File.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
            }

            protected Update(String string, File file, AbstractInputStreamContent abstractInputStreamContent) {
                super(Drive.this, "PATCH", "/upload/" + Drive.this.getServicePath() + REST_PATH, (Object)file, File.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getAddParents() {
                return this.addParents;
            }

            public Update setAddParents(String string) {
                this.addParents = string;
                return this;
            }

            public Boolean getKeepRevisionForever() {
                return this.keepRevisionForever;
            }

            public Update setKeepRevisionForever(Boolean bl) {
                this.keepRevisionForever = bl;
                return this;
            }

            public boolean isKeepRevisionForever() {
                if (this.keepRevisionForever == null || this.keepRevisionForever == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.keepRevisionForever;
            }

            public String getOcrLanguage() {
                return this.ocrLanguage;
            }

            public Update setOcrLanguage(String string) {
                this.ocrLanguage = string;
                return this;
            }

            public String getRemoveParents() {
                return this.removeParents;
            }

            public Update setRemoveParents(String string) {
                this.removeParents = string;
                return this;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Update setSupportsTeamDrives(Boolean bl) {
                this.supportsTeamDrives = bl;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getUseContentAsIndexableText() {
                return this.useContentAsIndexableText;
            }

            public Update setUseContentAsIndexableText(Boolean bl) {
                this.useContentAsIndexableText = bl;
                return this;
            }

            public boolean isUseContentAsIndexableText() {
                if (this.useContentAsIndexableText == null || this.useContentAsIndexableText == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useContentAsIndexableText;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<FileList> {
            private static final String REST_PATH = "files";
            @Key
            private String corpora;
            @Key
            private String corpus;
            @Key
            private Boolean includeTeamDriveItems;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String q;
            @Key
            private String spaces;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String teamDriveId;

            protected List() {
                super(Drive.this, "GET", REST_PATH, null, FileList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCorpora() {
                return this.corpora;
            }

            public List setCorpora(String string) {
                this.corpora = string;
                return this;
            }

            public String getCorpus() {
                return this.corpus;
            }

            public List setCorpus(String string) {
                this.corpus = string;
                return this;
            }

            public Boolean getIncludeTeamDriveItems() {
                return this.includeTeamDriveItems;
            }

            public List setIncludeTeamDriveItems(Boolean bl) {
                this.includeTeamDriveItems = bl;
                return this;
            }

            public boolean isIncludeTeamDriveItems() {
                if (this.includeTeamDriveItems == null || this.includeTeamDriveItems == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeTeamDriveItems;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String string) {
                this.q = string;
                return this;
            }

            public String getSpaces() {
                return this.spaces;
            }

            public List setSpaces(String string) {
                this.spaces = string;
                return this;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public List setSupportsTeamDrives(Boolean bl) {
                this.supportsTeamDrives = bl;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public List setTeamDriveId(String string) {
                this.teamDriveId = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}";
            @Key
            private String fileId;
            @Key
            private Boolean acknowledgeAbuse;
            @Key
            private Boolean supportsTeamDrives;

            protected Get(String string) {
                super(Drive.this, "GET", REST_PATH, null, File.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public Boolean getAcknowledgeAbuse() {
                return this.acknowledgeAbuse;
            }

            public Get setAcknowledgeAbuse(Boolean bl) {
                this.acknowledgeAbuse = bl;
                return this;
            }

            public boolean isAcknowledgeAbuse() {
                if (this.acknowledgeAbuse == null || this.acknowledgeAbuse == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.acknowledgeAbuse;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Get setSupportsTeamDrives(Boolean bl) {
                this.supportsTeamDrives = bl;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GenerateIds
        extends DriveRequest<GeneratedIds> {
            private static final String REST_PATH = "files/generateIds";
            @Key
            private Integer count;
            @Key
            private String space;

            protected GenerateIds() {
                super(Drive.this, "GET", REST_PATH, null, GeneratedIds.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GenerateIds setAlt(String string) {
                return (GenerateIds)super.setAlt(string);
            }

            public GenerateIds setFields(String string) {
                return (GenerateIds)super.setFields(string);
            }

            public GenerateIds setKey(String string) {
                return (GenerateIds)super.setKey(string);
            }

            public GenerateIds setOauthToken(String string) {
                return (GenerateIds)super.setOauthToken(string);
            }

            public GenerateIds setPrettyPrint(Boolean bl) {
                return (GenerateIds)super.setPrettyPrint(bl);
            }

            public GenerateIds setQuotaUser(String string) {
                return (GenerateIds)super.setQuotaUser(string);
            }

            public GenerateIds setUserIp(String string) {
                return (GenerateIds)super.setUserIp(string);
            }

            public Integer getCount() {
                return this.count;
            }

            public GenerateIds setCount(Integer n) {
                this.count = n;
                return this;
            }

            public String getSpace() {
                return this.space;
            }

            public GenerateIds setSpace(String string) {
                this.space = string;
                return this;
            }

            @Override
            public GenerateIds set(String string, Object object) {
                return (GenerateIds)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Export
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/export";
            @Key
            private String fileId;
            @Key
            private String mimeType;

            protected Export(String string, String string2) {
                super(Drive.this, "GET", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.mimeType = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter mimeType must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Export setAlt(String string) {
                return (Export)super.setAlt(string);
            }

            public Export setFields(String string) {
                return (Export)super.setFields(string);
            }

            public Export setKey(String string) {
                return (Export)super.setKey(string);
            }

            public Export setOauthToken(String string) {
                return (Export)super.setOauthToken(string);
            }

            public Export setPrettyPrint(Boolean bl) {
                return (Export)super.setPrettyPrint(bl);
            }

            public Export setQuotaUser(String string) {
                return (Export)super.setQuotaUser(string);
            }

            public Export setUserIp(String string) {
                return (Export)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Export setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getMimeType() {
                return this.mimeType;
            }

            public Export setMimeType(String string) {
                this.mimeType = string;
                return this;
            }

            @Override
            public Export set(String string, Object object) {
                return (Export)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class EmptyTrash
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/trash";

            protected EmptyTrash() {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
            }

            public EmptyTrash setAlt(String string) {
                return (EmptyTrash)super.setAlt(string);
            }

            public EmptyTrash setFields(String string) {
                return (EmptyTrash)super.setFields(string);
            }

            public EmptyTrash setKey(String string) {
                return (EmptyTrash)super.setKey(string);
            }

            public EmptyTrash setOauthToken(String string) {
                return (EmptyTrash)super.setOauthToken(string);
            }

            public EmptyTrash setPrettyPrint(Boolean bl) {
                return (EmptyTrash)super.setPrettyPrint(bl);
            }

            public EmptyTrash setQuotaUser(String string) {
                return (EmptyTrash)super.setQuotaUser(string);
            }

            public EmptyTrash setUserIp(String string) {
                return (EmptyTrash)super.setUserIp(string);
            }

            @Override
            public EmptyTrash set(String string, Object object) {
                return (EmptyTrash)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}";
            @Key
            private String fileId;
            @Key
            private Boolean supportsTeamDrives;

            protected Delete(String string) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Delete setSupportsTeamDrives(Boolean bl) {
                this.supportsTeamDrives = bl;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends DriveRequest<File> {
            private static final String REST_PATH = "files";
            @Key
            private Boolean ignoreDefaultVisibility;
            @Key
            private Boolean keepRevisionForever;
            @Key
            private String ocrLanguage;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private Boolean useContentAsIndexableText;

            protected Create(File file) {
                super(Drive.this, "POST", REST_PATH, (Object)file, File.class);
            }

            protected Create(File file, AbstractInputStreamContent abstractInputStreamContent) {
                super(Drive.this, "POST", "/upload/" + Drive.this.getServicePath() + REST_PATH, (Object)file, File.class);
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUserIp(String string) {
                return (Create)super.setUserIp(string);
            }

            public Boolean getIgnoreDefaultVisibility() {
                return this.ignoreDefaultVisibility;
            }

            public Create setIgnoreDefaultVisibility(Boolean bl) {
                this.ignoreDefaultVisibility = bl;
                return this;
            }

            public boolean isIgnoreDefaultVisibility() {
                if (this.ignoreDefaultVisibility == null || this.ignoreDefaultVisibility == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.ignoreDefaultVisibility;
            }

            public Boolean getKeepRevisionForever() {
                return this.keepRevisionForever;
            }

            public Create setKeepRevisionForever(Boolean bl) {
                this.keepRevisionForever = bl;
                return this;
            }

            public boolean isKeepRevisionForever() {
                if (this.keepRevisionForever == null || this.keepRevisionForever == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.keepRevisionForever;
            }

            public String getOcrLanguage() {
                return this.ocrLanguage;
            }

            public Create setOcrLanguage(String string) {
                this.ocrLanguage = string;
                return this;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Create setSupportsTeamDrives(Boolean bl) {
                this.supportsTeamDrives = bl;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public Boolean getUseContentAsIndexableText() {
                return this.useContentAsIndexableText;
            }

            public Create setUseContentAsIndexableText(Boolean bl) {
                this.useContentAsIndexableText = bl;
                return this;
            }

            public boolean isUseContentAsIndexableText() {
                if (this.useContentAsIndexableText == null || this.useContentAsIndexableText == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useContentAsIndexableText;
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Copy
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}/copy";
            @Key
            private String fileId;
            @Key
            private Boolean ignoreDefaultVisibility;
            @Key
            private Boolean keepRevisionForever;
            @Key
            private String ocrLanguage;
            @Key
            private Boolean supportsTeamDrives;

            protected Copy(String string, File file) {
                super(Drive.this, "POST", REST_PATH, (Object)file, File.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
            }

            public Copy setAlt(String string) {
                return (Copy)super.setAlt(string);
            }

            public Copy setFields(String string) {
                return (Copy)super.setFields(string);
            }

            public Copy setKey(String string) {
                return (Copy)super.setKey(string);
            }

            public Copy setOauthToken(String string) {
                return (Copy)super.setOauthToken(string);
            }

            public Copy setPrettyPrint(Boolean bl) {
                return (Copy)super.setPrettyPrint(bl);
            }

            public Copy setQuotaUser(String string) {
                return (Copy)super.setQuotaUser(string);
            }

            public Copy setUserIp(String string) {
                return (Copy)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Copy setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public Boolean getIgnoreDefaultVisibility() {
                return this.ignoreDefaultVisibility;
            }

            public Copy setIgnoreDefaultVisibility(Boolean bl) {
                this.ignoreDefaultVisibility = bl;
                return this;
            }

            public boolean isIgnoreDefaultVisibility() {
                if (this.ignoreDefaultVisibility == null || this.ignoreDefaultVisibility == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.ignoreDefaultVisibility;
            }

            public Boolean getKeepRevisionForever() {
                return this.keepRevisionForever;
            }

            public Copy setKeepRevisionForever(Boolean bl) {
                this.keepRevisionForever = bl;
                return this;
            }

            public boolean isKeepRevisionForever() {
                if (this.keepRevisionForever == null || this.keepRevisionForever == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.keepRevisionForever;
            }

            public String getOcrLanguage() {
                return this.ocrLanguage;
            }

            public Copy setOcrLanguage(String string) {
                this.ocrLanguage = string;
                return this;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Copy setSupportsTeamDrives(Boolean bl) {
                this.supportsTeamDrives = bl;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            @Override
            public Copy set(String string, Object object) {
                return (Copy)super.set(string, object);
            }
        }
    }

    public class Comments {
        public Create create(String string, Comment comment) throws IOException {
            Create create = new Create(string, comment);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Update update(String string, String string2, Comment comment) throws IOException {
            Update update = new Update(string, string2, comment);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DriveRequest<Comment> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}";
            @Key
            private String fileId;
            @Key
            private String commentId;

            protected Update(String string, String string2, Comment comment) {
                super(Drive.this, "PATCH", REST_PATH, (Object)comment, Comment.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter commentId must be specified.");
                this.checkRequiredParameter((Object)comment, "content");
                this.checkRequiredParameter(comment.getContent(), "Comment.getContent()");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Update setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<CommentList> {
            private static final String REST_PATH = "files/{fileId}/comments";
            @Key
            private String fileId;
            @Key
            private Boolean includeDeleted;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String startModifiedTime;

            protected List(String string) {
                super(Drive.this, "GET", REST_PATH, null, CommentList.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public List setIncludeDeleted(Boolean bl) {
                this.includeDeleted = bl;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeDeleted;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getStartModifiedTime() {
                return this.startModifiedTime;
            }

            public List setStartModifiedTime(String string) {
                this.startModifiedTime = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<Comment> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private Boolean includeDeleted;

            protected Get(String string, String string2) {
                super(Drive.this, "GET", REST_PATH, null, Comment.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter commentId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Get setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public Get setIncludeDeleted(Boolean bl) {
                this.includeDeleted = bl;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeDeleted;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}";
            @Key
            private String fileId;
            @Key
            private String commentId;

            protected Delete(String string, String string2) {
                super(Drive.this, "DELETE", REST_PATH, null, Void.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.commentId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter commentId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Delete setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends DriveRequest<Comment> {
            private static final String REST_PATH = "files/{fileId}/comments";
            @Key
            private String fileId;

            protected Create(String string, Comment comment) {
                super(Drive.this, "POST", REST_PATH, (Object)comment, Comment.class);
                this.fileId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter fileId must be specified.");
                this.checkRequiredParameter((Object)comment, "content");
                this.checkRequiredParameter(comment.getContent(), "Comment.getContent()");
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUserIp(String string) {
                return (Create)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Create setFileId(String string) {
                this.fileId = string;
                return this;
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class Channels {
        public Stop stop(Channel channel) throws IOException {
            Stop stop = new Stop(channel);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)stop);
            return stop;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Stop
        extends DriveRequest<Void> {
            private static final String REST_PATH = "channels/stop";

            protected Stop(Channel channel) {
                super(Drive.this, "POST", REST_PATH, (Object)channel, Void.class);
            }

            public Stop setAlt(String string) {
                return (Stop)super.setAlt(string);
            }

            public Stop setFields(String string) {
                return (Stop)super.setFields(string);
            }

            public Stop setKey(String string) {
                return (Stop)super.setKey(string);
            }

            public Stop setOauthToken(String string) {
                return (Stop)super.setOauthToken(string);
            }

            public Stop setPrettyPrint(Boolean bl) {
                return (Stop)super.setPrettyPrint(bl);
            }

            public Stop setQuotaUser(String string) {
                return (Stop)super.setQuotaUser(string);
            }

            public Stop setUserIp(String string) {
                return (Stop)super.setUserIp(string);
            }

            @Override
            public Stop set(String string, Object object) {
                return (Stop)super.set(string, object);
            }
        }
    }

    public class Changes {
        public GetStartPageToken getStartPageToken() throws IOException {
            GetStartPageToken getStartPageToken = new GetStartPageToken();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)getStartPageToken);
            return getStartPageToken;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Watch watch(String string, Channel channel) throws IOException {
            Watch watch = new Watch(string, channel);
            Drive.this.initialize((AbstractGoogleClientRequest<?>)watch);
            return watch;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Watch
        extends DriveRequest<Channel> {
            private static final String REST_PATH = "changes/watch";
            @Key
            private String pageToken;
            @Key
            private Boolean includeCorpusRemovals;
            @Key
            private Boolean includeRemoved;
            @Key
            private Boolean includeTeamDriveItems;
            @Key
            private Integer pageSize;
            @Key
            private Boolean restrictToMyDrive;
            @Key
            private String spaces;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String teamDriveId;

            protected Watch(String string, Channel channel) {
                super(Drive.this, "POST", REST_PATH, (Object)channel, Channel.class);
                this.pageToken = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter pageToken must be specified.");
            }

            public Watch setAlt(String string) {
                return (Watch)super.setAlt(string);
            }

            public Watch setFields(String string) {
                return (Watch)super.setFields(string);
            }

            public Watch setKey(String string) {
                return (Watch)super.setKey(string);
            }

            public Watch setOauthToken(String string) {
                return (Watch)super.setOauthToken(string);
            }

            public Watch setPrettyPrint(Boolean bl) {
                return (Watch)super.setPrettyPrint(bl);
            }

            public Watch setQuotaUser(String string) {
                return (Watch)super.setQuotaUser(string);
            }

            public Watch setUserIp(String string) {
                return (Watch)super.setUserIp(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Watch setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Boolean getIncludeCorpusRemovals() {
                return this.includeCorpusRemovals;
            }

            public Watch setIncludeCorpusRemovals(Boolean bl) {
                this.includeCorpusRemovals = bl;
                return this;
            }

            public boolean isIncludeCorpusRemovals() {
                if (this.includeCorpusRemovals == null || this.includeCorpusRemovals == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeCorpusRemovals;
            }

            public Boolean getIncludeRemoved() {
                return this.includeRemoved;
            }

            public Watch setIncludeRemoved(Boolean bl) {
                this.includeRemoved = bl;
                return this;
            }

            public boolean isIncludeRemoved() {
                if (this.includeRemoved == null || this.includeRemoved == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.includeRemoved;
            }

            public Boolean getIncludeTeamDriveItems() {
                return this.includeTeamDriveItems;
            }

            public Watch setIncludeTeamDriveItems(Boolean bl) {
                this.includeTeamDriveItems = bl;
                return this;
            }

            public boolean isIncludeTeamDriveItems() {
                if (this.includeTeamDriveItems == null || this.includeTeamDriveItems == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeTeamDriveItems;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public Watch setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public Boolean getRestrictToMyDrive() {
                return this.restrictToMyDrive;
            }

            public Watch setRestrictToMyDrive(Boolean bl) {
                this.restrictToMyDrive = bl;
                return this;
            }

            public boolean isRestrictToMyDrive() {
                if (this.restrictToMyDrive == null || this.restrictToMyDrive == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.restrictToMyDrive;
            }

            public String getSpaces() {
                return this.spaces;
            }

            public Watch setSpaces(String string) {
                this.spaces = string;
                return this;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public Watch setSupportsTeamDrives(Boolean bl) {
                this.supportsTeamDrives = bl;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public Watch setTeamDriveId(String string) {
                this.teamDriveId = string;
                return this;
            }

            @Override
            public Watch set(String string, Object object) {
                return (Watch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<ChangeList> {
            private static final String REST_PATH = "changes";
            @Key
            private String pageToken;
            @Key
            private Boolean includeCorpusRemovals;
            @Key
            private Boolean includeRemoved;
            @Key
            private Boolean includeTeamDriveItems;
            @Key
            private Integer pageSize;
            @Key
            private Boolean restrictToMyDrive;
            @Key
            private String spaces;
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String teamDriveId;

            protected List(String string) {
                super(Drive.this, "GET", REST_PATH, null, ChangeList.class);
                this.pageToken = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter pageToken must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Boolean getIncludeCorpusRemovals() {
                return this.includeCorpusRemovals;
            }

            public List setIncludeCorpusRemovals(Boolean bl) {
                this.includeCorpusRemovals = bl;
                return this;
            }

            public boolean isIncludeCorpusRemovals() {
                if (this.includeCorpusRemovals == null || this.includeCorpusRemovals == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeCorpusRemovals;
            }

            public Boolean getIncludeRemoved() {
                return this.includeRemoved;
            }

            public List setIncludeRemoved(Boolean bl) {
                this.includeRemoved = bl;
                return this;
            }

            public boolean isIncludeRemoved() {
                if (this.includeRemoved == null || this.includeRemoved == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.includeRemoved;
            }

            public Boolean getIncludeTeamDriveItems() {
                return this.includeTeamDriveItems;
            }

            public List setIncludeTeamDriveItems(Boolean bl) {
                this.includeTeamDriveItems = bl;
                return this;
            }

            public boolean isIncludeTeamDriveItems() {
                if (this.includeTeamDriveItems == null || this.includeTeamDriveItems == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeTeamDriveItems;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public Boolean getRestrictToMyDrive() {
                return this.restrictToMyDrive;
            }

            public List setRestrictToMyDrive(Boolean bl) {
                this.restrictToMyDrive = bl;
                return this;
            }

            public boolean isRestrictToMyDrive() {
                if (this.restrictToMyDrive == null || this.restrictToMyDrive == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.restrictToMyDrive;
            }

            public String getSpaces() {
                return this.spaces;
            }

            public List setSpaces(String string) {
                this.spaces = string;
                return this;
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public List setSupportsTeamDrives(Boolean bl) {
                this.supportsTeamDrives = bl;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public List setTeamDriveId(String string) {
                this.teamDriveId = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetStartPageToken
        extends DriveRequest<StartPageToken> {
            private static final String REST_PATH = "changes/startPageToken";
            @Key
            private Boolean supportsTeamDrives;
            @Key
            private String teamDriveId;

            protected GetStartPageToken() {
                super(Drive.this, "GET", REST_PATH, null, StartPageToken.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetStartPageToken setAlt(String string) {
                return (GetStartPageToken)super.setAlt(string);
            }

            public GetStartPageToken setFields(String string) {
                return (GetStartPageToken)super.setFields(string);
            }

            public GetStartPageToken setKey(String string) {
                return (GetStartPageToken)super.setKey(string);
            }

            public GetStartPageToken setOauthToken(String string) {
                return (GetStartPageToken)super.setOauthToken(string);
            }

            public GetStartPageToken setPrettyPrint(Boolean bl) {
                return (GetStartPageToken)super.setPrettyPrint(bl);
            }

            public GetStartPageToken setQuotaUser(String string) {
                return (GetStartPageToken)super.setQuotaUser(string);
            }

            public GetStartPageToken setUserIp(String string) {
                return (GetStartPageToken)super.setUserIp(string);
            }

            public Boolean getSupportsTeamDrives() {
                return this.supportsTeamDrives;
            }

            public GetStartPageToken setSupportsTeamDrives(Boolean bl) {
                this.supportsTeamDrives = bl;
                return this;
            }

            public boolean isSupportsTeamDrives() {
                if (this.supportsTeamDrives == null || this.supportsTeamDrives == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.supportsTeamDrives;
            }

            public String getTeamDriveId() {
                return this.teamDriveId;
            }

            public GetStartPageToken setTeamDriveId(String string) {
                this.teamDriveId = string;
                return this;
            }

            @Override
            public GetStartPageToken set(String string, Object object) {
                return (GetStartPageToken)super.set(string, object);
            }
        }
    }

    public class About {
        public Get get() throws IOException {
            Get get = new Get();
            Drive.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<com.google.api.services.drive.model.About> {
            private static final String REST_PATH = "about";

            protected Get() {
                super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.About.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }
}

