/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.driveactivity.v2.model;

/**
 * Information about the action.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive Activity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Action extends com.google.api.client.json.GenericJson {

  /**
   * The actor responsible for this action (or empty if all actors are responsible).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Actor actor;

  /**
   * The type and detailed information about the action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ActionDetail detail;

  /**
   * The target this action affects (or empty if affecting all targets). This represents the state
   * of the target immediately after this action occurred.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Target target;

  /**
   * The action occurred over this time range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeRange timeRange;

  /**
   * The action occurred at this specific time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String timestamp;

  /**
   * The actor responsible for this action (or empty if all actors are responsible).
   * @return value or {@code null} for none
   */
  public Actor getActor() {
    return actor;
  }

  /**
   * The actor responsible for this action (or empty if all actors are responsible).
   * @param actor actor or {@code null} for none
   */
  public Action setActor(Actor actor) {
    this.actor = actor;
    return this;
  }

  /**
   * The type and detailed information about the action.
   * @return value or {@code null} for none
   */
  public ActionDetail getDetail() {
    return detail;
  }

  /**
   * The type and detailed information about the action.
   * @param detail detail or {@code null} for none
   */
  public Action setDetail(ActionDetail detail) {
    this.detail = detail;
    return this;
  }

  /**
   * The target this action affects (or empty if affecting all targets). This represents the state
   * of the target immediately after this action occurred.
   * @return value or {@code null} for none
   */
  public Target getTarget() {
    return target;
  }

  /**
   * The target this action affects (or empty if affecting all targets). This represents the state
   * of the target immediately after this action occurred.
   * @param target target or {@code null} for none
   */
  public Action setTarget(Target target) {
    this.target = target;
    return this;
  }

  /**
   * The action occurred over this time range.
   * @return value or {@code null} for none
   */
  public TimeRange getTimeRange() {
    return timeRange;
  }

  /**
   * The action occurred over this time range.
   * @param timeRange timeRange or {@code null} for none
   */
  public Action setTimeRange(TimeRange timeRange) {
    this.timeRange = timeRange;
    return this;
  }

  /**
   * The action occurred at this specific time.
   * @return value or {@code null} for none
   */
  public String getTimestamp() {
    return timestamp;
  }

  /**
   * The action occurred at this specific time.
   * @param timestamp timestamp or {@code null} for none
   */
  public Action setTimestamp(String timestamp) {
    this.timestamp = timestamp;
    return this;
  }

  @Override
  public Action set(String fieldName, Object value) {
    return (Action) super.set(fieldName, value);
  }

  @Override
  public Action clone() {
    return (Action) super.clone();
  }

}
