/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.driveactivity.v2.model;

/**
 * Data describing the type and additional information of an action.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive Activity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ActionDetail extends com.google.api.client.json.GenericJson {

  /**
   * Label was changed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppliedLabelChange appliedLabelChange;

  /**
   * A change about comments was made.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Comment comment;

  /**
   * An object was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Create create;

  /**
   * An object was deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Delete delete;

  /**
   * A change happened in data leak prevention status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataLeakPreventionChange dlpChange;

  /**
   * An object was edited.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Edit edit;

  /**
   * An object was moved.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Move move;

  /**
   * The permission on an object was changed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PermissionChange permissionChange;

  /**
   * An object was referenced in an application outside of Drive/Docs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ApplicationReference reference;

  /**
   * An object was renamed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Rename rename;

  /**
   * A deleted object was restored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Restore restore;

  /**
   * Settings were changed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SettingsChange settingsChange;

  /**
   * Label was changed.
   * @return value or {@code null} for none
   */
  public AppliedLabelChange getAppliedLabelChange() {
    return appliedLabelChange;
  }

  /**
   * Label was changed.
   * @param appliedLabelChange appliedLabelChange or {@code null} for none
   */
  public ActionDetail setAppliedLabelChange(AppliedLabelChange appliedLabelChange) {
    this.appliedLabelChange = appliedLabelChange;
    return this;
  }

  /**
   * A change about comments was made.
   * @return value or {@code null} for none
   */
  public Comment getComment() {
    return comment;
  }

  /**
   * A change about comments was made.
   * @param comment comment or {@code null} for none
   */
  public ActionDetail setComment(Comment comment) {
    this.comment = comment;
    return this;
  }

  /**
   * An object was created.
   * @return value or {@code null} for none
   */
  public Create getCreate() {
    return create;
  }

  /**
   * An object was created.
   * @param create create or {@code null} for none
   */
  public ActionDetail setCreate(Create create) {
    this.create = create;
    return this;
  }

  /**
   * An object was deleted.
   * @return value or {@code null} for none
   */
  public Delete getDelete() {
    return delete;
  }

  /**
   * An object was deleted.
   * @param delete delete or {@code null} for none
   */
  public ActionDetail setDelete(Delete delete) {
    this.delete = delete;
    return this;
  }

  /**
   * A change happened in data leak prevention status.
   * @return value or {@code null} for none
   */
  public DataLeakPreventionChange getDlpChange() {
    return dlpChange;
  }

  /**
   * A change happened in data leak prevention status.
   * @param dlpChange dlpChange or {@code null} for none
   */
  public ActionDetail setDlpChange(DataLeakPreventionChange dlpChange) {
    this.dlpChange = dlpChange;
    return this;
  }

  /**
   * An object was edited.
   * @return value or {@code null} for none
   */
  public Edit getEdit() {
    return edit;
  }

  /**
   * An object was edited.
   * @param edit edit or {@code null} for none
   */
  public ActionDetail setEdit(Edit edit) {
    this.edit = edit;
    return this;
  }

  /**
   * An object was moved.
   * @return value or {@code null} for none
   */
  public Move getMove() {
    return move;
  }

  /**
   * An object was moved.
   * @param move move or {@code null} for none
   */
  public ActionDetail setMove(Move move) {
    this.move = move;
    return this;
  }

  /**
   * The permission on an object was changed.
   * @return value or {@code null} for none
   */
  public PermissionChange getPermissionChange() {
    return permissionChange;
  }

  /**
   * The permission on an object was changed.
   * @param permissionChange permissionChange or {@code null} for none
   */
  public ActionDetail setPermissionChange(PermissionChange permissionChange) {
    this.permissionChange = permissionChange;
    return this;
  }

  /**
   * An object was referenced in an application outside of Drive/Docs.
   * @return value or {@code null} for none
   */
  public ApplicationReference getReference() {
    return reference;
  }

  /**
   * An object was referenced in an application outside of Drive/Docs.
   * @param reference reference or {@code null} for none
   */
  public ActionDetail setReference(ApplicationReference reference) {
    this.reference = reference;
    return this;
  }

  /**
   * An object was renamed.
   * @return value or {@code null} for none
   */
  public Rename getRename() {
    return rename;
  }

  /**
   * An object was renamed.
   * @param rename rename or {@code null} for none
   */
  public ActionDetail setRename(Rename rename) {
    this.rename = rename;
    return this;
  }

  /**
   * A deleted object was restored.
   * @return value or {@code null} for none
   */
  public Restore getRestore() {
    return restore;
  }

  /**
   * A deleted object was restored.
   * @param restore restore or {@code null} for none
   */
  public ActionDetail setRestore(Restore restore) {
    this.restore = restore;
    return this;
  }

  /**
   * Settings were changed.
   * @return value or {@code null} for none
   */
  public SettingsChange getSettingsChange() {
    return settingsChange;
  }

  /**
   * Settings were changed.
   * @param settingsChange settingsChange or {@code null} for none
   */
  public ActionDetail setSettingsChange(SettingsChange settingsChange) {
    this.settingsChange = settingsChange;
    return this;
  }

  @Override
  public ActionDetail set(String fieldName, Object value) {
    return (ActionDetail) super.set(fieldName, value);
  }

  @Override
  public ActionDetail clone() {
    return (ActionDetail) super.clone();
  }

}
