/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.driveactivity.v2.model;

/**
 * The actor of a Drive activity.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive Activity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Actor extends com.google.api.client.json.GenericJson {

  /**
   * An administrator.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Administrator administrator;

  /**
   * An anonymous user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AnonymousUser anonymous;

  /**
   * An account acting on behalf of another.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Impersonation impersonation;

  /**
   * A non-user actor (i.e. system triggered).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SystemEvent system;

  /**
   * An end user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User user;

  /**
   * An administrator.
   * @return value or {@code null} for none
   */
  public Administrator getAdministrator() {
    return administrator;
  }

  /**
   * An administrator.
   * @param administrator administrator or {@code null} for none
   */
  public Actor setAdministrator(Administrator administrator) {
    this.administrator = administrator;
    return this;
  }

  /**
   * An anonymous user.
   * @return value or {@code null} for none
   */
  public AnonymousUser getAnonymous() {
    return anonymous;
  }

  /**
   * An anonymous user.
   * @param anonymous anonymous or {@code null} for none
   */
  public Actor setAnonymous(AnonymousUser anonymous) {
    this.anonymous = anonymous;
    return this;
  }

  /**
   * An account acting on behalf of another.
   * @return value or {@code null} for none
   */
  public Impersonation getImpersonation() {
    return impersonation;
  }

  /**
   * An account acting on behalf of another.
   * @param impersonation impersonation or {@code null} for none
   */
  public Actor setImpersonation(Impersonation impersonation) {
    this.impersonation = impersonation;
    return this;
  }

  /**
   * A non-user actor (i.e. system triggered).
   * @return value or {@code null} for none
   */
  public SystemEvent getSystem() {
    return system;
  }

  /**
   * A non-user actor (i.e. system triggered).
   * @param system system or {@code null} for none
   */
  public Actor setSystem(SystemEvent system) {
    this.system = system;
    return this;
  }

  /**
   * An end user.
   * @return value or {@code null} for none
   */
  public User getUser() {
    return user;
  }

  /**
   * An end user.
   * @param user user or {@code null} for none
   */
  public Actor setUser(User user) {
    this.user = user;
    return this;
  }

  @Override
  public Actor set(String fieldName, Object value) {
    return (Actor) super.set(fieldName, value);
  }

  @Override
  public Actor clone() {
    return (Actor) super.clone();
  }

}
