/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.driveactivity.v2.model;

/**
 * A change made to a Label on the Target.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive Activity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AppliedLabelChangeDetail extends com.google.api.client.json.GenericJson {

  /**
   * Field Changes. Only present if `types` contains `LABEL_FIELD_VALUE_CHANGED`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FieldValueChange> fieldChanges;

  /**
   * The Label name representing the Label that changed. This name always contains the revision of
   * the Label that was used when this Action occurred. The format is `labels/id@revision`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * The human-readable title of the label that changed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The types of changes made to the Label on the Target.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> types;

  /**
   * Field Changes. Only present if `types` contains `LABEL_FIELD_VALUE_CHANGED`.
   * @return value or {@code null} for none
   */
  public java.util.List<FieldValueChange> getFieldChanges() {
    return fieldChanges;
  }

  /**
   * Field Changes. Only present if `types` contains `LABEL_FIELD_VALUE_CHANGED`.
   * @param fieldChanges fieldChanges or {@code null} for none
   */
  public AppliedLabelChangeDetail setFieldChanges(java.util.List<FieldValueChange> fieldChanges) {
    this.fieldChanges = fieldChanges;
    return this;
  }

  /**
   * The Label name representing the Label that changed. This name always contains the revision of
   * the Label that was used when this Action occurred. The format is `labels/id@revision`.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * The Label name representing the Label that changed. This name always contains the revision of
   * the Label that was used when this Action occurred. The format is `labels/id@revision`.
   * @param label label or {@code null} for none
   */
  public AppliedLabelChangeDetail setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * The human-readable title of the label that changed.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The human-readable title of the label that changed.
   * @param title title or {@code null} for none
   */
  public AppliedLabelChangeDetail setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * The types of changes made to the Label on the Target.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTypes() {
    return types;
  }

  /**
   * The types of changes made to the Label on the Target.
   * @param types types or {@code null} for none
   */
  public AppliedLabelChangeDetail setTypes(java.util.List<java.lang.String> types) {
    this.types = types;
    return this;
  }

  @Override
  public AppliedLabelChangeDetail set(String fieldName, Object value) {
    return (AppliedLabelChangeDetail) super.set(fieldName, value);
  }

  @Override
  public AppliedLabelChangeDetail clone() {
    return (AppliedLabelChangeDetail) super.clone();
  }

}
