/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.driveactivity.v2.model;

/**
 * A comment with an assignment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive Activity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Assignment extends com.google.api.client.json.GenericJson {

  /**
   * The user to whom the comment was assigned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User assignedUser;

  /**
   * The sub-type of this event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subtype;

  /**
   * The user to whom the comment was assigned.
   * @return value or {@code null} for none
   */
  public User getAssignedUser() {
    return assignedUser;
  }

  /**
   * The user to whom the comment was assigned.
   * @param assignedUser assignedUser or {@code null} for none
   */
  public Assignment setAssignedUser(User assignedUser) {
    this.assignedUser = assignedUser;
    return this;
  }

  /**
   * The sub-type of this event.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubtype() {
    return subtype;
  }

  /**
   * The sub-type of this event.
   * @param subtype subtype or {@code null} for none
   */
  public Assignment setSubtype(java.lang.String subtype) {
    this.subtype = subtype;
    return this;
  }

  @Override
  public Assignment set(String fieldName, Object value) {
    return (Assignment) super.set(fieldName, value);
  }

  @Override
  public Assignment clone() {
    return (Assignment) super.clone();
  }

}
