/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.driveactivity.v2.model;

/**
 * A change about comments on an object.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive Activity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Comment extends com.google.api.client.json.GenericJson {

  /**
   * A change on an assignment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Assignment assignment;

  /**
   * Users who are mentioned in this comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<User> mentionedUsers;

  /**
   * A change on a regular posted comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Post post;

  /**
   * A change on a suggestion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Suggestion suggestion;

  /**
   * A change on an assignment.
   * @return value or {@code null} for none
   */
  public Assignment getAssignment() {
    return assignment;
  }

  /**
   * A change on an assignment.
   * @param assignment assignment or {@code null} for none
   */
  public Comment setAssignment(Assignment assignment) {
    this.assignment = assignment;
    return this;
  }

  /**
   * Users who are mentioned in this comment.
   * @return value or {@code null} for none
   */
  public java.util.List<User> getMentionedUsers() {
    return mentionedUsers;
  }

  /**
   * Users who are mentioned in this comment.
   * @param mentionedUsers mentionedUsers or {@code null} for none
   */
  public Comment setMentionedUsers(java.util.List<User> mentionedUsers) {
    this.mentionedUsers = mentionedUsers;
    return this;
  }

  /**
   * A change on a regular posted comment.
   * @return value or {@code null} for none
   */
  public Post getPost() {
    return post;
  }

  /**
   * A change on a regular posted comment.
   * @param post post or {@code null} for none
   */
  public Comment setPost(Post post) {
    this.post = post;
    return this;
  }

  /**
   * A change on a suggestion.
   * @return value or {@code null} for none
   */
  public Suggestion getSuggestion() {
    return suggestion;
  }

  /**
   * A change on a suggestion.
   * @param suggestion suggestion or {@code null} for none
   */
  public Comment setSuggestion(Suggestion suggestion) {
    this.suggestion = suggestion;
    return this;
  }

  @Override
  public Comment set(String fieldName, Object value) {
    return (Comment) super.set(fieldName, value);
  }

  @Override
  public Comment clone() {
    return (Comment) super.clone();
  }

}
