/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.driveactivity.v2.model;

/**
 * How the individual activities are consolidated. If a set of activities is related they can be
 * consolidated into one combined activity, such as one actor performing the same action on multiple
 * targets, or multiple actors performing the same action on a single target. The strategy defines
 * the rules for which activities are related.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive Activity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConsolidationStrategy extends com.google.api.client.json.GenericJson {

  /**
   * The individual activities are consolidated using the legacy strategy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Legacy legacy;

  /**
   * The individual activities are not consolidated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NoConsolidation none;

  /**
   * The individual activities are consolidated using the legacy strategy.
   * @return value or {@code null} for none
   */
  public Legacy getLegacy() {
    return legacy;
  }

  /**
   * The individual activities are consolidated using the legacy strategy.
   * @param legacy legacy or {@code null} for none
   */
  public ConsolidationStrategy setLegacy(Legacy legacy) {
    this.legacy = legacy;
    return this;
  }

  /**
   * The individual activities are not consolidated.
   * @return value or {@code null} for none
   */
  public NoConsolidation getNone() {
    return none;
  }

  /**
   * The individual activities are not consolidated.
   * @param none none or {@code null} for none
   */
  public ConsolidationStrategy setNone(NoConsolidation none) {
    this.none = none;
    return this;
  }

  @Override
  public ConsolidationStrategy set(String fieldName, Object value) {
    return (ConsolidationStrategy) super.set(fieldName, value);
  }

  @Override
  public ConsolidationStrategy clone() {
    return (ConsolidationStrategy) super.clone();
  }

}
