/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.driveactivity.v2.model;

/**
 * An object was created.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive Activity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Create extends com.google.api.client.json.GenericJson {

  /**
   * If present, indicates the object was created by copying an existing Drive object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Copy copy;

  /**
   * If present, indicates the object was newly created (e.g. as a blank document), not derived from
   * a Drive object or external object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("new")
  private DriveActivityNew new__;

  /**
   * If present, indicates the object originated externally and was uploaded to Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Upload upload;

  /**
   * If present, indicates the object was created by copying an existing Drive object.
   * @return value or {@code null} for none
   */
  public Copy getCopy() {
    return copy;
  }

  /**
   * If present, indicates the object was created by copying an existing Drive object.
   * @param copy copy or {@code null} for none
   */
  public Create setCopy(Copy copy) {
    this.copy = copy;
    return this;
  }

  /**
   * If present, indicates the object was newly created (e.g. as a blank document), not derived from
   * a Drive object or external object.
   * @return value or {@code null} for none
   */
  public DriveActivityNew getNew() {
    return new__;
  }

  /**
   * If present, indicates the object was newly created (e.g. as a blank document), not derived from
   * a Drive object or external object.
   * @param new__ new__ or {@code null} for none
   */
  public Create setNew(DriveActivityNew new__) {
    this.new__ = new__;
    return this;
  }

  /**
   * If present, indicates the object originated externally and was uploaded to Drive.
   * @return value or {@code null} for none
   */
  public Upload getUpload() {
    return upload;
  }

  /**
   * If present, indicates the object originated externally and was uploaded to Drive.
   * @param upload upload or {@code null} for none
   */
  public Create setUpload(Upload upload) {
    this.upload = upload;
    return this;
  }

  @Override
  public Create set(String fieldName, Object value) {
    return (Create) super.set(fieldName, value);
  }

  @Override
  public Create clone() {
    return (Create) super.clone();
  }

}
