/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.driveactivity.v2.model;

/**
 * Contains a value of a Field.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive Activity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FieldValue extends com.google.api.client.json.GenericJson {

  /**
   * Date Field value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Date date;

  /**
   * Integer Field value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("integer")
  private DriveActivityInteger integer__;

  /**
   * Selection Field value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Selection selection;

  /**
   * Selection List Field value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SelectionList selectionList;

  /**
   * Text Field value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Text text;

  /**
   * Text List Field value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextList textList;

  /**
   * User Field value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SingleUser user;

  /**
   * User List Field value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UserList userList;

  /**
   * Date Field value.
   * @return value or {@code null} for none
   */
  public Date getDate() {
    return date;
  }

  /**
   * Date Field value.
   * @param date date or {@code null} for none
   */
  public FieldValue setDate(Date date) {
    this.date = date;
    return this;
  }

  /**
   * Integer Field value.
   * @return value or {@code null} for none
   */
  public DriveActivityInteger getInteger() {
    return integer__;
  }

  /**
   * Integer Field value.
   * @param integer__ integer__ or {@code null} for none
   */
  public FieldValue setInteger(DriveActivityInteger integer__) {
    this.integer__ = integer__;
    return this;
  }

  /**
   * Selection Field value.
   * @return value or {@code null} for none
   */
  public Selection getSelection() {
    return selection;
  }

  /**
   * Selection Field value.
   * @param selection selection or {@code null} for none
   */
  public FieldValue setSelection(Selection selection) {
    this.selection = selection;
    return this;
  }

  /**
   * Selection List Field value.
   * @return value or {@code null} for none
   */
  public SelectionList getSelectionList() {
    return selectionList;
  }

  /**
   * Selection List Field value.
   * @param selectionList selectionList or {@code null} for none
   */
  public FieldValue setSelectionList(SelectionList selectionList) {
    this.selectionList = selectionList;
    return this;
  }

  /**
   * Text Field value.
   * @return value or {@code null} for none
   */
  public Text getText() {
    return text;
  }

  /**
   * Text Field value.
   * @param text text or {@code null} for none
   */
  public FieldValue setText(Text text) {
    this.text = text;
    return this;
  }

  /**
   * Text List Field value.
   * @return value or {@code null} for none
   */
  public TextList getTextList() {
    return textList;
  }

  /**
   * Text List Field value.
   * @param textList textList or {@code null} for none
   */
  public FieldValue setTextList(TextList textList) {
    this.textList = textList;
    return this;
  }

  /**
   * User Field value.
   * @return value or {@code null} for none
   */
  public SingleUser getUser() {
    return user;
  }

  /**
   * User Field value.
   * @param user user or {@code null} for none
   */
  public FieldValue setUser(SingleUser user) {
    this.user = user;
    return this;
  }

  /**
   * User List Field value.
   * @return value or {@code null} for none
   */
  public UserList getUserList() {
    return userList;
  }

  /**
   * User List Field value.
   * @param userList userList or {@code null} for none
   */
  public FieldValue setUserList(UserList userList) {
    this.userList = userList;
    return this;
  }

  @Override
  public FieldValue set(String fieldName, Object value) {
    return (FieldValue) super.set(fieldName, value);
  }

  @Override
  public FieldValue clone() {
    return (FieldValue) super.clone();
  }

}
