/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.driveactivity.v2.model;

/**
 * Change to a Field value.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive Activity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FieldValueChange extends com.google.api.client.json.GenericJson {

  /**
   * The human-readable display name for this field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The ID of this field. Field IDs are unique within a Label.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fieldId;

  /**
   * The value that is now set on the field. If not present, the field was cleared. At least one of
   * {old_value|new_value} is always set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FieldValue newValue;

  /**
   * The value that was previously set on the field. If not present, the field was newly set. At
   * least one of {old_value|new_value} is always set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FieldValue oldValue;

  /**
   * The human-readable display name for this field.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The human-readable display name for this field.
   * @param displayName displayName or {@code null} for none
   */
  public FieldValueChange setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The ID of this field. Field IDs are unique within a Label.
   * @return value or {@code null} for none
   */
  public java.lang.String getFieldId() {
    return fieldId;
  }

  /**
   * The ID of this field. Field IDs are unique within a Label.
   * @param fieldId fieldId or {@code null} for none
   */
  public FieldValueChange setFieldId(java.lang.String fieldId) {
    this.fieldId = fieldId;
    return this;
  }

  /**
   * The value that is now set on the field. If not present, the field was cleared. At least one of
   * {old_value|new_value} is always set.
   * @return value or {@code null} for none
   */
  public FieldValue getNewValue() {
    return newValue;
  }

  /**
   * The value that is now set on the field. If not present, the field was cleared. At least one of
   * {old_value|new_value} is always set.
   * @param newValue newValue or {@code null} for none
   */
  public FieldValueChange setNewValue(FieldValue newValue) {
    this.newValue = newValue;
    return this;
  }

  /**
   * The value that was previously set on the field. If not present, the field was newly set. At
   * least one of {old_value|new_value} is always set.
   * @return value or {@code null} for none
   */
  public FieldValue getOldValue() {
    return oldValue;
  }

  /**
   * The value that was previously set on the field. If not present, the field was newly set. At
   * least one of {old_value|new_value} is always set.
   * @param oldValue oldValue or {@code null} for none
   */
  public FieldValueChange setOldValue(FieldValue oldValue) {
    this.oldValue = oldValue;
    return this;
  }

  @Override
  public FieldValueChange set(String fieldName, Object value) {
    return (FieldValueChange) super.set(fieldName, value);
  }

  @Override
  public FieldValueChange clone() {
    return (FieldValueChange) super.clone();
  }

}
