/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.driveactivity.v2.model;

/**
 * A comment on a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive Activity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FileComment extends com.google.api.client.json.GenericJson {

  /**
   * The comment in the discussion thread. This identifier is an opaque string compatible with the
   * Drive API; see https://developers.google.com/drive/v3/reference/comments/get
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String legacyCommentId;

  /**
   * The discussion thread to which the comment was added. This identifier is an opaque string
   * compatible with the Drive API and references the first comment in a discussion; see
   * https://developers.google.com/drive/v3/reference/comments/get
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String legacyDiscussionId;

  /**
   * The link to the discussion thread containing this comment, for example,
   * `https://docs.google.com/DOCUMENT_ID/edit?disco=THREAD_ID`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String linkToDiscussion;

  /**
   * The Drive item containing this comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DriveItem parent;

  /**
   * The comment in the discussion thread. This identifier is an opaque string compatible with the
   * Drive API; see https://developers.google.com/drive/v3/reference/comments/get
   * @return value or {@code null} for none
   */
  public java.lang.String getLegacyCommentId() {
    return legacyCommentId;
  }

  /**
   * The comment in the discussion thread. This identifier is an opaque string compatible with the
   * Drive API; see https://developers.google.com/drive/v3/reference/comments/get
   * @param legacyCommentId legacyCommentId or {@code null} for none
   */
  public FileComment setLegacyCommentId(java.lang.String legacyCommentId) {
    this.legacyCommentId = legacyCommentId;
    return this;
  }

  /**
   * The discussion thread to which the comment was added. This identifier is an opaque string
   * compatible with the Drive API and references the first comment in a discussion; see
   * https://developers.google.com/drive/v3/reference/comments/get
   * @return value or {@code null} for none
   */
  public java.lang.String getLegacyDiscussionId() {
    return legacyDiscussionId;
  }

  /**
   * The discussion thread to which the comment was added. This identifier is an opaque string
   * compatible with the Drive API and references the first comment in a discussion; see
   * https://developers.google.com/drive/v3/reference/comments/get
   * @param legacyDiscussionId legacyDiscussionId or {@code null} for none
   */
  public FileComment setLegacyDiscussionId(java.lang.String legacyDiscussionId) {
    this.legacyDiscussionId = legacyDiscussionId;
    return this;
  }

  /**
   * The link to the discussion thread containing this comment, for example,
   * `https://docs.google.com/DOCUMENT_ID/edit?disco=THREAD_ID`.
   * @return value or {@code null} for none
   */
  public java.lang.String getLinkToDiscussion() {
    return linkToDiscussion;
  }

  /**
   * The link to the discussion thread containing this comment, for example,
   * `https://docs.google.com/DOCUMENT_ID/edit?disco=THREAD_ID`.
   * @param linkToDiscussion linkToDiscussion or {@code null} for none
   */
  public FileComment setLinkToDiscussion(java.lang.String linkToDiscussion) {
    this.linkToDiscussion = linkToDiscussion;
    return this;
  }

  /**
   * The Drive item containing this comment.
   * @return value or {@code null} for none
   */
  public DriveItem getParent() {
    return parent;
  }

  /**
   * The Drive item containing this comment.
   * @param parent parent or {@code null} for none
   */
  public FileComment setParent(DriveItem parent) {
    this.parent = parent;
    return this;
  }

  @Override
  public FileComment set(String fieldName, Object value) {
    return (FileComment) super.set(fieldName, value);
  }

  @Override
  public FileComment clone() {
    return (FileComment) super.clone();
  }

}
