/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.driveactivity.v2.model;

/**
 * Information about an impersonation, where an admin acts on behalf of an end user. Information
 * about the acting admin is not currently available.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive Activity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Impersonation extends com.google.api.client.json.GenericJson {

  /**
   * The impersonated user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User impersonatedUser;

  /**
   * The impersonated user.
   * @return value or {@code null} for none
   */
  public User getImpersonatedUser() {
    return impersonatedUser;
  }

  /**
   * The impersonated user.
   * @param impersonatedUser impersonatedUser or {@code null} for none
   */
  public Impersonation setImpersonatedUser(User impersonatedUser) {
    this.impersonatedUser = impersonatedUser;
    return this;
  }

  @Override
  public Impersonation set(String fieldName, Object value) {
    return (Impersonation) super.set(fieldName, value);
  }

  @Override
  public Impersonation clone() {
    return (Impersonation) super.clone();
  }

}
