/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.driveactivity.v2.model;

/**
 * Information about the owner of a Drive item.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive Activity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Owner extends com.google.api.client.json.GenericJson {

  /**
   * The domain of the Drive item owner.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Domain domain;

  /**
   * The drive that owns the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DriveReference drive;

  /**
   * This field is deprecated; please use the `drive` field instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TeamDriveReference teamDrive;

  /**
   * The user that owns the Drive item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User user;

  /**
   * The domain of the Drive item owner.
   * @return value or {@code null} for none
   */
  public Domain getDomain() {
    return domain;
  }

  /**
   * The domain of the Drive item owner.
   * @param domain domain or {@code null} for none
   */
  public Owner setDomain(Domain domain) {
    this.domain = domain;
    return this;
  }

  /**
   * The drive that owns the item.
   * @return value or {@code null} for none
   */
  public DriveReference getDrive() {
    return drive;
  }

  /**
   * The drive that owns the item.
   * @param drive drive or {@code null} for none
   */
  public Owner setDrive(DriveReference drive) {
    this.drive = drive;
    return this;
  }

  /**
   * This field is deprecated; please use the `drive` field instead.
   * @return value or {@code null} for none
   */
  public TeamDriveReference getTeamDrive() {
    return teamDrive;
  }

  /**
   * This field is deprecated; please use the `drive` field instead.
   * @param teamDrive teamDrive or {@code null} for none
   */
  public Owner setTeamDrive(TeamDriveReference teamDrive) {
    this.teamDrive = teamDrive;
    return this;
  }

  /**
   * The user that owns the Drive item.
   * @return value or {@code null} for none
   */
  public User getUser() {
    return user;
  }

  /**
   * The user that owns the Drive item.
   * @param user user or {@code null} for none
   */
  public Owner setUser(User user) {
    this.user = user;
    return this;
  }

  @Override
  public Owner set(String fieldName, Object value) {
    return (Owner) super.set(fieldName, value);
  }

  @Override
  public Owner clone() {
    return (Owner) super.clone();
  }

}
