/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.driveactivity.v2.model;

/**
 * The permission setting of an object.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive Activity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Permission extends com.google.api.client.json.GenericJson {

  /**
   * If true, the item can be discovered (e.g. in the user's "Shared with me" collection) without
   * needing a link to the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowDiscovery;

  /**
   * If set, this permission applies to anyone, even logged out users.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Anyone anyone;

  /**
   * The domain to whom this permission applies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Domain domain;

  /**
   * The group to whom this permission applies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Group group;

  /**
   * Indicates the [Google Drive permissions role](https://developers.google.com/drive/web/manage-
   * sharing#roles). The role determines a user's ability to read, write, and comment on items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String role;

  /**
   * The user to whom this permission applies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User user;

  /**
   * If true, the item can be discovered (e.g. in the user's "Shared with me" collection) without
   * needing a link to the item.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowDiscovery() {
    return allowDiscovery;
  }

  /**
   * If true, the item can be discovered (e.g. in the user's "Shared with me" collection) without
   * needing a link to the item.
   * @param allowDiscovery allowDiscovery or {@code null} for none
   */
  public Permission setAllowDiscovery(java.lang.Boolean allowDiscovery) {
    this.allowDiscovery = allowDiscovery;
    return this;
  }

  /**
   * If set, this permission applies to anyone, even logged out users.
   * @return value or {@code null} for none
   */
  public Anyone getAnyone() {
    return anyone;
  }

  /**
   * If set, this permission applies to anyone, even logged out users.
   * @param anyone anyone or {@code null} for none
   */
  public Permission setAnyone(Anyone anyone) {
    this.anyone = anyone;
    return this;
  }

  /**
   * The domain to whom this permission applies.
   * @return value or {@code null} for none
   */
  public Domain getDomain() {
    return domain;
  }

  /**
   * The domain to whom this permission applies.
   * @param domain domain or {@code null} for none
   */
  public Permission setDomain(Domain domain) {
    this.domain = domain;
    return this;
  }

  /**
   * The group to whom this permission applies.
   * @return value or {@code null} for none
   */
  public Group getGroup() {
    return group;
  }

  /**
   * The group to whom this permission applies.
   * @param group group or {@code null} for none
   */
  public Permission setGroup(Group group) {
    this.group = group;
    return this;
  }

  /**
   * Indicates the [Google Drive permissions role](https://developers.google.com/drive/web/manage-
   * sharing#roles). The role determines a user's ability to read, write, and comment on items.
   * @return value or {@code null} for none
   */
  public java.lang.String getRole() {
    return role;
  }

  /**
   * Indicates the [Google Drive permissions role](https://developers.google.com/drive/web/manage-
   * sharing#roles). The role determines a user's ability to read, write, and comment on items.
   * @param role role or {@code null} for none
   */
  public Permission setRole(java.lang.String role) {
    this.role = role;
    return this;
  }

  /**
   * The user to whom this permission applies.
   * @return value or {@code null} for none
   */
  public User getUser() {
    return user;
  }

  /**
   * The user to whom this permission applies.
   * @param user user or {@code null} for none
   */
  public Permission setUser(User user) {
    this.user = user;
    return this;
  }

  @Override
  public Permission set(String fieldName, Object value) {
    return (Permission) super.set(fieldName, value);
  }

  @Override
  public Permission clone() {
    return (Permission) super.clone();
  }

}
