/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.driveactivity.v2.model;

/**
 * Information about restriction policy changes to a feature.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive Activity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RestrictionChange extends com.google.api.client.json.GenericJson {

  /**
   * The feature which had a change in restriction policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String feature;

  /**
   * The restriction in place after the change.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String newRestriction;

  /**
   * The feature which had a change in restriction policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getFeature() {
    return feature;
  }

  /**
   * The feature which had a change in restriction policy.
   * @param feature feature or {@code null} for none
   */
  public RestrictionChange setFeature(java.lang.String feature) {
    this.feature = feature;
    return this;
  }

  /**
   * The restriction in place after the change.
   * @return value or {@code null} for none
   */
  public java.lang.String getNewRestriction() {
    return newRestriction;
  }

  /**
   * The restriction in place after the change.
   * @param newRestriction newRestriction or {@code null} for none
   */
  public RestrictionChange setNewRestriction(java.lang.String newRestriction) {
    this.newRestriction = newRestriction;
    return this;
  }

  @Override
  public RestrictionChange set(String fieldName, Object value) {
    return (RestrictionChange) super.set(fieldName, value);
  }

  @Override
  public RestrictionChange clone() {
    return (RestrictionChange) super.clone();
  }

}
