/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.driveactivity.v2.model;

/**
 * Information about an end user.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive Activity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class User extends com.google.api.client.json.GenericJson {

  /**
   * A user whose account has since been deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeletedUser deletedUser;

  /**
   * A known user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private KnownUser knownUser;

  /**
   * A user about whom nothing is currently known.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UnknownUser unknownUser;

  /**
   * A user whose account has since been deleted.
   * @return value or {@code null} for none
   */
  public DeletedUser getDeletedUser() {
    return deletedUser;
  }

  /**
   * A user whose account has since been deleted.
   * @param deletedUser deletedUser or {@code null} for none
   */
  public User setDeletedUser(DeletedUser deletedUser) {
    this.deletedUser = deletedUser;
    return this;
  }

  /**
   * A known user.
   * @return value or {@code null} for none
   */
  public KnownUser getKnownUser() {
    return knownUser;
  }

  /**
   * A known user.
   * @param knownUser knownUser or {@code null} for none
   */
  public User setKnownUser(KnownUser knownUser) {
    this.knownUser = knownUser;
    return this;
  }

  /**
   * A user about whom nothing is currently known.
   * @return value or {@code null} for none
   */
  public UnknownUser getUnknownUser() {
    return unknownUser;
  }

  /**
   * A user about whom nothing is currently known.
   * @param unknownUser unknownUser or {@code null} for none
   */
  public User setUnknownUser(UnknownUser unknownUser) {
    this.unknownUser = unknownUser;
    return this;
  }

  @Override
  public User set(String fieldName, Object value) {
    return (User) super.set(fieldName, value);
  }

  @Override
  public User clone() {
    return (User) super.clone();
  }

}
