/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.driveactivity.v2;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Preconditions;
import com.google.api.services.driveactivity.v2.DriveActivityRequest;
import com.google.api.services.driveactivity.v2.DriveActivityRequestInitializer;
import com.google.api.services.driveactivity.v2.model.QueryDriveActivityRequest;
import com.google.api.services.driveactivity.v2.model.QueryDriveActivityResponse;
import java.io.IOException;

public class DriveActivity
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://driveactivity.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://driveactivity.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://driveactivity.googleapis.com/";

    public DriveActivity(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    DriveActivity(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Activity activity() {
        return new Activity();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Drive Activity API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return DriveActivity.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://driveactivity.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), DriveActivity.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(DriveActivity.DEFAULT_BATCH_PATH);
        }

        public DriveActivity build() {
            return new DriveActivity(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDriveActivityRequestInitializer(DriveActivityRequestInitializer driveactivityRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)driveactivityRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Activity {
        public Query query(QueryDriveActivityRequest content) throws IOException {
            Query result = new Query(content);
            DriveActivity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Query
        extends DriveActivityRequest<QueryDriveActivityResponse> {
            private static final String REST_PATH = "v2/activity:query";

            protected Query(QueryDriveActivityRequest content) {
                super(DriveActivity.this, "POST", REST_PATH, (Object)content, QueryDriveActivityResponse.class);
            }

            public Query set$Xgafv(String $Xgafv) {
                return (Query)super.set$Xgafv($Xgafv);
            }

            public Query setAccessToken(String accessToken) {
                return (Query)super.setAccessToken(accessToken);
            }

            public Query setAlt(String alt) {
                return (Query)super.setAlt(alt);
            }

            public Query setCallback(String callback) {
                return (Query)super.setCallback(callback);
            }

            public Query setFields(String fields) {
                return (Query)super.setFields(fields);
            }

            public Query setKey(String key) {
                return (Query)super.setKey(key);
            }

            public Query setOauthToken(String oauthToken) {
                return (Query)super.setOauthToken(oauthToken);
            }

            public Query setPrettyPrint(Boolean prettyPrint) {
                return (Query)super.setPrettyPrint(prettyPrint);
            }

            public Query setQuotaUser(String quotaUser) {
                return (Query)super.setQuotaUser(quotaUser);
            }

            public Query setUploadType(String uploadType) {
                return (Query)super.setUploadType(uploadType);
            }

            public Query setUploadProtocol(String uploadProtocol) {
                return (Query)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Query set(String parameterName, Object value) {
                return (Query)super.set(parameterName, value);
            }
        }
    }
}

