# Firebase Dynamic Links API Client Library for Java

Programmatically creates and manages Firebase Dynamic Links.

This page contains information about getting started with the Firebase Dynamic Links API
using the Google API Client Library for Java. In addition, you may be interested
in the following documentation:

* Browse the [Javadoc reference for the Firebase Dynamic Links API][javadoc]
* Read the [Developer's Guide for the Google API Client Library for Java][google-api-client].
* Interact with this API in your browser using the [APIs Explorer for the Firebase Dynamic Links API][api-explorer]

## Installation

### Maven

Add the following lines to your `pom.xml` file:

```xml
<project>
  <dependencies>
    <dependency>
      <groupId>com.google.apis</groupId>
      <artifactId>google-api-services-firebasedynamiclinks</artifactId>
      <version>v1-rev20200905-1.30.10</version>
    </dependency>
  </dependencies>
</project>
```

### Gradle

```gradle
repositories {
  mavenCentral()
}
dependencies {
  compile 'com.google.apis:google-api-services-firebasedynamiclinks:v1-rev20200905-1.30.10'
}
```

[javadoc]: https://googleapis.dev/java/google-api-services-firebasedynamiclinks/latest/index.html
[google-api-client]: https://github.com/googleapis/google-api-java-client/
[api-explorer]: https://developers.google.com/apis-explorer/#p/firebasedynamiclinks/v1/
