/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.firebasedynamiclinks.v1.model;

/**
 * Tracking parameters supported by Dynamic Link.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Firebase Dynamic Links API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AnalyticsInfo extends com.google.api.client.json.GenericJson {

  /**
   * Google Play Campaign Measurements.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GooglePlayAnalytics googlePlayAnalytics;

  /**
   * iTunes Connect App Analytics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ITunesConnectAnalytics itunesConnectAnalytics;

  /**
   * Google Play Campaign Measurements.
   * @return value or {@code null} for none
   */
  public GooglePlayAnalytics getGooglePlayAnalytics() {
    return googlePlayAnalytics;
  }

  /**
   * Google Play Campaign Measurements.
   * @param googlePlayAnalytics googlePlayAnalytics or {@code null} for none
   */
  public AnalyticsInfo setGooglePlayAnalytics(GooglePlayAnalytics googlePlayAnalytics) {
    this.googlePlayAnalytics = googlePlayAnalytics;
    return this;
  }

  /**
   * iTunes Connect App Analytics.
   * @return value or {@code null} for none
   */
  public ITunesConnectAnalytics getItunesConnectAnalytics() {
    return itunesConnectAnalytics;
  }

  /**
   * iTunes Connect App Analytics.
   * @param itunesConnectAnalytics itunesConnectAnalytics or {@code null} for none
   */
  public AnalyticsInfo setItunesConnectAnalytics(ITunesConnectAnalytics itunesConnectAnalytics) {
    this.itunesConnectAnalytics = itunesConnectAnalytics;
    return this;
  }

  @Override
  public AnalyticsInfo set(String fieldName, Object value) {
    return (AnalyticsInfo) super.set(fieldName, value);
  }

  @Override
  public AnalyticsInfo clone() {
    return (AnalyticsInfo) super.clone();
  }

}
