/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.firebasedynamiclinks.v1.model;

/**
 * Signals associated with the device making the request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Firebase Dynamic Links API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeviceInfo extends com.google.api.client.json.GenericJson {

  /**
   * Device model name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deviceModelName;

  /**
   * Device language code setting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCode;

  /**
   * Device language code setting obtained by executing JavaScript code in WebView.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCodeFromWebview;

  /**
   * Device language code raw setting. iOS does returns language code in different format than iOS
   * WebView. For example WebView returns en_US, but iOS returns en-US. Field below will return raw
   * value returned by iOS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCodeRaw;

  /**
   * Device display resolution height.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long screenResolutionHeight;

  /**
   * Device display resolution width.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long screenResolutionWidth;

  /**
   * Device timezone setting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timezone;

  /**
   * Device model name.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeviceModelName() {
    return deviceModelName;
  }

  /**
   * Device model name.
   * @param deviceModelName deviceModelName or {@code null} for none
   */
  public DeviceInfo setDeviceModelName(java.lang.String deviceModelName) {
    this.deviceModelName = deviceModelName;
    return this;
  }

  /**
   * Device language code setting.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCode() {
    return languageCode;
  }

  /**
   * Device language code setting.
   * @param languageCode languageCode or {@code null} for none
   */
  public DeviceInfo setLanguageCode(java.lang.String languageCode) {
    this.languageCode = languageCode;
    return this;
  }

  /**
   * Device language code setting obtained by executing JavaScript code in WebView.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCodeFromWebview() {
    return languageCodeFromWebview;
  }

  /**
   * Device language code setting obtained by executing JavaScript code in WebView.
   * @param languageCodeFromWebview languageCodeFromWebview or {@code null} for none
   */
  public DeviceInfo setLanguageCodeFromWebview(java.lang.String languageCodeFromWebview) {
    this.languageCodeFromWebview = languageCodeFromWebview;
    return this;
  }

  /**
   * Device language code raw setting. iOS does returns language code in different format than iOS
   * WebView. For example WebView returns en_US, but iOS returns en-US. Field below will return raw
   * value returned by iOS.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCodeRaw() {
    return languageCodeRaw;
  }

  /**
   * Device language code raw setting. iOS does returns language code in different format than iOS
   * WebView. For example WebView returns en_US, but iOS returns en-US. Field below will return raw
   * value returned by iOS.
   * @param languageCodeRaw languageCodeRaw or {@code null} for none
   */
  public DeviceInfo setLanguageCodeRaw(java.lang.String languageCodeRaw) {
    this.languageCodeRaw = languageCodeRaw;
    return this;
  }

  /**
   * Device display resolution height.
   * @return value or {@code null} for none
   */
  public java.lang.Long getScreenResolutionHeight() {
    return screenResolutionHeight;
  }

  /**
   * Device display resolution height.
   * @param screenResolutionHeight screenResolutionHeight or {@code null} for none
   */
  public DeviceInfo setScreenResolutionHeight(java.lang.Long screenResolutionHeight) {
    this.screenResolutionHeight = screenResolutionHeight;
    return this;
  }

  /**
   * Device display resolution width.
   * @return value or {@code null} for none
   */
  public java.lang.Long getScreenResolutionWidth() {
    return screenResolutionWidth;
  }

  /**
   * Device display resolution width.
   * @param screenResolutionWidth screenResolutionWidth or {@code null} for none
   */
  public DeviceInfo setScreenResolutionWidth(java.lang.Long screenResolutionWidth) {
    this.screenResolutionWidth = screenResolutionWidth;
    return this;
  }

  /**
   * Device timezone setting.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimezone() {
    return timezone;
  }

  /**
   * Device timezone setting.
   * @param timezone timezone or {@code null} for none
   */
  public DeviceInfo setTimezone(java.lang.String timezone) {
    this.timezone = timezone;
    return this;
  }

  @Override
  public DeviceInfo set(String fieldName, Object value) {
    return (DeviceInfo) super.set(fieldName, value);
  }

  @Override
  public DeviceInfo clone() {
    return (DeviceInfo) super.clone();
  }

}
