/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.firebasedynamiclinks.v1.model;

/**
 * Dynamic Link event stat.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Firebase Dynamic Links API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DynamicLinkEventStat extends com.google.api.client.json.GenericJson {

  /**
   * The number of times this event occurred.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long count;

  /**
   * Link event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String event;

  /**
   * Requested platform.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String platform;

  /**
   * The number of times this event occurred.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCount() {
    return count;
  }

  /**
   * The number of times this event occurred.
   * @param count count or {@code null} for none
   */
  public DynamicLinkEventStat setCount(java.lang.Long count) {
    this.count = count;
    return this;
  }

  /**
   * Link event.
   * @return value or {@code null} for none
   */
  public java.lang.String getEvent() {
    return event;
  }

  /**
   * Link event.
   * @param event event or {@code null} for none
   */
  public DynamicLinkEventStat setEvent(java.lang.String event) {
    this.event = event;
    return this;
  }

  /**
   * Requested platform.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlatform() {
    return platform;
  }

  /**
   * Requested platform.
   * @param platform platform or {@code null} for none
   */
  public DynamicLinkEventStat setPlatform(java.lang.String platform) {
    this.platform = platform;
    return this;
  }

  @Override
  public DynamicLinkEventStat set(String fieldName, Object value) {
    return (DynamicLinkEventStat) super.set(fieldName, value);
  }

  @Override
  public DynamicLinkEventStat clone() {
    return (DynamicLinkEventStat) super.clone();
  }

}
