/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.firebasedynamiclinks.v1.model;

/**
 * Analytics stats of a Dynamic Link for a given timeframe.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Firebase Dynamic Links API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DynamicLinkStats extends com.google.api.client.json.GenericJson {

  /**
   * Dynamic Link event stats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DynamicLinkEventStat> linkEventStats;

  static {
    // hack to force ProGuard to consider DynamicLinkEventStat used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DynamicLinkEventStat.class);
  }

  /**
   * Dynamic Link event stats.
   * @return value or {@code null} for none
   */
  public java.util.List<DynamicLinkEventStat> getLinkEventStats() {
    return linkEventStats;
  }

  /**
   * Dynamic Link event stats.
   * @param linkEventStats linkEventStats or {@code null} for none
   */
  public DynamicLinkStats setLinkEventStats(java.util.List<DynamicLinkEventStat> linkEventStats) {
    this.linkEventStats = linkEventStats;
    return this;
  }

  @Override
  public DynamicLinkStats set(String fieldName, Object value) {
    return (DynamicLinkStats) super.set(fieldName, value);
  }

  @Override
  public DynamicLinkStats clone() {
    return (DynamicLinkStats) super.clone();
  }

}
