/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.firebasedynamiclinks.v1.model;

/**
 * Dynamic Links warning messages.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Firebase Dynamic Links API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DynamicLinkWarning extends com.google.api.client.json.GenericJson {

  /**
   * The warning code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String warningCode;

  /**
   * The document describing the warning, and helps resolve.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String warningDocumentLink;

  /**
   * The warning message to help developers improve their requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String warningMessage;

  /**
   * The warning code.
   * @return value or {@code null} for none
   */
  public java.lang.String getWarningCode() {
    return warningCode;
  }

  /**
   * The warning code.
   * @param warningCode warningCode or {@code null} for none
   */
  public DynamicLinkWarning setWarningCode(java.lang.String warningCode) {
    this.warningCode = warningCode;
    return this;
  }

  /**
   * The document describing the warning, and helps resolve.
   * @return value or {@code null} for none
   */
  public java.lang.String getWarningDocumentLink() {
    return warningDocumentLink;
  }

  /**
   * The document describing the warning, and helps resolve.
   * @param warningDocumentLink warningDocumentLink or {@code null} for none
   */
  public DynamicLinkWarning setWarningDocumentLink(java.lang.String warningDocumentLink) {
    this.warningDocumentLink = warningDocumentLink;
    return this;
  }

  /**
   * The warning message to help developers improve their requests.
   * @return value or {@code null} for none
   */
  public java.lang.String getWarningMessage() {
    return warningMessage;
  }

  /**
   * The warning message to help developers improve their requests.
   * @param warningMessage warningMessage or {@code null} for none
   */
  public DynamicLinkWarning setWarningMessage(java.lang.String warningMessage) {
    this.warningMessage = warningMessage;
    return this;
  }

  @Override
  public DynamicLinkWarning set(String fieldName, Object value) {
    return (DynamicLinkWarning) super.set(fieldName, value);
  }

  @Override
  public DynamicLinkWarning clone() {
    return (DynamicLinkWarning) super.clone();
  }

}
