/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.firebasedynamiclinks.v1.model;

/**
 * Request for iSDK to execute strong match flow for post-install attribution. This is meant for iOS
 * requests only. Requests from other platforms will not be honored.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Firebase Dynamic Links API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GetIosPostInstallAttributionRequest extends com.google.api.client.json.GenericJson {

  /**
   * App installation epoch time (https://en.wikipedia.org/wiki/Unix_time). This is a client signal
   * for a more accurate weak match.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long appInstallationTime;

  /**
   * APP bundle ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bundleId;

  /**
   * Device information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeviceInfo device;

  /**
   * iOS version, ie: 9.3.5. Consider adding "build".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iosVersion;

  /**
   * App post install attribution retrieval information. Disambiguates mechanism (iSDK or developer
   * invoked) to retrieve payload from clicked link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String retrievalMethod;

  /**
   * Google SDK version. Version takes the form "$major.$minor.$patch"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sdkVersion;

  /**
   * Possible unique matched link that server need to check before performing fingerprint match. If
   * passed link is short server need to expand the link. If link is long server need to vslidate
   * the link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uniqueMatchLinkToCheck;

  /**
   * Strong match page information. Disambiguates between default UI and custom page to present when
   * strong match succeeds/fails to find cookie.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String visualStyle;

  /**
   * App installation epoch time (https://en.wikipedia.org/wiki/Unix_time). This is a client signal
   * for a more accurate weak match.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAppInstallationTime() {
    return appInstallationTime;
  }

  /**
   * App installation epoch time (https://en.wikipedia.org/wiki/Unix_time). This is a client signal
   * for a more accurate weak match.
   * @param appInstallationTime appInstallationTime or {@code null} for none
   */
  public GetIosPostInstallAttributionRequest setAppInstallationTime(java.lang.Long appInstallationTime) {
    this.appInstallationTime = appInstallationTime;
    return this;
  }

  /**
   * APP bundle ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getBundleId() {
    return bundleId;
  }

  /**
   * APP bundle ID.
   * @param bundleId bundleId or {@code null} for none
   */
  public GetIosPostInstallAttributionRequest setBundleId(java.lang.String bundleId) {
    this.bundleId = bundleId;
    return this;
  }

  /**
   * Device information.
   * @return value or {@code null} for none
   */
  public DeviceInfo getDevice() {
    return device;
  }

  /**
   * Device information.
   * @param device device or {@code null} for none
   */
  public GetIosPostInstallAttributionRequest setDevice(DeviceInfo device) {
    this.device = device;
    return this;
  }

  /**
   * iOS version, ie: 9.3.5. Consider adding "build".
   * @return value or {@code null} for none
   */
  public java.lang.String getIosVersion() {
    return iosVersion;
  }

  /**
   * iOS version, ie: 9.3.5. Consider adding "build".
   * @param iosVersion iosVersion or {@code null} for none
   */
  public GetIosPostInstallAttributionRequest setIosVersion(java.lang.String iosVersion) {
    this.iosVersion = iosVersion;
    return this;
  }

  /**
   * App post install attribution retrieval information. Disambiguates mechanism (iSDK or developer
   * invoked) to retrieve payload from clicked link.
   * @return value or {@code null} for none
   */
  public java.lang.String getRetrievalMethod() {
    return retrievalMethod;
  }

  /**
   * App post install attribution retrieval information. Disambiguates mechanism (iSDK or developer
   * invoked) to retrieve payload from clicked link.
   * @param retrievalMethod retrievalMethod or {@code null} for none
   */
  public GetIosPostInstallAttributionRequest setRetrievalMethod(java.lang.String retrievalMethod) {
    this.retrievalMethod = retrievalMethod;
    return this;
  }

  /**
   * Google SDK version. Version takes the form "$major.$minor.$patch"
   * @return value or {@code null} for none
   */
  public java.lang.String getSdkVersion() {
    return sdkVersion;
  }

  /**
   * Google SDK version. Version takes the form "$major.$minor.$patch"
   * @param sdkVersion sdkVersion or {@code null} for none
   */
  public GetIosPostInstallAttributionRequest setSdkVersion(java.lang.String sdkVersion) {
    this.sdkVersion = sdkVersion;
    return this;
  }

  /**
   * Possible unique matched link that server need to check before performing fingerprint match. If
   * passed link is short server need to expand the link. If link is long server need to vslidate
   * the link.
   * @return value or {@code null} for none
   */
  public java.lang.String getUniqueMatchLinkToCheck() {
    return uniqueMatchLinkToCheck;
  }

  /**
   * Possible unique matched link that server need to check before performing fingerprint match. If
   * passed link is short server need to expand the link. If link is long server need to vslidate
   * the link.
   * @param uniqueMatchLinkToCheck uniqueMatchLinkToCheck or {@code null} for none
   */
  public GetIosPostInstallAttributionRequest setUniqueMatchLinkToCheck(java.lang.String uniqueMatchLinkToCheck) {
    this.uniqueMatchLinkToCheck = uniqueMatchLinkToCheck;
    return this;
  }

  /**
   * Strong match page information. Disambiguates between default UI and custom page to present when
   * strong match succeeds/fails to find cookie.
   * @return value or {@code null} for none
   */
  public java.lang.String getVisualStyle() {
    return visualStyle;
  }

  /**
   * Strong match page information. Disambiguates between default UI and custom page to present when
   * strong match succeeds/fails to find cookie.
   * @param visualStyle visualStyle or {@code null} for none
   */
  public GetIosPostInstallAttributionRequest setVisualStyle(java.lang.String visualStyle) {
    this.visualStyle = visualStyle;
    return this;
  }

  @Override
  public GetIosPostInstallAttributionRequest set(String fieldName, Object value) {
    return (GetIosPostInstallAttributionRequest) super.set(fieldName, value);
  }

  @Override
  public GetIosPostInstallAttributionRequest clone() {
    return (GetIosPostInstallAttributionRequest) super.clone();
  }

}
