/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.firebasedynamiclinks.v1.model;

/**
 * Response for iSDK to execute strong match flow for post-install attribution.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Firebase Dynamic Links API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GetIosPostInstallAttributionResponse extends com.google.api.client.json.GenericJson {

  /**
   * The minimum version for app, specified by dev through ?imv= parameter. Return to iSDK to allow
   * app to evaluate if current version meets this.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String appMinimumVersion;

  /**
   * The confidence of the returned attribution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String attributionConfidence;

  /**
   * The deep-link attributed post-install via one of several techniques (fingerprint, copy unique).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deepLink;

  /**
   * User-agent specific custom-scheme URIs for iSDK to open. This will be set according to the
   * user-agent tha the click was originally made in. There is no Safari-equivalent custom-scheme
   * open URLs. ie: googlechrome://www.example.com ie: firefox://open-url?url=http://www.example.com
   * ie: opera-http://example.com
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String externalBrowserDestinationLink;

  /**
   * The link to navigate to update the app if min version is not met. This is either (in order): 1)
   * fallback link (from ?ifl= parameter, if specified by developer) or 2) AppStore URL (from ?isi=
   * parameter, if specified), or 3) the payload link (from required link= parameter).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fallbackLink;

  /**
   * Invitation ID attributed post-install via one of several techniques (fingerprint, copy unique).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String invitationId;

  /**
   * Instruction for iSDK to attemmpt to perform strong match. For instance, if browser does not
   * support/allow cookie or outside of support browsers, this will be false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isStrongMatchExecutable;

  /**
   * Describes why match failed, ie: "discarded due to low confidence". This message will be
   * publicly visible.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String matchMessage;

  /**
   * Which IP version the request was made from.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestIpVersion;

  /**
   * Entire FDL (short or long) attributed post-install via one of several techniques (fingerprint,
   * copy unique).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestedLink;

  /**
   * The entire FDL, expanded from a short link. It is the same as the requested_link, if it is
   * long. Parameters from this should not be used directly (ie: server can default
   * utm_[campaign|medium|source] to a value when requested_link lack them, server determine the
   * best fallback_link when requested_link specifies >1 fallback links).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resolvedLink;

  /**
   * Scion campaign value to be propagated by iSDK to Scion at post-install.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String utmCampaign;

  /**
   * Scion content value to be propagated by iSDK to Scion at app-reopen.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String utmContent;

  /**
   * Scion medium value to be propagated by iSDK to Scion at post-install.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String utmMedium;

  /**
   * Scion source value to be propagated by iSDK to Scion at post-install.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String utmSource;

  /**
   * Scion term value to be propagated by iSDK to Scion at app-reopen.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String utmTerm;

  /**
   * The minimum version for app, specified by dev through ?imv= parameter. Return to iSDK to allow
   * app to evaluate if current version meets this.
   * @return value or {@code null} for none
   */
  public java.lang.String getAppMinimumVersion() {
    return appMinimumVersion;
  }

  /**
   * The minimum version for app, specified by dev through ?imv= parameter. Return to iSDK to allow
   * app to evaluate if current version meets this.
   * @param appMinimumVersion appMinimumVersion or {@code null} for none
   */
  public GetIosPostInstallAttributionResponse setAppMinimumVersion(java.lang.String appMinimumVersion) {
    this.appMinimumVersion = appMinimumVersion;
    return this;
  }

  /**
   * The confidence of the returned attribution.
   * @return value or {@code null} for none
   */
  public java.lang.String getAttributionConfidence() {
    return attributionConfidence;
  }

  /**
   * The confidence of the returned attribution.
   * @param attributionConfidence attributionConfidence or {@code null} for none
   */
  public GetIosPostInstallAttributionResponse setAttributionConfidence(java.lang.String attributionConfidence) {
    this.attributionConfidence = attributionConfidence;
    return this;
  }

  /**
   * The deep-link attributed post-install via one of several techniques (fingerprint, copy unique).
   * @return value or {@code null} for none
   */
  public java.lang.String getDeepLink() {
    return deepLink;
  }

  /**
   * The deep-link attributed post-install via one of several techniques (fingerprint, copy unique).
   * @param deepLink deepLink or {@code null} for none
   */
  public GetIosPostInstallAttributionResponse setDeepLink(java.lang.String deepLink) {
    this.deepLink = deepLink;
    return this;
  }

  /**
   * User-agent specific custom-scheme URIs for iSDK to open. This will be set according to the
   * user-agent tha the click was originally made in. There is no Safari-equivalent custom-scheme
   * open URLs. ie: googlechrome://www.example.com ie: firefox://open-url?url=http://www.example.com
   * ie: opera-http://example.com
   * @return value or {@code null} for none
   */
  public java.lang.String getExternalBrowserDestinationLink() {
    return externalBrowserDestinationLink;
  }

  /**
   * User-agent specific custom-scheme URIs for iSDK to open. This will be set according to the
   * user-agent tha the click was originally made in. There is no Safari-equivalent custom-scheme
   * open URLs. ie: googlechrome://www.example.com ie: firefox://open-url?url=http://www.example.com
   * ie: opera-http://example.com
   * @param externalBrowserDestinationLink externalBrowserDestinationLink or {@code null} for none
   */
  public GetIosPostInstallAttributionResponse setExternalBrowserDestinationLink(java.lang.String externalBrowserDestinationLink) {
    this.externalBrowserDestinationLink = externalBrowserDestinationLink;
    return this;
  }

  /**
   * The link to navigate to update the app if min version is not met. This is either (in order): 1)
   * fallback link (from ?ifl= parameter, if specified by developer) or 2) AppStore URL (from ?isi=
   * parameter, if specified), or 3) the payload link (from required link= parameter).
   * @return value or {@code null} for none
   */
  public java.lang.String getFallbackLink() {
    return fallbackLink;
  }

  /**
   * The link to navigate to update the app if min version is not met. This is either (in order): 1)
   * fallback link (from ?ifl= parameter, if specified by developer) or 2) AppStore URL (from ?isi=
   * parameter, if specified), or 3) the payload link (from required link= parameter).
   * @param fallbackLink fallbackLink or {@code null} for none
   */
  public GetIosPostInstallAttributionResponse setFallbackLink(java.lang.String fallbackLink) {
    this.fallbackLink = fallbackLink;
    return this;
  }

  /**
   * Invitation ID attributed post-install via one of several techniques (fingerprint, copy unique).
   * @return value or {@code null} for none
   */
  public java.lang.String getInvitationId() {
    return invitationId;
  }

  /**
   * Invitation ID attributed post-install via one of several techniques (fingerprint, copy unique).
   * @param invitationId invitationId or {@code null} for none
   */
  public GetIosPostInstallAttributionResponse setInvitationId(java.lang.String invitationId) {
    this.invitationId = invitationId;
    return this;
  }

  /**
   * Instruction for iSDK to attemmpt to perform strong match. For instance, if browser does not
   * support/allow cookie or outside of support browsers, this will be false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsStrongMatchExecutable() {
    return isStrongMatchExecutable;
  }

  /**
   * Instruction for iSDK to attemmpt to perform strong match. For instance, if browser does not
   * support/allow cookie or outside of support browsers, this will be false.
   * @param isStrongMatchExecutable isStrongMatchExecutable or {@code null} for none
   */
  public GetIosPostInstallAttributionResponse setIsStrongMatchExecutable(java.lang.Boolean isStrongMatchExecutable) {
    this.isStrongMatchExecutable = isStrongMatchExecutable;
    return this;
  }

  /**
   * Describes why match failed, ie: "discarded due to low confidence". This message will be
   * publicly visible.
   * @return value or {@code null} for none
   */
  public java.lang.String getMatchMessage() {
    return matchMessage;
  }

  /**
   * Describes why match failed, ie: "discarded due to low confidence". This message will be
   * publicly visible.
   * @param matchMessage matchMessage or {@code null} for none
   */
  public GetIosPostInstallAttributionResponse setMatchMessage(java.lang.String matchMessage) {
    this.matchMessage = matchMessage;
    return this;
  }

  /**
   * Which IP version the request was made from.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestIpVersion() {
    return requestIpVersion;
  }

  /**
   * Which IP version the request was made from.
   * @param requestIpVersion requestIpVersion or {@code null} for none
   */
  public GetIosPostInstallAttributionResponse setRequestIpVersion(java.lang.String requestIpVersion) {
    this.requestIpVersion = requestIpVersion;
    return this;
  }

  /**
   * Entire FDL (short or long) attributed post-install via one of several techniques (fingerprint,
   * copy unique).
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestedLink() {
    return requestedLink;
  }

  /**
   * Entire FDL (short or long) attributed post-install via one of several techniques (fingerprint,
   * copy unique).
   * @param requestedLink requestedLink or {@code null} for none
   */
  public GetIosPostInstallAttributionResponse setRequestedLink(java.lang.String requestedLink) {
    this.requestedLink = requestedLink;
    return this;
  }

  /**
   * The entire FDL, expanded from a short link. It is the same as the requested_link, if it is
   * long. Parameters from this should not be used directly (ie: server can default
   * utm_[campaign|medium|source] to a value when requested_link lack them, server determine the
   * best fallback_link when requested_link specifies >1 fallback links).
   * @return value or {@code null} for none
   */
  public java.lang.String getResolvedLink() {
    return resolvedLink;
  }

  /**
   * The entire FDL, expanded from a short link. It is the same as the requested_link, if it is
   * long. Parameters from this should not be used directly (ie: server can default
   * utm_[campaign|medium|source] to a value when requested_link lack them, server determine the
   * best fallback_link when requested_link specifies >1 fallback links).
   * @param resolvedLink resolvedLink or {@code null} for none
   */
  public GetIosPostInstallAttributionResponse setResolvedLink(java.lang.String resolvedLink) {
    this.resolvedLink = resolvedLink;
    return this;
  }

  /**
   * Scion campaign value to be propagated by iSDK to Scion at post-install.
   * @return value or {@code null} for none
   */
  public java.lang.String getUtmCampaign() {
    return utmCampaign;
  }

  /**
   * Scion campaign value to be propagated by iSDK to Scion at post-install.
   * @param utmCampaign utmCampaign or {@code null} for none
   */
  public GetIosPostInstallAttributionResponse setUtmCampaign(java.lang.String utmCampaign) {
    this.utmCampaign = utmCampaign;
    return this;
  }

  /**
   * Scion content value to be propagated by iSDK to Scion at app-reopen.
   * @return value or {@code null} for none
   */
  public java.lang.String getUtmContent() {
    return utmContent;
  }

  /**
   * Scion content value to be propagated by iSDK to Scion at app-reopen.
   * @param utmContent utmContent or {@code null} for none
   */
  public GetIosPostInstallAttributionResponse setUtmContent(java.lang.String utmContent) {
    this.utmContent = utmContent;
    return this;
  }

  /**
   * Scion medium value to be propagated by iSDK to Scion at post-install.
   * @return value or {@code null} for none
   */
  public java.lang.String getUtmMedium() {
    return utmMedium;
  }

  /**
   * Scion medium value to be propagated by iSDK to Scion at post-install.
   * @param utmMedium utmMedium or {@code null} for none
   */
  public GetIosPostInstallAttributionResponse setUtmMedium(java.lang.String utmMedium) {
    this.utmMedium = utmMedium;
    return this;
  }

  /**
   * Scion source value to be propagated by iSDK to Scion at post-install.
   * @return value or {@code null} for none
   */
  public java.lang.String getUtmSource() {
    return utmSource;
  }

  /**
   * Scion source value to be propagated by iSDK to Scion at post-install.
   * @param utmSource utmSource or {@code null} for none
   */
  public GetIosPostInstallAttributionResponse setUtmSource(java.lang.String utmSource) {
    this.utmSource = utmSource;
    return this;
  }

  /**
   * Scion term value to be propagated by iSDK to Scion at app-reopen.
   * @return value or {@code null} for none
   */
  public java.lang.String getUtmTerm() {
    return utmTerm;
  }

  /**
   * Scion term value to be propagated by iSDK to Scion at app-reopen.
   * @param utmTerm utmTerm or {@code null} for none
   */
  public GetIosPostInstallAttributionResponse setUtmTerm(java.lang.String utmTerm) {
    this.utmTerm = utmTerm;
    return this;
  }

  @Override
  public GetIosPostInstallAttributionResponse set(String fieldName, Object value) {
    return (GetIosPostInstallAttributionResponse) super.set(fieldName, value);
  }

  @Override
  public GetIosPostInstallAttributionResponse clone() {
    return (GetIosPostInstallAttributionResponse) super.clone();
  }

}
