/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.firebasedynamiclinks.v1.model;

/**
 * Request for iSDK to get reopen attribution for app universal link open deeplinking. This endpoint
 * is meant for only iOS requests.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Firebase Dynamic Links API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GetIosReopenAttributionRequest extends com.google.api.client.json.GenericJson {

  /**
   * APP bundle ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bundleId;

  /**
   * FDL link to be verified from an app universal link open. The FDL link can be one of: 1) short
   * FDL. e.g. .page.link/, or 2) long FDL. e.g. .page.link/?{query params}, or 3) Invite FDL. e.g.
   * .page.link/i/
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestedLink;

  /**
   * Google SDK version. Version takes the form "$major.$minor.$patch"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sdkVersion;

  /**
   * APP bundle ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getBundleId() {
    return bundleId;
  }

  /**
   * APP bundle ID.
   * @param bundleId bundleId or {@code null} for none
   */
  public GetIosReopenAttributionRequest setBundleId(java.lang.String bundleId) {
    this.bundleId = bundleId;
    return this;
  }

  /**
   * FDL link to be verified from an app universal link open. The FDL link can be one of: 1) short
   * FDL. e.g. .page.link/, or 2) long FDL. e.g. .page.link/?{query params}, or 3) Invite FDL. e.g.
   * .page.link/i/
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestedLink() {
    return requestedLink;
  }

  /**
   * FDL link to be verified from an app universal link open. The FDL link can be one of: 1) short
   * FDL. e.g. .page.link/, or 2) long FDL. e.g. .page.link/?{query params}, or 3) Invite FDL. e.g.
   * .page.link/i/
   * @param requestedLink requestedLink or {@code null} for none
   */
  public GetIosReopenAttributionRequest setRequestedLink(java.lang.String requestedLink) {
    this.requestedLink = requestedLink;
    return this;
  }

  /**
   * Google SDK version. Version takes the form "$major.$minor.$patch"
   * @return value or {@code null} for none
   */
  public java.lang.String getSdkVersion() {
    return sdkVersion;
  }

  /**
   * Google SDK version. Version takes the form "$major.$minor.$patch"
   * @param sdkVersion sdkVersion or {@code null} for none
   */
  public GetIosReopenAttributionRequest setSdkVersion(java.lang.String sdkVersion) {
    this.sdkVersion = sdkVersion;
    return this;
  }

  @Override
  public GetIosReopenAttributionRequest set(String fieldName, Object value) {
    return (GetIosReopenAttributionRequest) super.set(fieldName, value);
  }

  @Override
  public GetIosReopenAttributionRequest clone() {
    return (GetIosReopenAttributionRequest) super.clone();
  }

}
