/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.firebasedynamiclinks.v1.model;

/**
 * Parameters for iTunes Connect App Analytics.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Firebase Dynamic Links API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ITunesConnectAnalytics extends com.google.api.client.json.GenericJson {

  /**
   * Affiliate token used to create affiliate-coded links.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String at;

  /**
   * Campaign text that developers can optionally add to any link in order to track sales from a
   * specific marketing campaign.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ct;

  /**
   * iTune media types, including music, podcasts, audiobooks and so on.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mt;

  /**
   * Provider token that enables analytics for Dynamic Links from within iTunes Connect.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pt;

  /**
   * Affiliate token used to create affiliate-coded links.
   * @return value or {@code null} for none
   */
  public java.lang.String getAt() {
    return at;
  }

  /**
   * Affiliate token used to create affiliate-coded links.
   * @param at at or {@code null} for none
   */
  public ITunesConnectAnalytics setAt(java.lang.String at) {
    this.at = at;
    return this;
  }

  /**
   * Campaign text that developers can optionally add to any link in order to track sales from a
   * specific marketing campaign.
   * @return value or {@code null} for none
   */
  public java.lang.String getCt() {
    return ct;
  }

  /**
   * Campaign text that developers can optionally add to any link in order to track sales from a
   * specific marketing campaign.
   * @param ct ct or {@code null} for none
   */
  public ITunesConnectAnalytics setCt(java.lang.String ct) {
    this.ct = ct;
    return this;
  }

  /**
   * iTune media types, including music, podcasts, audiobooks and so on.
   * @return value or {@code null} for none
   */
  public java.lang.String getMt() {
    return mt;
  }

  /**
   * iTune media types, including music, podcasts, audiobooks and so on.
   * @param mt mt or {@code null} for none
   */
  public ITunesConnectAnalytics setMt(java.lang.String mt) {
    this.mt = mt;
    return this;
  }

  /**
   * Provider token that enables analytics for Dynamic Links from within iTunes Connect.
   * @return value or {@code null} for none
   */
  public java.lang.String getPt() {
    return pt;
  }

  /**
   * Provider token that enables analytics for Dynamic Links from within iTunes Connect.
   * @param pt pt or {@code null} for none
   */
  public ITunesConnectAnalytics setPt(java.lang.String pt) {
    this.pt = pt;
    return this;
  }

  @Override
  public ITunesConnectAnalytics set(String fieldName, Object value) {
    return (ITunesConnectAnalytics) super.set(fieldName, value);
  }

  @Override
  public ITunesConnectAnalytics clone() {
    return (ITunesConnectAnalytics) super.clone();
  }

}
