/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.firebasedynamiclinks.v1.model;

/**
 * Managed Short Link.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Firebase Dynamic Links API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ManagedShortLink extends com.google.api.client.json.GenericJson {

  /**
   * Creation timestamp of the short link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTime;

  /**
   * Attributes that have been flagged about this short url.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> flaggedAttribute;

  /**
   * Full Dyamic Link info
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DynamicLinkInfo info;

  /**
   * Short durable link url, for example, "https://sample.app.goo.gl/xyz123". Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String link;

  /**
   * Link name defined by the creator. Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String linkName;

  /**
   * Visibility status of link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String visibility;

  /**
   * Creation timestamp of the short link.
   * @return value or {@code null} for none
   */
  public String getCreationTime() {
    return creationTime;
  }

  /**
   * Creation timestamp of the short link.
   * @param creationTime creationTime or {@code null} for none
   */
  public ManagedShortLink setCreationTime(String creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * Attributes that have been flagged about this short url.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getFlaggedAttribute() {
    return flaggedAttribute;
  }

  /**
   * Attributes that have been flagged about this short url.
   * @param flaggedAttribute flaggedAttribute or {@code null} for none
   */
  public ManagedShortLink setFlaggedAttribute(java.util.List<java.lang.String> flaggedAttribute) {
    this.flaggedAttribute = flaggedAttribute;
    return this;
  }

  /**
   * Full Dyamic Link info
   * @return value or {@code null} for none
   */
  public DynamicLinkInfo getInfo() {
    return info;
  }

  /**
   * Full Dyamic Link info
   * @param info info or {@code null} for none
   */
  public ManagedShortLink setInfo(DynamicLinkInfo info) {
    this.info = info;
    return this;
  }

  /**
   * Short durable link url, for example, "https://sample.app.goo.gl/xyz123". Required.
   * @return value or {@code null} for none
   */
  public java.lang.String getLink() {
    return link;
  }

  /**
   * Short durable link url, for example, "https://sample.app.goo.gl/xyz123". Required.
   * @param link link or {@code null} for none
   */
  public ManagedShortLink setLink(java.lang.String link) {
    this.link = link;
    return this;
  }

  /**
   * Link name defined by the creator. Required.
   * @return value or {@code null} for none
   */
  public java.lang.String getLinkName() {
    return linkName;
  }

  /**
   * Link name defined by the creator. Required.
   * @param linkName linkName or {@code null} for none
   */
  public ManagedShortLink setLinkName(java.lang.String linkName) {
    this.linkName = linkName;
    return this;
  }

  /**
   * Visibility status of link.
   * @return value or {@code null} for none
   */
  public java.lang.String getVisibility() {
    return visibility;
  }

  /**
   * Visibility status of link.
   * @param visibility visibility or {@code null} for none
   */
  public ManagedShortLink setVisibility(java.lang.String visibility) {
    this.visibility = visibility;
    return this;
  }

  @Override
  public ManagedShortLink set(String fieldName, Object value) {
    return (ManagedShortLink) super.set(fieldName, value);
  }

  @Override
  public ManagedShortLink clone() {
    return (ManagedShortLink) super.clone();
  }

}
