/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.firebasedynamiclinks.v1.model;

/**
 * Information of navigation behavior.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Firebase Dynamic Links API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NavigationInfo extends com.google.api.client.json.GenericJson {

  /**
   * If this option is on, FDL click will be forced to redirect rather than show an interstitial
   * page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableForcedRedirect;

  /**
   * If this option is on, FDL click will be forced to redirect rather than show an interstitial
   * page.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableForcedRedirect() {
    return enableForcedRedirect;
  }

  /**
   * If this option is on, FDL click will be forced to redirect rather than show an interstitial
   * page.
   * @param enableForcedRedirect enableForcedRedirect or {@code null} for none
   */
  public NavigationInfo setEnableForcedRedirect(java.lang.Boolean enableForcedRedirect) {
    this.enableForcedRedirect = enableForcedRedirect;
    return this;
  }

  @Override
  public NavigationInfo set(String fieldName, Object value) {
    return (NavigationInfo) super.set(fieldName, value);
  }

  @Override
  public NavigationInfo clone() {
    return (NavigationInfo) super.clone();
  }

}
