/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.firebasedynamiclinks.v1.model;

/**
 * Parameters for social meta tag params. Used to set meta tag data for link previews on social
 * sites.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Firebase Dynamic Links API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SocialMetaTagInfo extends com.google.api.client.json.GenericJson {

  /**
   * A short description of the link. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String socialDescription;

  /**
   * An image url string. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String socialImageLink;

  /**
   * Title to be displayed. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String socialTitle;

  /**
   * A short description of the link. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getSocialDescription() {
    return socialDescription;
  }

  /**
   * A short description of the link. Optional.
   * @param socialDescription socialDescription or {@code null} for none
   */
  public SocialMetaTagInfo setSocialDescription(java.lang.String socialDescription) {
    this.socialDescription = socialDescription;
    return this;
  }

  /**
   * An image url string. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getSocialImageLink() {
    return socialImageLink;
  }

  /**
   * An image url string. Optional.
   * @param socialImageLink socialImageLink or {@code null} for none
   */
  public SocialMetaTagInfo setSocialImageLink(java.lang.String socialImageLink) {
    this.socialImageLink = socialImageLink;
    return this;
  }

  /**
   * Title to be displayed. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getSocialTitle() {
    return socialTitle;
  }

  /**
   * Title to be displayed. Optional.
   * @param socialTitle socialTitle or {@code null} for none
   */
  public SocialMetaTagInfo setSocialTitle(java.lang.String socialTitle) {
    this.socialTitle = socialTitle;
    return this;
  }

  @Override
  public SocialMetaTagInfo set(String fieldName, Object value) {
    return (SocialMetaTagInfo) super.set(fieldName, value);
  }

  @Override
  public SocialMetaTagInfo clone() {
    return (SocialMetaTagInfo) super.clone();
  }

}
