/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.firebasedynamiclinks.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.firebasedynamiclinks.v1.FirebaseDynamicLinksRequest;
import com.google.api.services.firebasedynamiclinks.v1.FirebaseDynamicLinksRequestInitializer;
import com.google.api.services.firebasedynamiclinks.v1.model.CreateManagedShortLinkRequest;
import com.google.api.services.firebasedynamiclinks.v1.model.CreateManagedShortLinkResponse;
import com.google.api.services.firebasedynamiclinks.v1.model.CreateShortDynamicLinkRequest;
import com.google.api.services.firebasedynamiclinks.v1.model.CreateShortDynamicLinkResponse;
import com.google.api.services.firebasedynamiclinks.v1.model.DynamicLinkStats;
import com.google.api.services.firebasedynamiclinks.v1.model.GetIosPostInstallAttributionRequest;
import com.google.api.services.firebasedynamiclinks.v1.model.GetIosPostInstallAttributionResponse;
import com.google.api.services.firebasedynamiclinks.v1.model.GetIosReopenAttributionRequest;
import com.google.api.services.firebasedynamiclinks.v1.model.GetIosReopenAttributionResponse;
import java.io.IOException;

public class FirebaseDynamicLinks
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://firebasedynamiclinks.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://firebasedynamiclinks.googleapis.com/";

    public FirebaseDynamicLinks(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    FirebaseDynamicLinks(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public ManagedShortLinks managedShortLinks() {
        return new ManagedShortLinks();
    }

    public ShortLinks shortLinks() {
        return new ShortLinks();
    }

    public V1 v1() {
        return new V1();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.10 of the Firebase Dynamic Links API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://firebasedynamiclinks.googleapis.com/", FirebaseDynamicLinks.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(FirebaseDynamicLinks.DEFAULT_BATCH_PATH);
        }

        public FirebaseDynamicLinks build() {
            return new FirebaseDynamicLinks(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setFirebaseDynamicLinksRequestInitializer(FirebaseDynamicLinksRequestInitializer firebasedynamiclinksRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)firebasedynamiclinksRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class V1 {
        public GetLinkStats getLinkStats(String dynamicLink) throws IOException {
            GetLinkStats result = new GetLinkStats(dynamicLink);
            FirebaseDynamicLinks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public InstallAttribution installAttribution(GetIosPostInstallAttributionRequest content) throws IOException {
            InstallAttribution result = new InstallAttribution(content);
            FirebaseDynamicLinks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ReopenAttribution reopenAttribution(GetIosReopenAttributionRequest content) throws IOException {
            ReopenAttribution result = new ReopenAttribution(content);
            FirebaseDynamicLinks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class ReopenAttribution
        extends FirebaseDynamicLinksRequest<GetIosReopenAttributionResponse> {
            private static final String REST_PATH = "v1/reopenAttribution";

            protected ReopenAttribution(GetIosReopenAttributionRequest content) {
                super(FirebaseDynamicLinks.this, "POST", REST_PATH, (Object)content, GetIosReopenAttributionResponse.class);
            }

            public ReopenAttribution set$Xgafv(String $Xgafv) {
                return (ReopenAttribution)super.set$Xgafv($Xgafv);
            }

            public ReopenAttribution setAccessToken(String accessToken) {
                return (ReopenAttribution)super.setAccessToken(accessToken);
            }

            public ReopenAttribution setAlt(String alt) {
                return (ReopenAttribution)super.setAlt(alt);
            }

            public ReopenAttribution setCallback(String callback) {
                return (ReopenAttribution)super.setCallback(callback);
            }

            public ReopenAttribution setFields(String fields) {
                return (ReopenAttribution)super.setFields(fields);
            }

            public ReopenAttribution setKey(String key) {
                return (ReopenAttribution)super.setKey(key);
            }

            public ReopenAttribution setOauthToken(String oauthToken) {
                return (ReopenAttribution)super.setOauthToken(oauthToken);
            }

            public ReopenAttribution setPrettyPrint(Boolean prettyPrint) {
                return (ReopenAttribution)super.setPrettyPrint(prettyPrint);
            }

            public ReopenAttribution setQuotaUser(String quotaUser) {
                return (ReopenAttribution)super.setQuotaUser(quotaUser);
            }

            public ReopenAttribution setUploadType(String uploadType) {
                return (ReopenAttribution)super.setUploadType(uploadType);
            }

            public ReopenAttribution setUploadProtocol(String uploadProtocol) {
                return (ReopenAttribution)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public ReopenAttribution set(String parameterName, Object value) {
                return (ReopenAttribution)super.set(parameterName, value);
            }
        }

        public class InstallAttribution
        extends FirebaseDynamicLinksRequest<GetIosPostInstallAttributionResponse> {
            private static final String REST_PATH = "v1/installAttribution";

            protected InstallAttribution(GetIosPostInstallAttributionRequest content) {
                super(FirebaseDynamicLinks.this, "POST", REST_PATH, (Object)content, GetIosPostInstallAttributionResponse.class);
            }

            public InstallAttribution set$Xgafv(String $Xgafv) {
                return (InstallAttribution)super.set$Xgafv($Xgafv);
            }

            public InstallAttribution setAccessToken(String accessToken) {
                return (InstallAttribution)super.setAccessToken(accessToken);
            }

            public InstallAttribution setAlt(String alt) {
                return (InstallAttribution)super.setAlt(alt);
            }

            public InstallAttribution setCallback(String callback) {
                return (InstallAttribution)super.setCallback(callback);
            }

            public InstallAttribution setFields(String fields) {
                return (InstallAttribution)super.setFields(fields);
            }

            public InstallAttribution setKey(String key) {
                return (InstallAttribution)super.setKey(key);
            }

            public InstallAttribution setOauthToken(String oauthToken) {
                return (InstallAttribution)super.setOauthToken(oauthToken);
            }

            public InstallAttribution setPrettyPrint(Boolean prettyPrint) {
                return (InstallAttribution)super.setPrettyPrint(prettyPrint);
            }

            public InstallAttribution setQuotaUser(String quotaUser) {
                return (InstallAttribution)super.setQuotaUser(quotaUser);
            }

            public InstallAttribution setUploadType(String uploadType) {
                return (InstallAttribution)super.setUploadType(uploadType);
            }

            public InstallAttribution setUploadProtocol(String uploadProtocol) {
                return (InstallAttribution)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public InstallAttribution set(String parameterName, Object value) {
                return (InstallAttribution)super.set(parameterName, value);
            }
        }

        public class GetLinkStats
        extends FirebaseDynamicLinksRequest<DynamicLinkStats> {
            private static final String REST_PATH = "v1/{dynamicLink}/linkStats";
            @Key
            private String dynamicLink;
            @Key
            private Long durationDays;
            @Key
            private String sdkVersion;

            protected GetLinkStats(String dynamicLink) {
                super(FirebaseDynamicLinks.this, "GET", REST_PATH, null, DynamicLinkStats.class);
                this.dynamicLink = (String)Preconditions.checkNotNull((Object)dynamicLink, (Object)"Required parameter dynamicLink must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetLinkStats set$Xgafv(String $Xgafv) {
                return (GetLinkStats)super.set$Xgafv($Xgafv);
            }

            public GetLinkStats setAccessToken(String accessToken) {
                return (GetLinkStats)super.setAccessToken(accessToken);
            }

            public GetLinkStats setAlt(String alt) {
                return (GetLinkStats)super.setAlt(alt);
            }

            public GetLinkStats setCallback(String callback) {
                return (GetLinkStats)super.setCallback(callback);
            }

            public GetLinkStats setFields(String fields) {
                return (GetLinkStats)super.setFields(fields);
            }

            public GetLinkStats setKey(String key) {
                return (GetLinkStats)super.setKey(key);
            }

            public GetLinkStats setOauthToken(String oauthToken) {
                return (GetLinkStats)super.setOauthToken(oauthToken);
            }

            public GetLinkStats setPrettyPrint(Boolean prettyPrint) {
                return (GetLinkStats)super.setPrettyPrint(prettyPrint);
            }

            public GetLinkStats setQuotaUser(String quotaUser) {
                return (GetLinkStats)super.setQuotaUser(quotaUser);
            }

            public GetLinkStats setUploadType(String uploadType) {
                return (GetLinkStats)super.setUploadType(uploadType);
            }

            public GetLinkStats setUploadProtocol(String uploadProtocol) {
                return (GetLinkStats)super.setUploadProtocol(uploadProtocol);
            }

            public String getDynamicLink() {
                return this.dynamicLink;
            }

            public GetLinkStats setDynamicLink(String dynamicLink) {
                this.dynamicLink = dynamicLink;
                return this;
            }

            public Long getDurationDays() {
                return this.durationDays;
            }

            public GetLinkStats setDurationDays(Long durationDays) {
                this.durationDays = durationDays;
                return this;
            }

            public String getSdkVersion() {
                return this.sdkVersion;
            }

            public GetLinkStats setSdkVersion(String sdkVersion) {
                this.sdkVersion = sdkVersion;
                return this;
            }

            @Override
            public GetLinkStats set(String parameterName, Object value) {
                return (GetLinkStats)super.set(parameterName, value);
            }
        }
    }

    public class ShortLinks {
        public Create create(CreateShortDynamicLinkRequest content) throws IOException {
            Create result = new Create(content);
            FirebaseDynamicLinks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Create
        extends FirebaseDynamicLinksRequest<CreateShortDynamicLinkResponse> {
            private static final String REST_PATH = "v1/shortLinks";

            protected Create(CreateShortDynamicLinkRequest content) {
                super(FirebaseDynamicLinks.this, "POST", REST_PATH, (Object)content, CreateShortDynamicLinkResponse.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class ManagedShortLinks {
        public Create create(CreateManagedShortLinkRequest content) throws IOException {
            Create result = new Create(content);
            FirebaseDynamicLinks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Create
        extends FirebaseDynamicLinksRequest<CreateManagedShortLinkResponse> {
            private static final String REST_PATH = "v1/managedShortLinks:create";

            protected Create(CreateManagedShortLinkRequest content) {
                super(FirebaseDynamicLinks.this, "POST", REST_PATH, (Object)content, CreateManagedShortLinkResponse.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }
}

