/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.fitness;

/**
 * Service definition for Fitness (v1).
 *
 * <p>
 * The Fitness API for managing users' fitness tracking data.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/fit/rest/v1/get-started" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link FitnessRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Fitness extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1)),
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "1.32.1 of the Fitness API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://fitness.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://fitness.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "fitness/v1/users/";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Fitness(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Fitness(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Users collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Fitness fitness = new Fitness(...);}
   *   {@code Fitness.Users.List request = fitness.users().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Users users() {
    return new Users();
  }

  /**
   * The "users" collection of methods.
   */
  public class Users {

    /**
     * An accessor for creating requests from the DataSources collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Fitness fitness = new Fitness(...);}
     *   {@code Fitness.DataSources.List request = fitness.dataSources().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public DataSources dataSources() {
      return new DataSources();
    }

    /**
     * The "dataSources" collection of methods.
     */
    public class DataSources {

      /**
       * Creates a new data source that is unique across all data sources belonging to this user. A data
       * source is a unique source of sensor data. Data sources can expose raw data coming from hardware
       * sensors on local or companion devices. They can also expose derived data, created by transforming
       * or merging other data sources. Multiple data sources can exist for the same data type. Every data
       * point in every dataset inserted into or read from the Fitness API has an associated data source.
       * Each data source produces a unique stream of dataset updates, with a unique data source
       * identifier. Not all changes to data source affect the data stream ID, so that data collected by
       * updated versions of the same application/device can still be considered to belong to the same
       * data source. Data sources are identified using a string generated by the server, based on the
       * contents of the source being created. The dataStreamId field should not be set when invoking this
       * method. It will be automatically generated by the server with the correct format. If a
       * dataStreamId is set, it must match the format that the server would generate. This format is a
       * combination of some fields from the data source, and has a specific order. If it doesn't match,
       * the request will fail with an error. Specifying a DataType which is not a known type (beginning
       * with "com.google.") will create a DataSource with a *custom data type*. Custom data types are
       * only readable by the application that created them. Custom data types are *deprecated*; use
       * standard data types instead. In addition to the data source fields included in the data source
       * ID, the developer project number that is authenticated when creating the data source is included.
       * This developer project number is obfuscated when read by any other developer reading public data
       * types.
       *
       * Create a request for the method "dataSources.create".
       *
       * This request holds the parameters needed by the fitness server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param userId Create the data source for the person identified. Use me to indicate the authenticated user. Only me
       *        is supported at this time.
       * @param content the {@link com.google.api.services.fitness.model.DataSource}
       * @return the request
       */
      public Create create(java.lang.String userId, com.google.api.services.fitness.model.DataSource content) throws java.io.IOException {
        Create result = new Create(userId, content);
        initialize(result);
        return result;
      }

      public class Create extends FitnessRequest<com.google.api.services.fitness.model.DataSource> {

        private static final String REST_PATH = "{userId}/dataSources";

        /**
         * Creates a new data source that is unique across all data sources belonging to this user. A data
         * source is a unique source of sensor data. Data sources can expose raw data coming from hardware
         * sensors on local or companion devices. They can also expose derived data, created by
         * transforming or merging other data sources. Multiple data sources can exist for the same data
         * type. Every data point in every dataset inserted into or read from the Fitness API has an
         * associated data source. Each data source produces a unique stream of dataset updates, with a
         * unique data source identifier. Not all changes to data source affect the data stream ID, so
         * that data collected by updated versions of the same application/device can still be considered
         * to belong to the same data source. Data sources are identified using a string generated by the
         * server, based on the contents of the source being created. The dataStreamId field should not be
         * set when invoking this method. It will be automatically generated by the server with the
         * correct format. If a dataStreamId is set, it must match the format that the server would
         * generate. This format is a combination of some fields from the data source, and has a specific
         * order. If it doesn't match, the request will fail with an error. Specifying a DataType which is
         * not a known type (beginning with "com.google.") will create a DataSource with a *custom data
         * type*. Custom data types are only readable by the application that created them. Custom data
         * types are *deprecated*; use standard data types instead. In addition to the data source fields
         * included in the data source ID, the developer project number that is authenticated when
         * creating the data source is included. This developer project number is obfuscated when read by
         * any other developer reading public data types.
         *
         * Create a request for the method "dataSources.create".
         *
         * This request holds the parameters needed by the the fitness server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId Create the data source for the person identified. Use me to indicate the authenticated user. Only me
       *        is supported at this time.
         * @param content the {@link com.google.api.services.fitness.model.DataSource}
         * @since 1.13
         */
        protected Create(java.lang.String userId, com.google.api.services.fitness.model.DataSource content) {
          super(Fitness.this, "POST", REST_PATH, content, com.google.api.services.fitness.model.DataSource.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getType(), "DataSource.getType()");
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Create the data source for the person identified. Use me to indicate the authenticated
         * user. Only me is supported at this time.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** Create the data source for the person identified. Use me to indicate the authenticated user. Only
       me is supported at this time.
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * Create the data source for the person identified. Use me to indicate the authenticated
         * user. Only me is supported at this time.
         */
        public Create setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes the specified data source. The request will fail if the data source contains any data
       * points.
       *
       * Create a request for the method "dataSources.delete".
       *
       * This request holds the parameters needed by the fitness server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param userId Retrieve a data source for the person identified. Use me to indicate the authenticated user. Only me
       *        is supported at this time.
       * @param dataSourceId The data stream ID of the data source to delete.
       * @return the request
       */
      public Delete delete(java.lang.String userId, java.lang.String dataSourceId) throws java.io.IOException {
        Delete result = new Delete(userId, dataSourceId);
        initialize(result);
        return result;
      }

      public class Delete extends FitnessRequest<com.google.api.services.fitness.model.DataSource> {

        private static final String REST_PATH = "{userId}/dataSources/{dataSourceId}";

        /**
         * Deletes the specified data source. The request will fail if the data source contains any data
         * points.
         *
         * Create a request for the method "dataSources.delete".
         *
         * This request holds the parameters needed by the the fitness server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId Retrieve a data source for the person identified. Use me to indicate the authenticated user. Only me
       *        is supported at this time.
         * @param dataSourceId The data stream ID of the data source to delete.
         * @since 1.13
         */
        protected Delete(java.lang.String userId, java.lang.String dataSourceId) {
          super(Fitness.this, "DELETE", REST_PATH, null, com.google.api.services.fitness.model.DataSource.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.dataSourceId = com.google.api.client.util.Preconditions.checkNotNull(dataSourceId, "Required parameter dataSourceId must be specified.");
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Retrieve a data source for the person identified. Use me to indicate the authenticated
         * user. Only me is supported at this time.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** Retrieve a data source for the person identified. Use me to indicate the authenticated user. Only
       me is supported at this time.
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * Retrieve a data source for the person identified. Use me to indicate the authenticated
         * user. Only me is supported at this time.
         */
        public Delete setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The data stream ID of the data source to delete. */
        @com.google.api.client.util.Key
        private java.lang.String dataSourceId;

        /** The data stream ID of the data source to delete.
         */
        public java.lang.String getDataSourceId() {
          return dataSourceId;
        }

        /** The data stream ID of the data source to delete. */
        public Delete setDataSourceId(java.lang.String dataSourceId) {
          this.dataSourceId = dataSourceId;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Returns the specified data source.
       *
       * Create a request for the method "dataSources.get".
       *
       * This request holds the parameters needed by the fitness server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param userId Retrieve a data source for the person identified. Use me to indicate the authenticated user. Only me
       *        is supported at this time.
       * @param dataSourceId The data stream ID of the data source to retrieve.
       * @return the request
       */
      public Get get(java.lang.String userId, java.lang.String dataSourceId) throws java.io.IOException {
        Get result = new Get(userId, dataSourceId);
        initialize(result);
        return result;
      }

      public class Get extends FitnessRequest<com.google.api.services.fitness.model.DataSource> {

        private static final String REST_PATH = "{userId}/dataSources/{dataSourceId}";

        /**
         * Returns the specified data source.
         *
         * Create a request for the method "dataSources.get".
         *
         * This request holds the parameters needed by the the fitness server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId Retrieve a data source for the person identified. Use me to indicate the authenticated user. Only me
       *        is supported at this time.
         * @param dataSourceId The data stream ID of the data source to retrieve.
         * @since 1.13
         */
        protected Get(java.lang.String userId, java.lang.String dataSourceId) {
          super(Fitness.this, "GET", REST_PATH, null, com.google.api.services.fitness.model.DataSource.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.dataSourceId = com.google.api.client.util.Preconditions.checkNotNull(dataSourceId, "Required parameter dataSourceId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Retrieve a data source for the person identified. Use me to indicate the authenticated
         * user. Only me is supported at this time.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** Retrieve a data source for the person identified. Use me to indicate the authenticated user. Only
       me is supported at this time.
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * Retrieve a data source for the person identified. Use me to indicate the authenticated
         * user. Only me is supported at this time.
         */
        public Get setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The data stream ID of the data source to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String dataSourceId;

        /** The data stream ID of the data source to retrieve.
         */
        public java.lang.String getDataSourceId() {
          return dataSourceId;
        }

        /** The data stream ID of the data source to retrieve. */
        public Get setDataSourceId(java.lang.String dataSourceId) {
          this.dataSourceId = dataSourceId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists all data sources that are visible to the developer, using the OAuth scopes provided. The
       * list is not exhaustive; the user may have private data sources that are only visible to other
       * developers, or calls using other scopes.
       *
       * Create a request for the method "dataSources.list".
       *
       * This request holds the parameters needed by the fitness server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param userId List data sources for the person identified. Use me to indicate the authenticated user. Only me is
       *        supported at this time.
       * @return the request
       */
      public List list(java.lang.String userId) throws java.io.IOException {
        List result = new List(userId);
        initialize(result);
        return result;
      }

      public class List extends FitnessRequest<com.google.api.services.fitness.model.ListDataSourcesResponse> {

        private static final String REST_PATH = "{userId}/dataSources";

        /**
         * Lists all data sources that are visible to the developer, using the OAuth scopes provided. The
         * list is not exhaustive; the user may have private data sources that are only visible to other
         * developers, or calls using other scopes.
         *
         * Create a request for the method "dataSources.list".
         *
         * This request holds the parameters needed by the the fitness server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId List data sources for the person identified. Use me to indicate the authenticated user. Only me is
       *        supported at this time.
         * @since 1.13
         */
        protected List(java.lang.String userId) {
          super(Fitness.this, "GET", REST_PATH, null, com.google.api.services.fitness.model.ListDataSourcesResponse.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * List data sources for the person identified. Use me to indicate the authenticated user.
         * Only me is supported at this time.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** List data sources for the person identified. Use me to indicate the authenticated user. Only me is
       supported at this time.
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * List data sources for the person identified. Use me to indicate the authenticated user.
         * Only me is supported at this time.
         */
        public List setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /**
         * The names of data types to include in the list. If not specified, all data sources will
         * be returned.
         */
        @com.google.api.client.util.Key
        private java.util.List<java.lang.String> dataTypeName;

        /** The names of data types to include in the list. If not specified, all data sources will be
       returned.
         */
        public java.util.List<java.lang.String> getDataTypeName() {
          return dataTypeName;
        }

        /**
         * The names of data types to include in the list. If not specified, all data sources will
         * be returned.
         */
        public List setDataTypeName(java.util.List<java.lang.String> dataTypeName) {
          this.dataTypeName = dataTypeName;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates the specified data source. The dataStreamId, dataType, type, dataStreamName, and device
       * properties with the exception of version, cannot be modified. Data sources are identified by
       * their dataStreamId.
       *
       * Create a request for the method "dataSources.update".
       *
       * This request holds the parameters needed by the fitness server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param userId Update the data source for the person identified. Use me to indicate the authenticated user. Only me
       *        is supported at this time.
       * @param dataSourceId The data stream ID of the data source to update.
       * @param content the {@link com.google.api.services.fitness.model.DataSource}
       * @return the request
       */
      public Update update(java.lang.String userId, java.lang.String dataSourceId, com.google.api.services.fitness.model.DataSource content) throws java.io.IOException {
        Update result = new Update(userId, dataSourceId, content);
        initialize(result);
        return result;
      }

      public class Update extends FitnessRequest<com.google.api.services.fitness.model.DataSource> {

        private static final String REST_PATH = "{userId}/dataSources/{dataSourceId}";

        /**
         * Updates the specified data source. The dataStreamId, dataType, type, dataStreamName, and device
         * properties with the exception of version, cannot be modified. Data sources are identified by
         * their dataStreamId.
         *
         * Create a request for the method "dataSources.update".
         *
         * This request holds the parameters needed by the the fitness server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId Update the data source for the person identified. Use me to indicate the authenticated user. Only me
       *        is supported at this time.
         * @param dataSourceId The data stream ID of the data source to update.
         * @param content the {@link com.google.api.services.fitness.model.DataSource}
         * @since 1.13
         */
        protected Update(java.lang.String userId, java.lang.String dataSourceId, com.google.api.services.fitness.model.DataSource content) {
          super(Fitness.this, "PUT", REST_PATH, content, com.google.api.services.fitness.model.DataSource.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.dataSourceId = com.google.api.client.util.Preconditions.checkNotNull(dataSourceId, "Required parameter dataSourceId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getDataStreamId(), "DataSource.getDataStreamId()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getType(), "DataSource.getType()");
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Update the data source for the person identified. Use me to indicate the authenticated
         * user. Only me is supported at this time.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** Update the data source for the person identified. Use me to indicate the authenticated user. Only
       me is supported at this time.
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * Update the data source for the person identified. Use me to indicate the authenticated
         * user. Only me is supported at this time.
         */
        public Update setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The data stream ID of the data source to update. */
        @com.google.api.client.util.Key
        private java.lang.String dataSourceId;

        /** The data stream ID of the data source to update.
         */
        public java.lang.String getDataSourceId() {
          return dataSourceId;
        }

        /** The data stream ID of the data source to update. */
        public Update setDataSourceId(java.lang.String dataSourceId) {
          this.dataSourceId = dataSourceId;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the DataPointChanges collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Fitness fitness = new Fitness(...);}
       *   {@code Fitness.DataPointChanges.List request = fitness.dataPointChanges().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public DataPointChanges dataPointChanges() {
        return new DataPointChanges();
      }

      /**
       * The "dataPointChanges" collection of methods.
       */
      public class DataPointChanges {

        /**
         * Queries for user's data point changes for a particular data source.
         *
         * Create a request for the method "dataPointChanges.list".
         *
         * This request holds the parameters needed by the fitness server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param userId List data points for the person identified. Use me to indicate the authenticated user. Only me is
         *        supported at this time.
         * @param dataSourceId The data stream ID of the data source that created the dataset.
         * @return the request
         */
        public List list(java.lang.String userId, java.lang.String dataSourceId) throws java.io.IOException {
          List result = new List(userId, dataSourceId);
          initialize(result);
          return result;
        }

        public class List extends FitnessRequest<com.google.api.services.fitness.model.ListDataPointChangesResponse> {

          private static final String REST_PATH = "{userId}/dataSources/{dataSourceId}/dataPointChanges";

          /**
           * Queries for user's data point changes for a particular data source.
           *
           * Create a request for the method "dataPointChanges.list".
           *
           * This request holds the parameters needed by the the fitness server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
           * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId List data points for the person identified. Use me to indicate the authenticated user. Only me is
         *        supported at this time.
           * @param dataSourceId The data stream ID of the data source that created the dataset.
           * @since 1.13
           */
          protected List(java.lang.String userId, java.lang.String dataSourceId) {
            super(Fitness.this, "GET", REST_PATH, null, com.google.api.services.fitness.model.ListDataPointChangesResponse.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
            this.dataSourceId = com.google.api.client.util.Preconditions.checkNotNull(dataSourceId, "Required parameter dataSourceId must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * List data points for the person identified. Use me to indicate the authenticated user.
           * Only me is supported at this time.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** List data points for the person identified. Use me to indicate the authenticated user. Only me is
         supported at this time.
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * List data points for the person identified. Use me to indicate the authenticated user.
           * Only me is supported at this time.
           */
          public List setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          /** The data stream ID of the data source that created the dataset. */
          @com.google.api.client.util.Key
          private java.lang.String dataSourceId;

          /** The data stream ID of the data source that created the dataset.
           */
          public java.lang.String getDataSourceId() {
            return dataSourceId;
          }

          /** The data stream ID of the data source that created the dataset. */
          public List setDataSourceId(java.lang.String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
          }

          /**
           * If specified, no more than this many data point changes will be included in the
           * response.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer limit;

          /** If specified, no more than this many data point changes will be included in the response.
           */
          public java.lang.Integer getLimit() {
            return limit;
          }

          /**
           * If specified, no more than this many data point changes will be included in the
           * response.
           */
          public List setLimit(java.lang.Integer limit) {
            this.limit = limit;
            return this;
          }

          /**
           * The continuation token, which is used to page through large result sets. To get the
           * next page of results, set this parameter to the value of nextPageToken from the
           * previous response.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** The continuation token, which is used to page through large result sets. To get the next page of
         results, set this parameter to the value of nextPageToken from the previous response.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * The continuation token, which is used to page through large result sets. To get the
           * next page of results, set this parameter to the value of nextPageToken from the
           * previous response.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Datasets collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Fitness fitness = new Fitness(...);}
       *   {@code Fitness.Datasets.List request = fitness.datasets().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Datasets datasets() {
        return new Datasets();
      }

      /**
       * The "datasets" collection of methods.
       */
      public class Datasets {

        /**
         * Performs an inclusive delete of all data points whose start and end times have any overlap with
         * the time range specified by the dataset ID. For most data types, the entire data point will be
         * deleted. For data types where the time span represents a consistent value (such as
         * com.google.activity.segment), and a data point straddles either end point of the dataset, only
         * the overlapping portion of the data point will be deleted.
         *
         * Create a request for the method "datasets.delete".
         *
         * This request holds the parameters needed by the fitness server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param userId Delete a dataset for the person identified. Use me to indicate the authenticated user. Only me is
         *        supported at this time.
         * @param dataSourceId The data stream ID of the data source that created the dataset.
         * @param datasetId Dataset identifier that is a composite of the minimum data point start time and maximum data point
         *        end time represented as nanoseconds from the epoch. The ID is formatted like: "startTime-
         *        endTime" where startTime and endTime are 64 bit integers.
         * @return the request
         */
        public Delete delete(java.lang.String userId, java.lang.String dataSourceId, java.lang.String datasetId) throws java.io.IOException {
          Delete result = new Delete(userId, dataSourceId, datasetId);
          initialize(result);
          return result;
        }

        public class Delete extends FitnessRequest<Void> {

          private static final String REST_PATH = "{userId}/dataSources/{dataSourceId}/datasets/{datasetId}";

          /**
           * Performs an inclusive delete of all data points whose start and end times have any overlap with
           * the time range specified by the dataset ID. For most data types, the entire data point will be
           * deleted. For data types where the time span represents a consistent value (such as
           * com.google.activity.segment), and a data point straddles either end point of the dataset, only
           * the overlapping portion of the data point will be deleted.
           *
           * Create a request for the method "datasets.delete".
           *
           * This request holds the parameters needed by the the fitness server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId Delete a dataset for the person identified. Use me to indicate the authenticated user. Only me is
         *        supported at this time.
           * @param dataSourceId The data stream ID of the data source that created the dataset.
           * @param datasetId Dataset identifier that is a composite of the minimum data point start time and maximum data point
         *        end time represented as nanoseconds from the epoch. The ID is formatted like: "startTime-
         *        endTime" where startTime and endTime are 64 bit integers.
           * @since 1.13
           */
          protected Delete(java.lang.String userId, java.lang.String dataSourceId, java.lang.String datasetId) {
            super(Fitness.this, "DELETE", REST_PATH, null, Void.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
            this.dataSourceId = com.google.api.client.util.Preconditions.checkNotNull(dataSourceId, "Required parameter dataSourceId must be specified.");
            this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Delete a dataset for the person identified. Use me to indicate the authenticated user.
           * Only me is supported at this time.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** Delete a dataset for the person identified. Use me to indicate the authenticated user. Only me is
         supported at this time.
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * Delete a dataset for the person identified. Use me to indicate the authenticated user.
           * Only me is supported at this time.
           */
          public Delete setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          /** The data stream ID of the data source that created the dataset. */
          @com.google.api.client.util.Key
          private java.lang.String dataSourceId;

          /** The data stream ID of the data source that created the dataset.
           */
          public java.lang.String getDataSourceId() {
            return dataSourceId;
          }

          /** The data stream ID of the data source that created the dataset. */
          public Delete setDataSourceId(java.lang.String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
          }

          /**
           * Dataset identifier that is a composite of the minimum data point start time and maximum
           * data point end time represented as nanoseconds from the epoch. The ID is formatted
           * like: "startTime-endTime" where startTime and endTime are 64 bit integers.
           */
          @com.google.api.client.util.Key
          private java.lang.String datasetId;

          /** Dataset identifier that is a composite of the minimum data point start time and maximum data point
         end time represented as nanoseconds from the epoch. The ID is formatted like: "startTime-endTime"
         where startTime and endTime are 64 bit integers.
           */
          public java.lang.String getDatasetId() {
            return datasetId;
          }

          /**
           * Dataset identifier that is a composite of the minimum data point start time and maximum
           * data point end time represented as nanoseconds from the epoch. The ID is formatted
           * like: "startTime-endTime" where startTime and endTime are 64 bit integers.
           */
          public Delete setDatasetId(java.lang.String datasetId) {
            this.datasetId = datasetId;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Returns a dataset containing all data points whose start and end times overlap with the specified
         * range of the dataset minimum start time and maximum end time. Specifically, any data point whose
         * start time is less than or equal to the dataset end time and whose end time is greater than or
         * equal to the dataset start time.
         *
         * Create a request for the method "datasets.get".
         *
         * This request holds the parameters needed by the fitness server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param userId Retrieve a dataset for the person identified. Use me to indicate the authenticated user. Only me is
         *        supported at this time.
         * @param dataSourceId The data stream ID of the data source that created the dataset.
         * @param datasetId Dataset identifier that is a composite of the minimum data point start time and maximum data point
         *        end time represented as nanoseconds from the epoch. The ID is formatted like: "startTime-
         *        endTime" where startTime and endTime are 64 bit integers.
         * @return the request
         */
        public Get get(java.lang.String userId, java.lang.String dataSourceId, java.lang.String datasetId) throws java.io.IOException {
          Get result = new Get(userId, dataSourceId, datasetId);
          initialize(result);
          return result;
        }

        public class Get extends FitnessRequest<com.google.api.services.fitness.model.Dataset> {

          private static final String REST_PATH = "{userId}/dataSources/{dataSourceId}/datasets/{datasetId}";

          /**
           * Returns a dataset containing all data points whose start and end times overlap with the
           * specified range of the dataset minimum start time and maximum end time. Specifically, any data
           * point whose start time is less than or equal to the dataset end time and whose end time is
           * greater than or equal to the dataset start time.
           *
           * Create a request for the method "datasets.get".
           *
           * This request holds the parameters needed by the the fitness server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
           * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId Retrieve a dataset for the person identified. Use me to indicate the authenticated user. Only me is
         *        supported at this time.
           * @param dataSourceId The data stream ID of the data source that created the dataset.
           * @param datasetId Dataset identifier that is a composite of the minimum data point start time and maximum data point
         *        end time represented as nanoseconds from the epoch. The ID is formatted like: "startTime-
         *        endTime" where startTime and endTime are 64 bit integers.
           * @since 1.13
           */
          protected Get(java.lang.String userId, java.lang.String dataSourceId, java.lang.String datasetId) {
            super(Fitness.this, "GET", REST_PATH, null, com.google.api.services.fitness.model.Dataset.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
            this.dataSourceId = com.google.api.client.util.Preconditions.checkNotNull(dataSourceId, "Required parameter dataSourceId must be specified.");
            this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Retrieve a dataset for the person identified. Use me to indicate the authenticated
           * user. Only me is supported at this time.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** Retrieve a dataset for the person identified. Use me to indicate the authenticated user. Only me is
         supported at this time.
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * Retrieve a dataset for the person identified. Use me to indicate the authenticated
           * user. Only me is supported at this time.
           */
          public Get setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          /** The data stream ID of the data source that created the dataset. */
          @com.google.api.client.util.Key
          private java.lang.String dataSourceId;

          /** The data stream ID of the data source that created the dataset.
           */
          public java.lang.String getDataSourceId() {
            return dataSourceId;
          }

          /** The data stream ID of the data source that created the dataset. */
          public Get setDataSourceId(java.lang.String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
          }

          /**
           * Dataset identifier that is a composite of the minimum data point start time and maximum
           * data point end time represented as nanoseconds from the epoch. The ID is formatted
           * like: "startTime-endTime" where startTime and endTime are 64 bit integers.
           */
          @com.google.api.client.util.Key
          private java.lang.String datasetId;

          /** Dataset identifier that is a composite of the minimum data point start time and maximum data point
         end time represented as nanoseconds from the epoch. The ID is formatted like: "startTime-endTime"
         where startTime and endTime are 64 bit integers.
           */
          public java.lang.String getDatasetId() {
            return datasetId;
          }

          /**
           * Dataset identifier that is a composite of the minimum data point start time and maximum
           * data point end time represented as nanoseconds from the epoch. The ID is formatted
           * like: "startTime-endTime" where startTime and endTime are 64 bit integers.
           */
          public Get setDatasetId(java.lang.String datasetId) {
            this.datasetId = datasetId;
            return this;
          }

          /**
           * If specified, no more than this many data points will be included in the dataset. If
           * there are more data points in the dataset, nextPageToken will be set in the dataset
           * response. The limit is applied from the end of the time range. That is, if pageToken is
           * absent, the limit most recent data points will be returned.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer limit;

          /** If specified, no more than this many data points will be included in the dataset. If there are more
         data points in the dataset, nextPageToken will be set in the dataset response. The limit is applied
         from the end of the time range. That is, if pageToken is absent, the limit most recent data points
         will be returned.
           */
          public java.lang.Integer getLimit() {
            return limit;
          }

          /**
           * If specified, no more than this many data points will be included in the dataset. If
           * there are more data points in the dataset, nextPageToken will be set in the dataset
           * response. The limit is applied from the end of the time range. That is, if pageToken is
           * absent, the limit most recent data points will be returned.
           */
          public Get setLimit(java.lang.Integer limit) {
            this.limit = limit;
            return this;
          }

          /**
           * The continuation token, which is used to page through large datasets. To get the next
           * page of a dataset, set this parameter to the value of nextPageToken from the previous
           * response. Each subsequent call will yield a partial dataset with data point end
           * timestamps that are strictly smaller than those in the previous partial response.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** The continuation token, which is used to page through large datasets. To get the next page of a
         dataset, set this parameter to the value of nextPageToken from the previous response. Each
         subsequent call will yield a partial dataset with data point end timestamps that are strictly
         smaller than those in the previous partial response.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * The continuation token, which is used to page through large datasets. To get the next
           * page of a dataset, set this parameter to the value of nextPageToken from the previous
           * response. Each subsequent call will yield a partial dataset with data point end
           * timestamps that are strictly smaller than those in the previous partial response.
           */
          public Get setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Adds data points to a dataset. The dataset need not be previously created. All points within the
         * given dataset will be returned with subsquent calls to retrieve this dataset. Data points can
         * belong to more than one dataset. This method does not use patch semantics: the data points
         * provided are merely inserted, with no existing data replaced.
         *
         * Create a request for the method "datasets.patch".
         *
         * This request holds the parameters needed by the fitness server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         *
         * @param userId Patch a dataset for the person identified. Use me to indicate the authenticated user. Only me is
         *        supported at this time.
         * @param dataSourceId The data stream ID of the data source that created the dataset.
         * @param datasetId This field is not used, and can be safely omitted.
         * @param content the {@link com.google.api.services.fitness.model.Dataset}
         * @return the request
         */
        public Patch patch(java.lang.String userId, java.lang.String dataSourceId, java.lang.String datasetId, com.google.api.services.fitness.model.Dataset content) throws java.io.IOException {
          Patch result = new Patch(userId, dataSourceId, datasetId, content);
          initialize(result);
          return result;
        }

        public class Patch extends FitnessRequest<com.google.api.services.fitness.model.Dataset> {

          private static final String REST_PATH = "{userId}/dataSources/{dataSourceId}/datasets/{datasetId}";

          /**
           * Adds data points to a dataset. The dataset need not be previously created. All points within
           * the given dataset will be returned with subsquent calls to retrieve this dataset. Data points
           * can belong to more than one dataset. This method does not use patch semantics: the data points
           * provided are merely inserted, with no existing data replaced.
           *
           * Create a request for the method "datasets.patch".
           *
           * This request holds the parameters needed by the the fitness server.  After setting any optional
           * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
           * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param userId Patch a dataset for the person identified. Use me to indicate the authenticated user. Only me is
         *        supported at this time.
           * @param dataSourceId The data stream ID of the data source that created the dataset.
           * @param datasetId This field is not used, and can be safely omitted.
           * @param content the {@link com.google.api.services.fitness.model.Dataset}
           * @since 1.13
           */
          protected Patch(java.lang.String userId, java.lang.String dataSourceId, java.lang.String datasetId, com.google.api.services.fitness.model.Dataset content) {
            super(Fitness.this, "PATCH", REST_PATH, content, com.google.api.services.fitness.model.Dataset.class);
            this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
            this.dataSourceId = com.google.api.client.util.Preconditions.checkNotNull(dataSourceId, "Required parameter dataSourceId must be specified.");
            this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
            checkRequiredParameter(content, "content");
            checkRequiredParameter(content.getDataSourceId(), "Dataset.getDataSourceId()");
            checkRequiredParameter(content, "content");
            checkRequiredParameter(content.getMaxEndTimeNs(), "Dataset.getMaxEndTimeNs()");
            checkRequiredParameter(content, "content");
            checkRequiredParameter(content.getMinStartTimeNs(), "Dataset.getMinStartTimeNs()");
          }

          @Override
          public Patch set$Xgafv(java.lang.String $Xgafv) {
            return (Patch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Patch setAccessToken(java.lang.String accessToken) {
            return (Patch) super.setAccessToken(accessToken);
          }

          @Override
          public Patch setAlt(java.lang.String alt) {
            return (Patch) super.setAlt(alt);
          }

          @Override
          public Patch setCallback(java.lang.String callback) {
            return (Patch) super.setCallback(callback);
          }

          @Override
          public Patch setFields(java.lang.String fields) {
            return (Patch) super.setFields(fields);
          }

          @Override
          public Patch setKey(java.lang.String key) {
            return (Patch) super.setKey(key);
          }

          @Override
          public Patch setOauthToken(java.lang.String oauthToken) {
            return (Patch) super.setOauthToken(oauthToken);
          }

          @Override
          public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Patch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Patch setQuotaUser(java.lang.String quotaUser) {
            return (Patch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Patch setUploadType(java.lang.String uploadType) {
            return (Patch) super.setUploadType(uploadType);
          }

          @Override
          public Patch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Patch) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Patch a dataset for the person identified. Use me to indicate the authenticated user.
           * Only me is supported at this time.
           */
          @com.google.api.client.util.Key
          private java.lang.String userId;

          /** Patch a dataset for the person identified. Use me to indicate the authenticated user. Only me is
         supported at this time.
           */
          public java.lang.String getUserId() {
            return userId;
          }

          /**
           * Patch a dataset for the person identified. Use me to indicate the authenticated user.
           * Only me is supported at this time.
           */
          public Patch setUserId(java.lang.String userId) {
            this.userId = userId;
            return this;
          }

          /** The data stream ID of the data source that created the dataset. */
          @com.google.api.client.util.Key
          private java.lang.String dataSourceId;

          /** The data stream ID of the data source that created the dataset.
           */
          public java.lang.String getDataSourceId() {
            return dataSourceId;
          }

          /** The data stream ID of the data source that created the dataset. */
          public Patch setDataSourceId(java.lang.String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
          }

          /** This field is not used, and can be safely omitted. */
          @com.google.api.client.util.Key
          private java.lang.String datasetId;

          /** This field is not used, and can be safely omitted.
           */
          public java.lang.String getDatasetId() {
            return datasetId;
          }

          /** This field is not used, and can be safely omitted. */
          public Patch setDatasetId(java.lang.String datasetId) {
            this.datasetId = datasetId;
            return this;
          }

          @Override
          public Patch set(String parameterName, Object value) {
            return (Patch) super.set(parameterName, value);
          }
        }

      }
    }
    /**
     * An accessor for creating requests from the Dataset collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Fitness fitness = new Fitness(...);}
     *   {@code Fitness.Dataset.List request = fitness.dataset().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Dataset dataset() {
      return new Dataset();
    }

    /**
     * The "dataset" collection of methods.
     */
    public class Dataset {

      /**
       * Aggregates data of a certain type or stream into buckets divided by a given type of boundary.
       * Multiple data sets of multiple types and from multiple sources can be aggregated into exactly one
       * bucket type per request.
       *
       * Create a request for the method "dataset.aggregate".
       *
       * This request holds the parameters needed by the fitness server.  After setting any optional
       * parameters, call the {@link Aggregate#execute()} method to invoke the remote operation.
       *
       * @param userId Aggregate data for the person identified. Use me to indicate the authenticated user. Only me is
       *        supported at this time.
       * @param content the {@link com.google.api.services.fitness.model.AggregateRequest}
       * @return the request
       */
      public Aggregate aggregate(java.lang.String userId, com.google.api.services.fitness.model.AggregateRequest content) throws java.io.IOException {
        Aggregate result = new Aggregate(userId, content);
        initialize(result);
        return result;
      }

      public class Aggregate extends FitnessRequest<com.google.api.services.fitness.model.AggregateResponse> {

        private static final String REST_PATH = "{userId}/dataset:aggregate";

        /**
         * Aggregates data of a certain type or stream into buckets divided by a given type of boundary.
         * Multiple data sets of multiple types and from multiple sources can be aggregated into exactly
         * one bucket type per request.
         *
         * Create a request for the method "dataset.aggregate".
         *
         * This request holds the parameters needed by the the fitness server.  After setting any optional
         * parameters, call the {@link Aggregate#execute()} method to invoke the remote operation. <p>
         * {@link
         * Aggregate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId Aggregate data for the person identified. Use me to indicate the authenticated user. Only me is
       *        supported at this time.
         * @param content the {@link com.google.api.services.fitness.model.AggregateRequest}
         * @since 1.13
         */
        protected Aggregate(java.lang.String userId, com.google.api.services.fitness.model.AggregateRequest content) {
          super(Fitness.this, "POST", REST_PATH, content, com.google.api.services.fitness.model.AggregateResponse.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public Aggregate set$Xgafv(java.lang.String $Xgafv) {
          return (Aggregate) super.set$Xgafv($Xgafv);
        }

        @Override
        public Aggregate setAccessToken(java.lang.String accessToken) {
          return (Aggregate) super.setAccessToken(accessToken);
        }

        @Override
        public Aggregate setAlt(java.lang.String alt) {
          return (Aggregate) super.setAlt(alt);
        }

        @Override
        public Aggregate setCallback(java.lang.String callback) {
          return (Aggregate) super.setCallback(callback);
        }

        @Override
        public Aggregate setFields(java.lang.String fields) {
          return (Aggregate) super.setFields(fields);
        }

        @Override
        public Aggregate setKey(java.lang.String key) {
          return (Aggregate) super.setKey(key);
        }

        @Override
        public Aggregate setOauthToken(java.lang.String oauthToken) {
          return (Aggregate) super.setOauthToken(oauthToken);
        }

        @Override
        public Aggregate setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Aggregate) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Aggregate setQuotaUser(java.lang.String quotaUser) {
          return (Aggregate) super.setQuotaUser(quotaUser);
        }

        @Override
        public Aggregate setUploadType(java.lang.String uploadType) {
          return (Aggregate) super.setUploadType(uploadType);
        }

        @Override
        public Aggregate setUploadProtocol(java.lang.String uploadProtocol) {
          return (Aggregate) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Aggregate data for the person identified. Use me to indicate the authenticated user. Only
         * me is supported at this time.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** Aggregate data for the person identified. Use me to indicate the authenticated user. Only me is
       supported at this time.
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * Aggregate data for the person identified. Use me to indicate the authenticated user. Only
         * me is supported at this time.
         */
        public Aggregate setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        @Override
        public Aggregate set(String parameterName, Object value) {
          return (Aggregate) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Sessions collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Fitness fitness = new Fitness(...);}
     *   {@code Fitness.Sessions.List request = fitness.sessions().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Sessions sessions() {
      return new Sessions();
    }

    /**
     * The "sessions" collection of methods.
     */
    public class Sessions {

      /**
       * Deletes a session specified by the given session ID.
       *
       * Create a request for the method "sessions.delete".
       *
       * This request holds the parameters needed by the fitness server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param userId Delete a session for the person identified. Use me to indicate the authenticated user. Only me is
       *        supported at this time.
       * @param sessionId The ID of the session to be deleted.
       * @return the request
       */
      public Delete delete(java.lang.String userId, java.lang.String sessionId) throws java.io.IOException {
        Delete result = new Delete(userId, sessionId);
        initialize(result);
        return result;
      }

      public class Delete extends FitnessRequest<Void> {

        private static final String REST_PATH = "{userId}/sessions/{sessionId}";

        /**
         * Deletes a session specified by the given session ID.
         *
         * Create a request for the method "sessions.delete".
         *
         * This request holds the parameters needed by the the fitness server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId Delete a session for the person identified. Use me to indicate the authenticated user. Only me is
       *        supported at this time.
         * @param sessionId The ID of the session to be deleted.
         * @since 1.13
         */
        protected Delete(java.lang.String userId, java.lang.String sessionId) {
          super(Fitness.this, "DELETE", REST_PATH, null, Void.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.sessionId = com.google.api.client.util.Preconditions.checkNotNull(sessionId, "Required parameter sessionId must be specified.");
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Delete a session for the person identified. Use me to indicate the authenticated user.
         * Only me is supported at this time.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** Delete a session for the person identified. Use me to indicate the authenticated user. Only me is
       supported at this time.
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * Delete a session for the person identified. Use me to indicate the authenticated user.
         * Only me is supported at this time.
         */
        public Delete setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the session to be deleted. */
        @com.google.api.client.util.Key
        private java.lang.String sessionId;

        /** The ID of the session to be deleted.
         */
        public java.lang.String getSessionId() {
          return sessionId;
        }

        /** The ID of the session to be deleted. */
        public Delete setSessionId(java.lang.String sessionId) {
          this.sessionId = sessionId;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Lists sessions previously created.
       *
       * Create a request for the method "sessions.list".
       *
       * This request holds the parameters needed by the fitness server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param userId List sessions for the person identified. Use me to indicate the authenticated user. Only me is
       *        supported at this time.
       * @return the request
       */
      public List list(java.lang.String userId) throws java.io.IOException {
        List result = new List(userId);
        initialize(result);
        return result;
      }

      public class List extends FitnessRequest<com.google.api.services.fitness.model.ListSessionsResponse> {

        private static final String REST_PATH = "{userId}/sessions";

        /**
         * Lists sessions previously created.
         *
         * Create a request for the method "sessions.list".
         *
         * This request holds the parameters needed by the the fitness server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId List sessions for the person identified. Use me to indicate the authenticated user. Only me is
       *        supported at this time.
         * @since 1.13
         */
        protected List(java.lang.String userId) {
          super(Fitness.this, "GET", REST_PATH, null, com.google.api.services.fitness.model.ListSessionsResponse.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * List sessions for the person identified. Use me to indicate the authenticated user. Only
         * me is supported at this time.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** List sessions for the person identified. Use me to indicate the authenticated user. Only me is
       supported at this time.
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * List sessions for the person identified. Use me to indicate the authenticated user. Only
         * me is supported at this time.
         */
        public List setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** If non-empty, only sessions with these activity types should be returned. */
        @com.google.api.client.util.Key
        private java.util.List<java.lang.Integer> activityType;

        /** If non-empty, only sessions with these activity types should be returned.
         */
        public java.util.List<java.lang.Integer> getActivityType() {
          return activityType;
        }

        /** If non-empty, only sessions with these activity types should be returned. */
        public List setActivityType(java.util.List<java.lang.Integer> activityType) {
          this.activityType = activityType;
          return this;
        }

        /**
         * An RFC3339 timestamp. Only sessions ending between the start and end times will be
         * included in the response. If this time is omitted but startTime is specified, all
         * sessions from startTime to the end of time will be returned.
         */
        @com.google.api.client.util.Key
        private java.lang.String endTime;

        /** An RFC3339 timestamp. Only sessions ending between the start and end times will be included in the
       response. If this time is omitted but startTime is specified, all sessions from startTime to the
       end of time will be returned.
         */
        public java.lang.String getEndTime() {
          return endTime;
        }

        /**
         * An RFC3339 timestamp. Only sessions ending between the start and end times will be
         * included in the response. If this time is omitted but startTime is specified, all
         * sessions from startTime to the end of time will be returned.
         */
        public List setEndTime(java.lang.String endTime) {
          this.endTime = endTime;
          return this;
        }

        /**
         * If true, and if both startTime and endTime are omitted, session deletions will be
         * returned.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean includeDeleted;

        /** If true, and if both startTime and endTime are omitted, session deletions will be returned.
         */
        public java.lang.Boolean getIncludeDeleted() {
          return includeDeleted;
        }

        /**
         * If true, and if both startTime and endTime are omitted, session deletions will be
         * returned.
         */
        public List setIncludeDeleted(java.lang.Boolean includeDeleted) {
          this.includeDeleted = includeDeleted;
          return this;
        }

        /**
         * The continuation token, which is used for incremental syncing. To get the next batch of
         * changes, set this parameter to the value of nextPageToken from the previous response. The
         * page token is ignored if either start or end time is specified. If none of start time,
         * end time, and the page token is specified, sessions modified in the last 30 days are
         * returned.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** The continuation token, which is used for incremental syncing. To get the next batch of changes,
       set this parameter to the value of nextPageToken from the previous response. The page token is
       ignored if either start or end time is specified. If none of start time, end time, and the page
       token is specified, sessions modified in the last 30 days are returned.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * The continuation token, which is used for incremental syncing. To get the next batch of
         * changes, set this parameter to the value of nextPageToken from the previous response. The
         * page token is ignored if either start or end time is specified. If none of start time,
         * end time, and the page token is specified, sessions modified in the last 30 days are
         * returned.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /**
         * An RFC3339 timestamp. Only sessions ending between the start and end times will be
         * included in the response. If this time is omitted but endTime is specified, all sessions
         * from the start of time up to endTime will be returned.
         */
        @com.google.api.client.util.Key
        private java.lang.String startTime;

        /** An RFC3339 timestamp. Only sessions ending between the start and end times will be included in the
       response. If this time is omitted but endTime is specified, all sessions from the start of time up
       to endTime will be returned.
         */
        public java.lang.String getStartTime() {
          return startTime;
        }

        /**
         * An RFC3339 timestamp. Only sessions ending between the start and end times will be
         * included in the response. If this time is omitted but endTime is specified, all sessions
         * from the start of time up to endTime will be returned.
         */
        public List setStartTime(java.lang.String startTime) {
          this.startTime = startTime;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates or insert a given session.
       *
       * Create a request for the method "sessions.update".
       *
       * This request holds the parameters needed by the fitness server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param userId Create sessions for the person identified. Use me to indicate the authenticated user. Only me is
       *        supported at this time.
       * @param sessionId The ID of the session to be created.
       * @param content the {@link com.google.api.services.fitness.model.Session}
       * @return the request
       */
      public Update update(java.lang.String userId, java.lang.String sessionId, com.google.api.services.fitness.model.Session content) throws java.io.IOException {
        Update result = new Update(userId, sessionId, content);
        initialize(result);
        return result;
      }

      public class Update extends FitnessRequest<com.google.api.services.fitness.model.Session> {

        private static final String REST_PATH = "{userId}/sessions/{sessionId}";

        /**
         * Updates or insert a given session.
         *
         * Create a request for the method "sessions.update".
         *
         * This request holds the parameters needed by the the fitness server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param userId Create sessions for the person identified. Use me to indicate the authenticated user. Only me is
       *        supported at this time.
         * @param sessionId The ID of the session to be created.
         * @param content the {@link com.google.api.services.fitness.model.Session}
         * @since 1.13
         */
        protected Update(java.lang.String userId, java.lang.String sessionId, com.google.api.services.fitness.model.Session content) {
          super(Fitness.this, "PUT", REST_PATH, content, com.google.api.services.fitness.model.Session.class);
          this.userId = com.google.api.client.util.Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
          this.sessionId = com.google.api.client.util.Preconditions.checkNotNull(sessionId, "Required parameter sessionId must be specified.");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getActivityType(), "Session.getActivityType()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getEndTimeMillis(), "Session.getEndTimeMillis()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getId(), "Session.getId()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getName(), "Session.getName()");
          checkRequiredParameter(content, "content");
          checkRequiredParameter(content.getStartTimeMillis(), "Session.getStartTimeMillis()");
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Create sessions for the person identified. Use me to indicate the authenticated user.
         * Only me is supported at this time.
         */
        @com.google.api.client.util.Key
        private java.lang.String userId;

        /** Create sessions for the person identified. Use me to indicate the authenticated user. Only me is
       supported at this time.
         */
        public java.lang.String getUserId() {
          return userId;
        }

        /**
         * Create sessions for the person identified. Use me to indicate the authenticated user.
         * Only me is supported at this time.
         */
        public Update setUserId(java.lang.String userId) {
          this.userId = userId;
          return this;
        }

        /** The ID of the session to be created. */
        @com.google.api.client.util.Key
        private java.lang.String sessionId;

        /** The ID of the session to be created.
         */
        public java.lang.String getSessionId() {
          return sessionId;
        }

        /** The ID of the session to be created. */
        public Update setSessionId(java.lang.String sessionId) {
          this.sessionId = sessionId;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link Fitness}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Fitness}. */
    @Override
    public Fitness build() {
      return new Fitness(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link FitnessRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setFitnessRequestInitializer(
        FitnessRequestInitializer fitnessRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(fitnessRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
