/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.fitness;

/**
 * Available OAuth 2.0 scopes for use with the Fitness API.
 *
 * @since 1.4
 */
public class FitnessScopes {

  /** Use Google Fit to see and store your physical activity data. */
  public static final String FITNESS_ACTIVITY_READ = "https://www.googleapis.com/auth/fitness.activity.read";

  /** Add to your Google Fit physical activity data. */
  public static final String FITNESS_ACTIVITY_WRITE = "https://www.googleapis.com/auth/fitness.activity.write";

  /** See info about your blood glucose in Google Fit. I consent to Google sharing my blood glucose information with this app.. */
  public static final String FITNESS_BLOOD_GLUCOSE_READ = "https://www.googleapis.com/auth/fitness.blood_glucose.read";

  /** Add info about your blood glucose to Google Fit. I consent to Google using my blood glucose information with this app.. */
  public static final String FITNESS_BLOOD_GLUCOSE_WRITE = "https://www.googleapis.com/auth/fitness.blood_glucose.write";

  /** See info about your blood pressure in Google Fit. I consent to Google sharing my blood pressure information with this app.. */
  public static final String FITNESS_BLOOD_PRESSURE_READ = "https://www.googleapis.com/auth/fitness.blood_pressure.read";

  /** Add info about your blood pressure in Google Fit. I consent to Google using my blood pressure information with this app.. */
  public static final String FITNESS_BLOOD_PRESSURE_WRITE = "https://www.googleapis.com/auth/fitness.blood_pressure.write";

  /** See info about your body measurements in Google Fit. */
  public static final String FITNESS_BODY_READ = "https://www.googleapis.com/auth/fitness.body.read";

  /** Add info about your body measurements to Google Fit. */
  public static final String FITNESS_BODY_WRITE = "https://www.googleapis.com/auth/fitness.body.write";

  /** See info about your body temperature in Google Fit. I consent to Google sharing my body temperature information with this app.. */
  public static final String FITNESS_BODY_TEMPERATURE_READ = "https://www.googleapis.com/auth/fitness.body_temperature.read";

  /** Add to info about your body temperature in Google Fit. I consent to Google using my body temperature information with this app.. */
  public static final String FITNESS_BODY_TEMPERATURE_WRITE = "https://www.googleapis.com/auth/fitness.body_temperature.write";

  /** See your heart rate data in Google Fit. I consent to Google sharing my heart rate information with this app.. */
  public static final String FITNESS_HEART_RATE_READ = "https://www.googleapis.com/auth/fitness.heart_rate.read";

  /** Add to your heart rate data in Google Fit. I consent to Google using my heart rate information with this app.. */
  public static final String FITNESS_HEART_RATE_WRITE = "https://www.googleapis.com/auth/fitness.heart_rate.write";

  /** See your Google Fit speed and distance data. */
  public static final String FITNESS_LOCATION_READ = "https://www.googleapis.com/auth/fitness.location.read";

  /** Add to your Google Fit location data. */
  public static final String FITNESS_LOCATION_WRITE = "https://www.googleapis.com/auth/fitness.location.write";

  /** See info about your nutrition in Google Fit. */
  public static final String FITNESS_NUTRITION_READ = "https://www.googleapis.com/auth/fitness.nutrition.read";

  /** Add to info about your nutrition in Google Fit. */
  public static final String FITNESS_NUTRITION_WRITE = "https://www.googleapis.com/auth/fitness.nutrition.write";

  /** See info about your oxygen saturation in Google Fit. I consent to Google sharing my oxygen saturation information with this app.. */
  public static final String FITNESS_OXYGEN_SATURATION_READ = "https://www.googleapis.com/auth/fitness.oxygen_saturation.read";

  /** Add info about your oxygen saturation in Google Fit. I consent to Google using my oxygen saturation information with this app.. */
  public static final String FITNESS_OXYGEN_SATURATION_WRITE = "https://www.googleapis.com/auth/fitness.oxygen_saturation.write";

  /** See info about your reproductive health in Google Fit. I consent to Google sharing my reproductive health information with this app.. */
  public static final String FITNESS_REPRODUCTIVE_HEALTH_READ = "https://www.googleapis.com/auth/fitness.reproductive_health.read";

  /** Add info about your reproductive health in Google Fit. I consent to Google using my reproductive health information with this app.. */
  public static final String FITNESS_REPRODUCTIVE_HEALTH_WRITE = "https://www.googleapis.com/auth/fitness.reproductive_health.write";

  /** See your sleep data in Google Fit. I consent to Google sharing my sleep information with this app.. */
  public static final String FITNESS_SLEEP_READ = "https://www.googleapis.com/auth/fitness.sleep.read";

  /** Add to your sleep data in Google Fit. I consent to Google using my sleep information with this app.. */
  public static final String FITNESS_SLEEP_WRITE = "https://www.googleapis.com/auth/fitness.sleep.write";

  /**
   * Returns an unmodifiable set that contains all scopes declared by this class.
   *
   * @since 1.16
   */
  public static java.util.Set<String> all() {
    java.util.Set<String> set = new java.util.HashSet<String>();
    set.add(FITNESS_ACTIVITY_READ);
    set.add(FITNESS_ACTIVITY_WRITE);
    set.add(FITNESS_BLOOD_GLUCOSE_READ);
    set.add(FITNESS_BLOOD_GLUCOSE_WRITE);
    set.add(FITNESS_BLOOD_PRESSURE_READ);
    set.add(FITNESS_BLOOD_PRESSURE_WRITE);
    set.add(FITNESS_BODY_READ);
    set.add(FITNESS_BODY_WRITE);
    set.add(FITNESS_BODY_TEMPERATURE_READ);
    set.add(FITNESS_BODY_TEMPERATURE_WRITE);
    set.add(FITNESS_HEART_RATE_READ);
    set.add(FITNESS_HEART_RATE_WRITE);
    set.add(FITNESS_LOCATION_READ);
    set.add(FITNESS_LOCATION_WRITE);
    set.add(FITNESS_NUTRITION_READ);
    set.add(FITNESS_NUTRITION_WRITE);
    set.add(FITNESS_OXYGEN_SATURATION_READ);
    set.add(FITNESS_OXYGEN_SATURATION_WRITE);
    set.add(FITNESS_REPRODUCTIVE_HEALTH_READ);
    set.add(FITNESS_REPRODUCTIVE_HEALTH_WRITE);
    set.add(FITNESS_SLEEP_READ);
    set.add(FITNESS_SLEEP_WRITE);
    return java.util.Collections.unmodifiableSet(set);
  }

  private FitnessScopes() {
  }
}
