/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.fitness.model;

/**
 * Model definition for AggregateBucket.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Fitness API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AggregateBucket extends com.google.api.client.json.GenericJson {

  /**
   * Available for Bucket.Type.ACTIVITY_TYPE, Bucket.Type.ACTIVITY_SEGMENT
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer activity;

  /**
   * There will be one dataset per AggregateBy in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Dataset> dataset;

  /**
   * The end time for the aggregated data, in milliseconds since epoch, inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long endTimeMillis;

  /**
   * Available for Bucket.Type.SESSION
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Session session;

  /**
   * The start time for the aggregated data, in milliseconds since epoch, inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long startTimeMillis;

  /**
   * The type of a bucket signifies how the data aggregation is performed in the bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Available for Bucket.Type.ACTIVITY_TYPE, Bucket.Type.ACTIVITY_SEGMENT
   * @return value or {@code null} for none
   */
  public java.lang.Integer getActivity() {
    return activity;
  }

  /**
   * Available for Bucket.Type.ACTIVITY_TYPE, Bucket.Type.ACTIVITY_SEGMENT
   * @param activity activity or {@code null} for none
   */
  public AggregateBucket setActivity(java.lang.Integer activity) {
    this.activity = activity;
    return this;
  }

  /**
   * There will be one dataset per AggregateBy in the request.
   * @return value or {@code null} for none
   */
  public java.util.List<Dataset> getDataset() {
    return dataset;
  }

  /**
   * There will be one dataset per AggregateBy in the request.
   * @param dataset dataset or {@code null} for none
   */
  public AggregateBucket setDataset(java.util.List<Dataset> dataset) {
    this.dataset = dataset;
    return this;
  }

  /**
   * The end time for the aggregated data, in milliseconds since epoch, inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Long getEndTimeMillis() {
    return endTimeMillis;
  }

  /**
   * The end time for the aggregated data, in milliseconds since epoch, inclusive.
   * @param endTimeMillis endTimeMillis or {@code null} for none
   */
  public AggregateBucket setEndTimeMillis(java.lang.Long endTimeMillis) {
    this.endTimeMillis = endTimeMillis;
    return this;
  }

  /**
   * Available for Bucket.Type.SESSION
   * @return value or {@code null} for none
   */
  public Session getSession() {
    return session;
  }

  /**
   * Available for Bucket.Type.SESSION
   * @param session session or {@code null} for none
   */
  public AggregateBucket setSession(Session session) {
    this.session = session;
    return this;
  }

  /**
   * The start time for the aggregated data, in milliseconds since epoch, inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Long getStartTimeMillis() {
    return startTimeMillis;
  }

  /**
   * The start time for the aggregated data, in milliseconds since epoch, inclusive.
   * @param startTimeMillis startTimeMillis or {@code null} for none
   */
  public AggregateBucket setStartTimeMillis(java.lang.Long startTimeMillis) {
    this.startTimeMillis = startTimeMillis;
    return this;
  }

  /**
   * The type of a bucket signifies how the data aggregation is performed in the bucket.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of a bucket signifies how the data aggregation is performed in the bucket.
   * @param type type or {@code null} for none
   */
  public AggregateBucket setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public AggregateBucket set(String fieldName, Object value) {
    return (AggregateBucket) super.set(fieldName, value);
  }

  @Override
  public AggregateBucket clone() {
    return (AggregateBucket) super.clone();
  }

}
