/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.fitness.model;

/**
 * The specification of which data to aggregate.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Fitness API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AggregateBy extends com.google.api.client.json.GenericJson {

  /**
   * A data source ID to aggregate. Only data from the specified data source ID will be included in
   * the aggregation. If specified, this data source must exist; the OAuth scopes in the supplied
   * credentials must grant read access to this data type. The dataset in the response will have the
   * same data source ID. Note: Data can be aggregated by either the dataTypeName or the
   * dataSourceId, not both.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataSourceId;

  /**
   * The data type to aggregate. All data sources providing this data type will contribute data to
   * the aggregation. The response will contain a single dataset for this data type name. The
   * dataset will have a data source ID of derived::com.google.android.gms:aggregated. If the user
   * has no data for this data type, an empty data set will be returned. Note: Data can be
   * aggregated by either the dataTypeName or the dataSourceId, not both.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataTypeName;

  /**
   * A data source ID to aggregate. Only data from the specified data source ID will be included in
   * the aggregation. If specified, this data source must exist; the OAuth scopes in the supplied
   * credentials must grant read access to this data type. The dataset in the response will have the
   * same data source ID. Note: Data can be aggregated by either the dataTypeName or the
   * dataSourceId, not both.
   * @return value or {@code null} for none
   */
  public java.lang.String getDataSourceId() {
    return dataSourceId;
  }

  /**
   * A data source ID to aggregate. Only data from the specified data source ID will be included in
   * the aggregation. If specified, this data source must exist; the OAuth scopes in the supplied
   * credentials must grant read access to this data type. The dataset in the response will have the
   * same data source ID. Note: Data can be aggregated by either the dataTypeName or the
   * dataSourceId, not both.
   * @param dataSourceId dataSourceId or {@code null} for none
   */
  public AggregateBy setDataSourceId(java.lang.String dataSourceId) {
    this.dataSourceId = dataSourceId;
    return this;
  }

  /**
   * The data type to aggregate. All data sources providing this data type will contribute data to
   * the aggregation. The response will contain a single dataset for this data type name. The
   * dataset will have a data source ID of derived::com.google.android.gms:aggregated. If the user
   * has no data for this data type, an empty data set will be returned. Note: Data can be
   * aggregated by either the dataTypeName or the dataSourceId, not both.
   * @return value or {@code null} for none
   */
  public java.lang.String getDataTypeName() {
    return dataTypeName;
  }

  /**
   * The data type to aggregate. All data sources providing this data type will contribute data to
   * the aggregation. The response will contain a single dataset for this data type name. The
   * dataset will have a data source ID of derived::com.google.android.gms:aggregated. If the user
   * has no data for this data type, an empty data set will be returned. Note: Data can be
   * aggregated by either the dataTypeName or the dataSourceId, not both.
   * @param dataTypeName dataTypeName or {@code null} for none
   */
  public AggregateBy setDataTypeName(java.lang.String dataTypeName) {
    this.dataTypeName = dataTypeName;
    return this;
  }

  @Override
  public AggregateBy set(String fieldName, Object value) {
    return (AggregateBy) super.set(fieldName, value);
  }

  @Override
  public AggregateBy clone() {
    return (AggregateBy) super.clone();
  }

}
