/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.fitness.model;

/**
 * Model definition for BucketByTime.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Fitness API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BucketByTime extends com.google.api.client.json.GenericJson {

  /**
   * Specifies that result buckets aggregate data by exactly durationMillis time frames. Time frames
   * that contain no data will be included in the response with an empty dataset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long durationMillis;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BucketByTimePeriod period;

  /**
   * Specifies that result buckets aggregate data by exactly durationMillis time frames. Time frames
   * that contain no data will be included in the response with an empty dataset.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDurationMillis() {
    return durationMillis;
  }

  /**
   * Specifies that result buckets aggregate data by exactly durationMillis time frames. Time frames
   * that contain no data will be included in the response with an empty dataset.
   * @param durationMillis durationMillis or {@code null} for none
   */
  public BucketByTime setDurationMillis(java.lang.Long durationMillis) {
    this.durationMillis = durationMillis;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public BucketByTimePeriod getPeriod() {
    return period;
  }

  /**
   * @param period period or {@code null} for none
   */
  public BucketByTime setPeriod(BucketByTimePeriod period) {
    this.period = period;
    return this;
  }

  @Override
  public BucketByTime set(String fieldName, Object value) {
    return (BucketByTime) super.set(fieldName, value);
  }

  @Override
  public BucketByTime clone() {
    return (BucketByTime) super.clone();
  }

}
