/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.fitness.model;

/**
 * Model definition for ListDataPointChangesResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Fitness API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListDataPointChangesResponse extends com.google.api.client.json.GenericJson {

  /**
   * The data stream ID of the data source with data point changes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataSourceId;

  /**
   * Deleted data points for the user. Note, for modifications this should be parsed before handling
   * insertions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DataPoint> deletedDataPoint;

  static {
    // hack to force ProGuard to consider DataPoint used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DataPoint.class);
  }

  /**
   * Inserted data points for the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DataPoint> insertedDataPoint;

  static {
    // hack to force ProGuard to consider DataPoint used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DataPoint.class);
  }

  /**
   * The continuation token, which is used to page through large result sets. Provide this value in
   * a subsequent request to return the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The data stream ID of the data source with data point changes.
   * @return value or {@code null} for none
   */
  public java.lang.String getDataSourceId() {
    return dataSourceId;
  }

  /**
   * The data stream ID of the data source with data point changes.
   * @param dataSourceId dataSourceId or {@code null} for none
   */
  public ListDataPointChangesResponse setDataSourceId(java.lang.String dataSourceId) {
    this.dataSourceId = dataSourceId;
    return this;
  }

  /**
   * Deleted data points for the user. Note, for modifications this should be parsed before handling
   * insertions.
   * @return value or {@code null} for none
   */
  public java.util.List<DataPoint> getDeletedDataPoint() {
    return deletedDataPoint;
  }

  /**
   * Deleted data points for the user. Note, for modifications this should be parsed before handling
   * insertions.
   * @param deletedDataPoint deletedDataPoint or {@code null} for none
   */
  public ListDataPointChangesResponse setDeletedDataPoint(java.util.List<DataPoint> deletedDataPoint) {
    this.deletedDataPoint = deletedDataPoint;
    return this;
  }

  /**
   * Inserted data points for the user.
   * @return value or {@code null} for none
   */
  public java.util.List<DataPoint> getInsertedDataPoint() {
    return insertedDataPoint;
  }

  /**
   * Inserted data points for the user.
   * @param insertedDataPoint insertedDataPoint or {@code null} for none
   */
  public ListDataPointChangesResponse setInsertedDataPoint(java.util.List<DataPoint> insertedDataPoint) {
    this.insertedDataPoint = insertedDataPoint;
    return this;
  }

  /**
   * The continuation token, which is used to page through large result sets. Provide this value in
   * a subsequent request to return the next page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The continuation token, which is used to page through large result sets. Provide this value in
   * a subsequent request to return the next page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListDataPointChangesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListDataPointChangesResponse set(String fieldName, Object value) {
    return (ListDataPointChangesResponse) super.set(fieldName, value);
  }

  @Override
  public ListDataPointChangesResponse clone() {
    return (ListDataPointChangesResponse) super.clone();
  }

}
