/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.fitness;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.fitness.FitnessRequest;
import com.google.api.services.fitness.FitnessRequestInitializer;
import com.google.api.services.fitness.model.AggregateRequest;
import com.google.api.services.fitness.model.AggregateResponse;
import com.google.api.services.fitness.model.DataSource;
import com.google.api.services.fitness.model.Dataset;
import com.google.api.services.fitness.model.ListDataPointChangesResponse;
import com.google.api.services.fitness.model.ListDataSourcesResponse;
import com.google.api.services.fitness.model.ListSessionsResponse;
import com.google.api.services.fitness.model.Session;
import java.io.IOException;
import java.util.List;

public class Fitness
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://fitness.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://fitness.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "fitness/v1/users/";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://fitness.googleapis.com/fitness/v1/users/";

    public Fitness(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Fitness(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Users users() {
        return new Users();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.32.1 of the Fitness API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Fitness.DEFAULT_MTLS_ROOT_URL;
            }
            return Fitness.DEFAULT_ROOT_URL;
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Fitness.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Fitness.DEFAULT_BATCH_PATH);
        }

        public Fitness build() {
            return new Fitness(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setFitnessRequestInitializer(FitnessRequestInitializer fitnessRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)fitnessRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Users {
        public DataSources dataSources() {
            return new DataSources();
        }

        public Dataset dataset() {
            return new Dataset();
        }

        public Sessions sessions() {
            return new Sessions();
        }

        public class Sessions {
            public Delete delete(String userId, String sessionId) throws IOException {
                Delete result = new Delete(userId, sessionId);
                Fitness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String userId) throws IOException {
                List result = new List(userId);
                Fitness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String userId, String sessionId, Session content) throws IOException {
                Update result = new Update(userId, sessionId, content);
                Fitness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends FitnessRequest<Session> {
                private static final String REST_PATH = "{userId}/sessions/{sessionId}";
                @Key
                private String userId;
                @Key
                private String sessionId;

                protected Update(String userId, String sessionId, Session content) {
                    super(Fitness.this, "PUT", REST_PATH, (Object)content, Session.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.sessionId = (String)Preconditions.checkNotNull((Object)sessionId, (Object)"Required parameter sessionId must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getActivityType(), "Session.getActivityType()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getEndTimeMillis(), "Session.getEndTimeMillis()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getId(), "Session.getId()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getName(), "Session.getName()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getStartTimeMillis(), "Session.getStartTimeMillis()");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Update setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getSessionId() {
                    return this.sessionId;
                }

                public Update setSessionId(String sessionId) {
                    this.sessionId = sessionId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class List
            extends FitnessRequest<ListSessionsResponse> {
                private static final String REST_PATH = "{userId}/sessions";
                @Key
                private String userId;
                @Key
                private java.util.List<Integer> activityType;
                @Key
                private String endTime;
                @Key
                private Boolean includeDeleted;
                @Key
                private String pageToken;
                @Key
                private String startTime;

                protected List(String userId) {
                    super(Fitness.this, "GET", REST_PATH, null, ListSessionsResponse.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserId() {
                    return this.userId;
                }

                public List setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public java.util.List<Integer> getActivityType() {
                    return this.activityType;
                }

                public List setActivityType(java.util.List<Integer> activityType) {
                    this.activityType = activityType;
                    return this;
                }

                public String getEndTime() {
                    return this.endTime;
                }

                public List setEndTime(String endTime) {
                    this.endTime = endTime;
                    return this;
                }

                public Boolean getIncludeDeleted() {
                    return this.includeDeleted;
                }

                public List setIncludeDeleted(Boolean includeDeleted) {
                    this.includeDeleted = includeDeleted;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getStartTime() {
                    return this.startTime;
                }

                public List setStartTime(String startTime) {
                    this.startTime = startTime;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Delete
            extends FitnessRequest<Void> {
                private static final String REST_PATH = "{userId}/sessions/{sessionId}";
                @Key
                private String userId;
                @Key
                private String sessionId;

                protected Delete(String userId, String sessionId) {
                    super(Fitness.this, "DELETE", REST_PATH, null, Void.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.sessionId = (String)Preconditions.checkNotNull((Object)sessionId, (Object)"Required parameter sessionId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Delete setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getSessionId() {
                    return this.sessionId;
                }

                public Delete setSessionId(String sessionId) {
                    this.sessionId = sessionId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Dataset {
            public Aggregate aggregate(String userId, AggregateRequest content) throws IOException {
                Aggregate result = new Aggregate(userId, content);
                Fitness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Aggregate
            extends FitnessRequest<AggregateResponse> {
                private static final String REST_PATH = "{userId}/dataset:aggregate";
                @Key
                private String userId;

                protected Aggregate(String userId, AggregateRequest content) {
                    super(Fitness.this, "POST", REST_PATH, (Object)content, AggregateResponse.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public Aggregate set$Xgafv(String $Xgafv) {
                    return (Aggregate)super.set$Xgafv($Xgafv);
                }

                public Aggregate setAccessToken(String accessToken) {
                    return (Aggregate)super.setAccessToken(accessToken);
                }

                public Aggregate setAlt(String alt) {
                    return (Aggregate)super.setAlt(alt);
                }

                public Aggregate setCallback(String callback) {
                    return (Aggregate)super.setCallback(callback);
                }

                public Aggregate setFields(String fields) {
                    return (Aggregate)super.setFields(fields);
                }

                public Aggregate setKey(String key) {
                    return (Aggregate)super.setKey(key);
                }

                public Aggregate setOauthToken(String oauthToken) {
                    return (Aggregate)super.setOauthToken(oauthToken);
                }

                public Aggregate setPrettyPrint(Boolean prettyPrint) {
                    return (Aggregate)super.setPrettyPrint(prettyPrint);
                }

                public Aggregate setQuotaUser(String quotaUser) {
                    return (Aggregate)super.setQuotaUser(quotaUser);
                }

                public Aggregate setUploadType(String uploadType) {
                    return (Aggregate)super.setUploadType(uploadType);
                }

                public Aggregate setUploadProtocol(String uploadProtocol) {
                    return (Aggregate)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Aggregate setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public Aggregate set(String parameterName, Object value) {
                    return (Aggregate)super.set(parameterName, value);
                }
            }
        }

        public class DataSources {
            public Create create(String userId, DataSource content) throws IOException {
                Create result = new Create(userId, content);
                Fitness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String userId, String dataSourceId) throws IOException {
                Delete result = new Delete(userId, dataSourceId);
                Fitness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String userId, String dataSourceId) throws IOException {
                Get result = new Get(userId, dataSourceId);
                Fitness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String userId) throws IOException {
                List result = new List(userId);
                Fitness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String userId, String dataSourceId, DataSource content) throws IOException {
                Update result = new Update(userId, dataSourceId, content);
                Fitness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public DataPointChanges dataPointChanges() {
                return new DataPointChanges();
            }

            public Datasets datasets() {
                return new Datasets();
            }

            public class Datasets {
                public Delete delete(String userId, String dataSourceId, String datasetId) throws IOException {
                    Delete result = new Delete(userId, dataSourceId, datasetId);
                    Fitness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String userId, String dataSourceId, String datasetId) throws IOException {
                    Get result = new Get(userId, dataSourceId, datasetId);
                    Fitness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String userId, String dataSourceId, String datasetId, com.google.api.services.fitness.model.Dataset content) throws IOException {
                    Patch result = new Patch(userId, dataSourceId, datasetId, content);
                    Fitness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Patch
                extends FitnessRequest<com.google.api.services.fitness.model.Dataset> {
                    private static final String REST_PATH = "{userId}/dataSources/{dataSourceId}/datasets/{datasetId}";
                    @Key
                    private String userId;
                    @Key
                    private String dataSourceId;
                    @Key
                    private String datasetId;

                    protected Patch(String userId, String dataSourceId, String datasetId, com.google.api.services.fitness.model.Dataset content) {
                        super(Fitness.this, "PATCH", REST_PATH, (Object)content, com.google.api.services.fitness.model.Dataset.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.dataSourceId = (String)Preconditions.checkNotNull((Object)dataSourceId, (Object)"Required parameter dataSourceId must be specified.");
                        this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                        this.checkRequiredParameter((Object)content, "content");
                        this.checkRequiredParameter(content.getDataSourceId(), "Dataset.getDataSourceId()");
                        this.checkRequiredParameter((Object)content, "content");
                        this.checkRequiredParameter(content.getMaxEndTimeNs(), "Dataset.getMaxEndTimeNs()");
                        this.checkRequiredParameter((Object)content, "content");
                        this.checkRequiredParameter(content.getMinStartTimeNs(), "Dataset.getMinStartTimeNs()");
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Patch setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getDataSourceId() {
                        return this.dataSourceId;
                    }

                    public Patch setDataSourceId(String dataSourceId) {
                        this.dataSourceId = dataSourceId;
                        return this;
                    }

                    public String getDatasetId() {
                        return this.datasetId;
                    }

                    public Patch setDatasetId(String datasetId) {
                        this.datasetId = datasetId;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class Get
                extends FitnessRequest<com.google.api.services.fitness.model.Dataset> {
                    private static final String REST_PATH = "{userId}/dataSources/{dataSourceId}/datasets/{datasetId}";
                    @Key
                    private String userId;
                    @Key
                    private String dataSourceId;
                    @Key
                    private String datasetId;
                    @Key
                    private Integer limit;
                    @Key
                    private String pageToken;

                    protected Get(String userId, String dataSourceId, String datasetId) {
                        super(Fitness.this, "GET", REST_PATH, null, com.google.api.services.fitness.model.Dataset.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.dataSourceId = (String)Preconditions.checkNotNull((Object)dataSourceId, (Object)"Required parameter dataSourceId must be specified.");
                        this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Get setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getDataSourceId() {
                        return this.dataSourceId;
                    }

                    public Get setDataSourceId(String dataSourceId) {
                        this.dataSourceId = dataSourceId;
                        return this;
                    }

                    public String getDatasetId() {
                        return this.datasetId;
                    }

                    public Get setDatasetId(String datasetId) {
                        this.datasetId = datasetId;
                        return this;
                    }

                    public Integer getLimit() {
                        return this.limit;
                    }

                    public Get setLimit(Integer limit) {
                        this.limit = limit;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public Get setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends FitnessRequest<Void> {
                    private static final String REST_PATH = "{userId}/dataSources/{dataSourceId}/datasets/{datasetId}";
                    @Key
                    private String userId;
                    @Key
                    private String dataSourceId;
                    @Key
                    private String datasetId;

                    protected Delete(String userId, String dataSourceId, String datasetId) {
                        super(Fitness.this, "DELETE", REST_PATH, null, Void.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.dataSourceId = (String)Preconditions.checkNotNull((Object)dataSourceId, (Object)"Required parameter dataSourceId must be specified.");
                        this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"Required parameter datasetId must be specified.");
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public Delete setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getDataSourceId() {
                        return this.dataSourceId;
                    }

                    public Delete setDataSourceId(String dataSourceId) {
                        this.dataSourceId = dataSourceId;
                        return this;
                    }

                    public String getDatasetId() {
                        return this.datasetId;
                    }

                    public Delete setDatasetId(String datasetId) {
                        this.datasetId = datasetId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }
            }

            public class DataPointChanges {
                public List list(String userId, String dataSourceId) throws IOException {
                    List result = new List(userId, dataSourceId);
                    Fitness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends FitnessRequest<ListDataPointChangesResponse> {
                    private static final String REST_PATH = "{userId}/dataSources/{dataSourceId}/dataPointChanges";
                    @Key
                    private String userId;
                    @Key
                    private String dataSourceId;
                    @Key
                    private Integer limit;
                    @Key
                    private String pageToken;

                    protected List(String userId, String dataSourceId) {
                        super(Fitness.this, "GET", REST_PATH, null, ListDataPointChangesResponse.class);
                        this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                        this.dataSourceId = (String)Preconditions.checkNotNull((Object)dataSourceId, (Object)"Required parameter dataSourceId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getUserId() {
                        return this.userId;
                    }

                    public List setUserId(String userId) {
                        this.userId = userId;
                        return this;
                    }

                    public String getDataSourceId() {
                        return this.dataSourceId;
                    }

                    public List setDataSourceId(String dataSourceId) {
                        this.dataSourceId = dataSourceId;
                        return this;
                    }

                    public Integer getLimit() {
                        return this.limit;
                    }

                    public List setLimit(Integer limit) {
                        this.limit = limit;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class Update
            extends FitnessRequest<DataSource> {
                private static final String REST_PATH = "{userId}/dataSources/{dataSourceId}";
                @Key
                private String userId;
                @Key
                private String dataSourceId;

                protected Update(String userId, String dataSourceId, DataSource content) {
                    super(Fitness.this, "PUT", REST_PATH, (Object)content, DataSource.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.dataSourceId = (String)Preconditions.checkNotNull((Object)dataSourceId, (Object)"Required parameter dataSourceId must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getDataStreamId(), "DataSource.getDataStreamId()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getType(), "DataSource.getType()");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Update setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getDataSourceId() {
                    return this.dataSourceId;
                }

                public Update setDataSourceId(String dataSourceId) {
                    this.dataSourceId = dataSourceId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class List
            extends FitnessRequest<ListDataSourcesResponse> {
                private static final String REST_PATH = "{userId}/dataSources";
                @Key
                private String userId;
                @Key
                private java.util.List<String> dataTypeName;

                protected List(String userId) {
                    super(Fitness.this, "GET", REST_PATH, null, ListDataSourcesResponse.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserId() {
                    return this.userId;
                }

                public List setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public java.util.List<String> getDataTypeName() {
                    return this.dataTypeName;
                }

                public List setDataTypeName(java.util.List<String> dataTypeName) {
                    this.dataTypeName = dataTypeName;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends FitnessRequest<DataSource> {
                private static final String REST_PATH = "{userId}/dataSources/{dataSourceId}";
                @Key
                private String userId;
                @Key
                private String dataSourceId;

                protected Get(String userId, String dataSourceId) {
                    super(Fitness.this, "GET", REST_PATH, null, DataSource.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.dataSourceId = (String)Preconditions.checkNotNull((Object)dataSourceId, (Object)"Required parameter dataSourceId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Get setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getDataSourceId() {
                    return this.dataSourceId;
                }

                public Get setDataSourceId(String dataSourceId) {
                    this.dataSourceId = dataSourceId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends FitnessRequest<DataSource> {
                private static final String REST_PATH = "{userId}/dataSources/{dataSourceId}";
                @Key
                private String userId;
                @Key
                private String dataSourceId;

                protected Delete(String userId, String dataSourceId) {
                    super(Fitness.this, "DELETE", REST_PATH, null, DataSource.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.dataSourceId = (String)Preconditions.checkNotNull((Object)dataSourceId, (Object)"Required parameter dataSourceId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Delete setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getDataSourceId() {
                    return this.dataSourceId;
                }

                public Delete setDataSourceId(String dataSourceId) {
                    this.dataSourceId = dataSourceId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends FitnessRequest<DataSource> {
                private static final String REST_PATH = "{userId}/dataSources";
                @Key
                private String userId;

                protected Create(String userId, DataSource content) {
                    super(Fitness.this, "POST", REST_PATH, (Object)content, DataSource.class);
                    this.userId = (String)Preconditions.checkNotNull((Object)userId, (Object)"Required parameter userId must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getType(), "DataSource.getType()");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserId() {
                    return this.userId;
                }

                public Create setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }
    }
}

