/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.fitness.model;

/**
 * Represents a single data point, generated by a particular data source. A data point holds a value
 * for each field, an end timestamp and an optional start time. The exact semantics of each of these
 * attributes are specified in the documentation for the particular data type. A data point can
 * represent an instantaneous measurement, reading or input observation, as well as averages or
 * aggregates over a time interval. Check the data type documentation to determine which is the case
 * for a particular data type. Data points always contain one value for each field of the data type.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Fitness API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DataPoint extends com.google.api.client.json.GenericJson {

  /**
   * DO NOT USE THIS FIELD. It is ignored, and not stored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long computationTimeMillis;

  /**
   * The data type defining the format of the values in this data point.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataTypeName;

  /**
   * The end time of the interval represented by this data point, in nanoseconds since epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long endTimeNanos;

  /**
   * Indicates the last time this data point was modified. Useful only in contexts where we are
   * listing the data changes, rather than representing the current state of the data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long modifiedTimeMillis;

  /**
   * If the data point is contained in a dataset for a derived data source, this field will be
   * populated with the data source stream ID that created the data point originally. WARNING: do
   * not rely on this field for anything other than debugging. The value of this field, if it is set
   * at all, is an implementation detail and is not guaranteed to remain consistent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String originDataSourceId;

  /**
   * The raw timestamp from the original SensorEvent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long rawTimestampNanos;

  /**
   * The start time of the interval represented by this data point, in nanoseconds since epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long startTimeNanos;

  /**
   * Values of each data type field for the data point. It is expected that each value corresponding
   * to a data type field will occur in the same order that the field is listed with in the data
   * type specified in a data source. Only one of integer and floating point fields will be
   * populated, depending on the format enum value within data source's type field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Value> value;

  /**
   * DO NOT USE THIS FIELD. It is ignored, and not stored.
   * @return value or {@code null} for none
   */
  public java.lang.Long getComputationTimeMillis() {
    return computationTimeMillis;
  }

  /**
   * DO NOT USE THIS FIELD. It is ignored, and not stored.
   * @param computationTimeMillis computationTimeMillis or {@code null} for none
   */
  public DataPoint setComputationTimeMillis(java.lang.Long computationTimeMillis) {
    this.computationTimeMillis = computationTimeMillis;
    return this;
  }

  /**
   * The data type defining the format of the values in this data point.
   * @return value or {@code null} for none
   */
  public java.lang.String getDataTypeName() {
    return dataTypeName;
  }

  /**
   * The data type defining the format of the values in this data point.
   * @param dataTypeName dataTypeName or {@code null} for none
   */
  public DataPoint setDataTypeName(java.lang.String dataTypeName) {
    this.dataTypeName = dataTypeName;
    return this;
  }

  /**
   * The end time of the interval represented by this data point, in nanoseconds since epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getEndTimeNanos() {
    return endTimeNanos;
  }

  /**
   * The end time of the interval represented by this data point, in nanoseconds since epoch.
   * @param endTimeNanos endTimeNanos or {@code null} for none
   */
  public DataPoint setEndTimeNanos(java.lang.Long endTimeNanos) {
    this.endTimeNanos = endTimeNanos;
    return this;
  }

  /**
   * Indicates the last time this data point was modified. Useful only in contexts where we are
   * listing the data changes, rather than representing the current state of the data.
   * @return value or {@code null} for none
   */
  public java.lang.Long getModifiedTimeMillis() {
    return modifiedTimeMillis;
  }

  /**
   * Indicates the last time this data point was modified. Useful only in contexts where we are
   * listing the data changes, rather than representing the current state of the data.
   * @param modifiedTimeMillis modifiedTimeMillis or {@code null} for none
   */
  public DataPoint setModifiedTimeMillis(java.lang.Long modifiedTimeMillis) {
    this.modifiedTimeMillis = modifiedTimeMillis;
    return this;
  }

  /**
   * If the data point is contained in a dataset for a derived data source, this field will be
   * populated with the data source stream ID that created the data point originally. WARNING: do
   * not rely on this field for anything other than debugging. The value of this field, if it is set
   * at all, is an implementation detail and is not guaranteed to remain consistent.
   * @return value or {@code null} for none
   */
  public java.lang.String getOriginDataSourceId() {
    return originDataSourceId;
  }

  /**
   * If the data point is contained in a dataset for a derived data source, this field will be
   * populated with the data source stream ID that created the data point originally. WARNING: do
   * not rely on this field for anything other than debugging. The value of this field, if it is set
   * at all, is an implementation detail and is not guaranteed to remain consistent.
   * @param originDataSourceId originDataSourceId or {@code null} for none
   */
  public DataPoint setOriginDataSourceId(java.lang.String originDataSourceId) {
    this.originDataSourceId = originDataSourceId;
    return this;
  }

  /**
   * The raw timestamp from the original SensorEvent.
   * @return value or {@code null} for none
   */
  public java.lang.Long getRawTimestampNanos() {
    return rawTimestampNanos;
  }

  /**
   * The raw timestamp from the original SensorEvent.
   * @param rawTimestampNanos rawTimestampNanos or {@code null} for none
   */
  public DataPoint setRawTimestampNanos(java.lang.Long rawTimestampNanos) {
    this.rawTimestampNanos = rawTimestampNanos;
    return this;
  }

  /**
   * The start time of the interval represented by this data point, in nanoseconds since epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getStartTimeNanos() {
    return startTimeNanos;
  }

  /**
   * The start time of the interval represented by this data point, in nanoseconds since epoch.
   * @param startTimeNanos startTimeNanos or {@code null} for none
   */
  public DataPoint setStartTimeNanos(java.lang.Long startTimeNanos) {
    this.startTimeNanos = startTimeNanos;
    return this;
  }

  /**
   * Values of each data type field for the data point. It is expected that each value corresponding
   * to a data type field will occur in the same order that the field is listed with in the data
   * type specified in a data source. Only one of integer and floating point fields will be
   * populated, depending on the format enum value within data source's type field.
   * @return value or {@code null} for none
   */
  public java.util.List<Value> getValue() {
    return value;
  }

  /**
   * Values of each data type field for the data point. It is expected that each value corresponding
   * to a data type field will occur in the same order that the field is listed with in the data
   * type specified in a data source. Only one of integer and floating point fields will be
   * populated, depending on the format enum value within data source's type field.
   * @param value value or {@code null} for none
   */
  public DataPoint setValue(java.util.List<Value> value) {
    this.value = value;
    return this;
  }

  @Override
  public DataPoint set(String fieldName, Object value) {
    return (DataPoint) super.set(fieldName, value);
  }

  @Override
  public DataPoint clone() {
    return (DataPoint) super.clone();
  }

}
