/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.fitness.model;

/**
 * Sessions contain metadata, such as a user-friendly name and time interval information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Fitness API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Session extends com.google.api.client.json.GenericJson {

  /**
   * Session active time. While start_time_millis and end_time_millis define the full session time,
   * the active time can be shorter and specified by active_time_millis. If the inactive time during
   * the session is known, it should also be inserted via a com.google.activity.segment data point
   * with a STILL activity value
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long activeTimeMillis;

  /**
   * The type of activity this session represents.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer activityType;

  /**
   * The application that created the session.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Application application;

  /**
   * A description for this session.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * An end time, in milliseconds since epoch, inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long endTimeMillis;

  /**
   * A client-generated identifier that is unique across all sessions owned by this particular user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * A timestamp that indicates when the session was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long modifiedTimeMillis;

  /**
   * A human readable name of the session.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * A start time, in milliseconds since epoch, inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long startTimeMillis;

  /**
   * Session active time. While start_time_millis and end_time_millis define the full session time,
   * the active time can be shorter and specified by active_time_millis. If the inactive time during
   * the session is known, it should also be inserted via a com.google.activity.segment data point
   * with a STILL activity value
   * @return value or {@code null} for none
   */
  public java.lang.Long getActiveTimeMillis() {
    return activeTimeMillis;
  }

  /**
   * Session active time. While start_time_millis and end_time_millis define the full session time,
   * the active time can be shorter and specified by active_time_millis. If the inactive time during
   * the session is known, it should also be inserted via a com.google.activity.segment data point
   * with a STILL activity value
   * @param activeTimeMillis activeTimeMillis or {@code null} for none
   */
  public Session setActiveTimeMillis(java.lang.Long activeTimeMillis) {
    this.activeTimeMillis = activeTimeMillis;
    return this;
  }

  /**
   * The type of activity this session represents.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getActivityType() {
    return activityType;
  }

  /**
   * The type of activity this session represents.
   * @param activityType activityType or {@code null} for none
   */
  public Session setActivityType(java.lang.Integer activityType) {
    this.activityType = activityType;
    return this;
  }

  /**
   * The application that created the session.
   * @return value or {@code null} for none
   */
  public Application getApplication() {
    return application;
  }

  /**
   * The application that created the session.
   * @param application application or {@code null} for none
   */
  public Session setApplication(Application application) {
    this.application = application;
    return this;
  }

  /**
   * A description for this session.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A description for this session.
   * @param description description or {@code null} for none
   */
  public Session setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * An end time, in milliseconds since epoch, inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Long getEndTimeMillis() {
    return endTimeMillis;
  }

  /**
   * An end time, in milliseconds since epoch, inclusive.
   * @param endTimeMillis endTimeMillis or {@code null} for none
   */
  public Session setEndTimeMillis(java.lang.Long endTimeMillis) {
    this.endTimeMillis = endTimeMillis;
    return this;
  }

  /**
   * A client-generated identifier that is unique across all sessions owned by this particular user.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * A client-generated identifier that is unique across all sessions owned by this particular user.
   * @param id id or {@code null} for none
   */
  public Session setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * A timestamp that indicates when the session was last modified.
   * @return value or {@code null} for none
   */
  public java.lang.Long getModifiedTimeMillis() {
    return modifiedTimeMillis;
  }

  /**
   * A timestamp that indicates when the session was last modified.
   * @param modifiedTimeMillis modifiedTimeMillis or {@code null} for none
   */
  public Session setModifiedTimeMillis(java.lang.Long modifiedTimeMillis) {
    this.modifiedTimeMillis = modifiedTimeMillis;
    return this;
  }

  /**
   * A human readable name of the session.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * A human readable name of the session.
   * @param name name or {@code null} for none
   */
  public Session setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * A start time, in milliseconds since epoch, inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Long getStartTimeMillis() {
    return startTimeMillis;
  }

  /**
   * A start time, in milliseconds since epoch, inclusive.
   * @param startTimeMillis startTimeMillis or {@code null} for none
   */
  public Session setStartTimeMillis(java.lang.Long startTimeMillis) {
    this.startTimeMillis = startTimeMillis;
    return this;
  }

  @Override
  public Session set(String fieldName, Object value) {
    return (Session) super.set(fieldName, value);
  }

  @Override
  public Session clone() {
    return (Session) super.clone();
  }

}
