/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2013-06-26 16:27:34 UTC)
 * on 2013-07-17 at 01:31:44 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games;

/**
 * Service definition for Games (v1).
 *
 * <p>
 * The API for Google Play Game Services.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/games/services/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link GamesRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Games extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 14,
        "You are currently running with version %s of google-api-client. " +
        "You need version 1.14 of google-api-client to run version " +
        "1.14.2-beta of the Google Play Game Services API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "games/v1/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Games(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Games(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the AchievementDefinitions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Games games = new Games(...);}
   *   {@code Games.AchievementDefinitions.List request = games.achievementDefinitions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public AchievementDefinitions achievementDefinitions() {
    return new AchievementDefinitions();
  }

  /**
   * The "achievementDefinitions" collection of methods.
   */
  public class AchievementDefinitions {

    /**
     * Lists all the achievement definitions for your application.
     *
     * Create a request for the method "achievementDefinitions.list".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends GamesRequest<com.google.api.services.games.model.AchievementDefinitionsListResponse> {

      private static final String REST_PATH = "achievements";

      /**
       * Lists all the achievement definitions for your application.
       *
       * Create a request for the method "achievementDefinitions.list".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Games.this, "GET", REST_PATH, null, com.google.api.services.games.model.AchievementDefinitionsListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The token returned by the previous request. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token returned by the previous request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** The token returned by the previous request. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The maximum number of achievement resources to return in the response, used for paging. For
       * any response, the actual number of achievement resources returned may be less than the
       * specified maxResults.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** The maximum number of achievement resources to return in the response, used for paging. For any
     response, the actual number of achievement resources returned may be less than the specified
     maxResults.

     [minimum: 1] [maximum: 200]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of achievement resources to return in the response, used for paging. For
       * any response, the actual number of achievement resources returned may be less than the
       * specified maxResults.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** The preferred language to use for strings returned by this method. */
      @com.google.api.client.util.Key
      private java.lang.String language;

      /** The preferred language to use for strings returned by this method.
       */
      public java.lang.String getLanguage() {
        return language;
      }

      /** The preferred language to use for strings returned by this method. */
      public List setLanguage(java.lang.String language) {
        this.language = language;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Achievements collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Games games = new Games(...);}
   *   {@code Games.Achievements.List request = games.achievements().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Achievements achievements() {
    return new Achievements();
  }

  /**
   * The "achievements" collection of methods.
   */
  public class Achievements {

    /**
     * Increments the steps of the achievement with the given ID for the currently authenticated player.
     *
     * Create a request for the method "achievements.increment".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link Increment#execute()} method to invoke the remote operation.
     *
     * @param achievementId The ID of the achievement used by this method.
     * @param stepsToIncrement The number of steps to increment.
    [minimum: 1]
     * @return the request
     */
    public Increment increment(java.lang.String achievementId, java.lang.Integer stepsToIncrement) throws java.io.IOException {
      Increment result = new Increment(achievementId, stepsToIncrement);
      initialize(result);
      return result;
    }

    public class Increment extends GamesRequest<com.google.api.services.games.model.AchievementIncrementResponse> {

      private static final String REST_PATH = "achievements/{achievementId}/increment";

      /**
       * Increments the steps of the achievement with the given ID for the currently authenticated
       * player.
       *
       * Create a request for the method "achievements.increment".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link Increment#execute()} method to invoke the remote operation. <p>
       * {@link
       * Increment#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param achievementId The ID of the achievement used by this method.
       * @param stepsToIncrement The number of steps to increment.
    [minimum: 1]
       * @since 1.13
       */
      protected Increment(java.lang.String achievementId, java.lang.Integer stepsToIncrement) {
        super(Games.this, "POST", REST_PATH, null, com.google.api.services.games.model.AchievementIncrementResponse.class);
        this.achievementId = com.google.api.client.util.Preconditions.checkNotNull(achievementId, "Required parameter achievementId must be specified.");
        this.stepsToIncrement = com.google.api.client.util.Preconditions.checkNotNull(stepsToIncrement, "Required parameter stepsToIncrement must be specified.");
      }

      @Override
      public Increment setAlt(java.lang.String alt) {
        return (Increment) super.setAlt(alt);
      }

      @Override
      public Increment setFields(java.lang.String fields) {
        return (Increment) super.setFields(fields);
      }

      @Override
      public Increment setKey(java.lang.String key) {
        return (Increment) super.setKey(key);
      }

      @Override
      public Increment setOauthToken(java.lang.String oauthToken) {
        return (Increment) super.setOauthToken(oauthToken);
      }

      @Override
      public Increment setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Increment) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Increment setQuotaUser(java.lang.String quotaUser) {
        return (Increment) super.setQuotaUser(quotaUser);
      }

      @Override
      public Increment setUserIp(java.lang.String userIp) {
        return (Increment) super.setUserIp(userIp);
      }

      /** The ID of the achievement used by this method. */
      @com.google.api.client.util.Key
      private java.lang.String achievementId;

      /** The ID of the achievement used by this method.
       */
      public java.lang.String getAchievementId() {
        return achievementId;
      }

      /** The ID of the achievement used by this method. */
      public Increment setAchievementId(java.lang.String achievementId) {
        this.achievementId = achievementId;
        return this;
      }

      /** The number of steps to increment. */
      @com.google.api.client.util.Key
      private java.lang.Integer stepsToIncrement;

      /** The number of steps to increment.

     [minimum: 1]
       */
      public java.lang.Integer getStepsToIncrement() {
        return stepsToIncrement;
      }

      /** The number of steps to increment. */
      public Increment setStepsToIncrement(java.lang.Integer stepsToIncrement) {
        this.stepsToIncrement = stepsToIncrement;
        return this;
      }

      /**
       * A randomly generated numeric ID for each request specified by the caller. This number is
       * used at the server to ensure that the increment is performed correctly across retries.
       */
      @com.google.api.client.util.Key
      private java.lang.Long requestId;

      /** A randomly generated numeric ID for each request specified by the caller. This number is used at
     the server to ensure that the increment is performed correctly across retries.
       */
      public java.lang.Long getRequestId() {
        return requestId;
      }

      /**
       * A randomly generated numeric ID for each request specified by the caller. This number is
       * used at the server to ensure that the increment is performed correctly across retries.
       */
      public Increment setRequestId(java.lang.Long requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Increment set(String parameterName, Object value) {
        return (Increment) super.set(parameterName, value);
      }
    }
    /**
     * Lists the progress for all your application's achievements for the currently authenticated
     * player.
     *
     * Create a request for the method "achievements.list".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param playerId A player ID. A value of me may be used in place of the authenticated player's ID.
     * @return the request
     */
    public List list(java.lang.String playerId) throws java.io.IOException {
      List result = new List(playerId);
      initialize(result);
      return result;
    }

    public class List extends GamesRequest<com.google.api.services.games.model.PlayerAchievementListResponse> {

      private static final String REST_PATH = "players/{playerId}/achievements";

      /**
       * Lists the progress for all your application's achievements for the currently authenticated
       * player.
       *
       * Create a request for the method "achievements.list".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param playerId A player ID. A value of me may be used in place of the authenticated player's ID.
       * @since 1.13
       */
      protected List(java.lang.String playerId) {
        super(Games.this, "GET", REST_PATH, null, com.google.api.services.games.model.PlayerAchievementListResponse.class);
        this.playerId = com.google.api.client.util.Preconditions.checkNotNull(playerId, "Required parameter playerId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** A player ID. A value of me may be used in place of the authenticated player's ID. */
      @com.google.api.client.util.Key
      private java.lang.String playerId;

      /** A player ID. A value of me may be used in place of the authenticated player's ID.
       */
      public java.lang.String getPlayerId() {
        return playerId;
      }

      /** A player ID. A value of me may be used in place of the authenticated player's ID. */
      public List setPlayerId(java.lang.String playerId) {
        this.playerId = playerId;
        return this;
      }

      /** The token returned by the previous request. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token returned by the previous request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** The token returned by the previous request. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Tells the server to return only achievements with the specified state. If this parameter
       * isn't specified, all achievements are returned.
       */
      @com.google.api.client.util.Key
      private java.lang.String state;

      /** Tells the server to return only achievements with the specified state. If this parameter isn't
     specified, all achievements are returned.
       */
      public java.lang.String getState() {
        return state;
      }

      /**
       * Tells the server to return only achievements with the specified state. If this parameter
       * isn't specified, all achievements are returned.
       */
      public List setState(java.lang.String state) {
        this.state = state;
        return this;
      }

      /**
       * The maximum number of achievement resources to return in the response, used for paging. For
       * any response, the actual number of achievement resources returned may be less than the
       * specified maxResults.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** The maximum number of achievement resources to return in the response, used for paging. For any
     response, the actual number of achievement resources returned may be less than the specified
     maxResults.

     [minimum: 1] [maximum: 200]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of achievement resources to return in the response, used for paging. For
       * any response, the actual number of achievement resources returned may be less than the
       * specified maxResults.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** The preferred language to use for strings returned by this method. */
      @com.google.api.client.util.Key
      private java.lang.String language;

      /** The preferred language to use for strings returned by this method.
       */
      public java.lang.String getLanguage() {
        return language;
      }

      /** The preferred language to use for strings returned by this method. */
      public List setLanguage(java.lang.String language) {
        this.language = language;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Sets the state of the achievement with the given ID to REVEALED for the currently authenticated
     * player.
     *
     * Create a request for the method "achievements.reveal".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link Reveal#execute()} method to invoke the remote operation.
     *
     * @param achievementId The ID of the achievement used by this method.
     * @return the request
     */
    public Reveal reveal(java.lang.String achievementId) throws java.io.IOException {
      Reveal result = new Reveal(achievementId);
      initialize(result);
      return result;
    }

    public class Reveal extends GamesRequest<com.google.api.services.games.model.AchievementRevealResponse> {

      private static final String REST_PATH = "achievements/{achievementId}/reveal";

      /**
       * Sets the state of the achievement with the given ID to REVEALED for the currently authenticated
       * player.
       *
       * Create a request for the method "achievements.reveal".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link Reveal#execute()} method to invoke the remote operation. <p> {@link
       * Reveal#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param achievementId The ID of the achievement used by this method.
       * @since 1.13
       */
      protected Reveal(java.lang.String achievementId) {
        super(Games.this, "POST", REST_PATH, null, com.google.api.services.games.model.AchievementRevealResponse.class);
        this.achievementId = com.google.api.client.util.Preconditions.checkNotNull(achievementId, "Required parameter achievementId must be specified.");
      }

      @Override
      public Reveal setAlt(java.lang.String alt) {
        return (Reveal) super.setAlt(alt);
      }

      @Override
      public Reveal setFields(java.lang.String fields) {
        return (Reveal) super.setFields(fields);
      }

      @Override
      public Reveal setKey(java.lang.String key) {
        return (Reveal) super.setKey(key);
      }

      @Override
      public Reveal setOauthToken(java.lang.String oauthToken) {
        return (Reveal) super.setOauthToken(oauthToken);
      }

      @Override
      public Reveal setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Reveal) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Reveal setQuotaUser(java.lang.String quotaUser) {
        return (Reveal) super.setQuotaUser(quotaUser);
      }

      @Override
      public Reveal setUserIp(java.lang.String userIp) {
        return (Reveal) super.setUserIp(userIp);
      }

      /** The ID of the achievement used by this method. */
      @com.google.api.client.util.Key
      private java.lang.String achievementId;

      /** The ID of the achievement used by this method.
       */
      public java.lang.String getAchievementId() {
        return achievementId;
      }

      /** The ID of the achievement used by this method. */
      public Reveal setAchievementId(java.lang.String achievementId) {
        this.achievementId = achievementId;
        return this;
      }

      @Override
      public Reveal set(String parameterName, Object value) {
        return (Reveal) super.set(parameterName, value);
      }
    }
    /**
     * Unlocks this achievement for the currently authenticated player.
     *
     * Create a request for the method "achievements.unlock".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link Unlock#execute()} method to invoke the remote operation.
     *
     * @param achievementId The ID of the achievement used by this method.
     * @return the request
     */
    public Unlock unlock(java.lang.String achievementId) throws java.io.IOException {
      Unlock result = new Unlock(achievementId);
      initialize(result);
      return result;
    }

    public class Unlock extends GamesRequest<com.google.api.services.games.model.AchievementUnlockResponse> {

      private static final String REST_PATH = "achievements/{achievementId}/unlock";

      /**
       * Unlocks this achievement for the currently authenticated player.
       *
       * Create a request for the method "achievements.unlock".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link Unlock#execute()} method to invoke the remote operation. <p> {@link
       * Unlock#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param achievementId The ID of the achievement used by this method.
       * @since 1.13
       */
      protected Unlock(java.lang.String achievementId) {
        super(Games.this, "POST", REST_PATH, null, com.google.api.services.games.model.AchievementUnlockResponse.class);
        this.achievementId = com.google.api.client.util.Preconditions.checkNotNull(achievementId, "Required parameter achievementId must be specified.");
      }

      @Override
      public Unlock setAlt(java.lang.String alt) {
        return (Unlock) super.setAlt(alt);
      }

      @Override
      public Unlock setFields(java.lang.String fields) {
        return (Unlock) super.setFields(fields);
      }

      @Override
      public Unlock setKey(java.lang.String key) {
        return (Unlock) super.setKey(key);
      }

      @Override
      public Unlock setOauthToken(java.lang.String oauthToken) {
        return (Unlock) super.setOauthToken(oauthToken);
      }

      @Override
      public Unlock setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Unlock) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Unlock setQuotaUser(java.lang.String quotaUser) {
        return (Unlock) super.setQuotaUser(quotaUser);
      }

      @Override
      public Unlock setUserIp(java.lang.String userIp) {
        return (Unlock) super.setUserIp(userIp);
      }

      /** The ID of the achievement used by this method. */
      @com.google.api.client.util.Key
      private java.lang.String achievementId;

      /** The ID of the achievement used by this method.
       */
      public java.lang.String getAchievementId() {
        return achievementId;
      }

      /** The ID of the achievement used by this method. */
      public Unlock setAchievementId(java.lang.String achievementId) {
        this.achievementId = achievementId;
        return this;
      }

      @Override
      public Unlock set(String parameterName, Object value) {
        return (Unlock) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Applications collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Games games = new Games(...);}
   *   {@code Games.Applications.List request = games.applications().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Applications applications() {
    return new Applications();
  }

  /**
   * The "applications" collection of methods.
   */
  public class Applications {

    /**
     * Retrieves the metadata of the application with the given ID. If the requested application is not
     * available for the specified platformType, the returned response will not include any instance
     * data.
     *
     * Create a request for the method "applications.get".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param applicationId The application being requested.
     * @return the request
     */
    public Get get(java.lang.String applicationId) throws java.io.IOException {
      Get result = new Get(applicationId);
      initialize(result);
      return result;
    }

    public class Get extends GamesRequest<com.google.api.services.games.model.Application> {

      private static final String REST_PATH = "applications/{applicationId}";

      /**
       * Retrieves the metadata of the application with the given ID. If the requested application is
       * not available for the specified platformType, the returned response will not include any
       * instance data.
       *
       * Create a request for the method "applications.get".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param applicationId The application being requested.
       * @since 1.13
       */
      protected Get(java.lang.String applicationId) {
        super(Games.this, "GET", REST_PATH, null, com.google.api.services.games.model.Application.class);
        this.applicationId = com.google.api.client.util.Preconditions.checkNotNull(applicationId, "Required parameter applicationId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The application being requested. */
      @com.google.api.client.util.Key
      private java.lang.String applicationId;

      /** The application being requested.
       */
      public java.lang.String getApplicationId() {
        return applicationId;
      }

      /** The application being requested. */
      public Get setApplicationId(java.lang.String applicationId) {
        this.applicationId = applicationId;
        return this;
      }

      /** Restrict application details returned to the specific platform. */
      @com.google.api.client.util.Key
      private java.lang.String platformType;

      /** Restrict application details returned to the specific platform.
       */
      public java.lang.String getPlatformType() {
        return platformType;
      }

      /** Restrict application details returned to the specific platform. */
      public Get setPlatformType(java.lang.String platformType) {
        this.platformType = platformType;
        return this;
      }

      /** The preferred language to use for strings returned by this method. */
      @com.google.api.client.util.Key
      private java.lang.String language;

      /** The preferred language to use for strings returned by this method.
       */
      public java.lang.String getLanguage() {
        return language;
      }

      /** The preferred language to use for strings returned by this method. */
      public Get setLanguage(java.lang.String language) {
        this.language = language;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Indicate that the the currently authenticated user is playing your application.
     *
     * Create a request for the method "applications.played".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link Played#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public Played played() throws java.io.IOException {
      Played result = new Played();
      initialize(result);
      return result;
    }

    public class Played extends GamesRequest<Void> {

      private static final String REST_PATH = "applications/played";

      /**
       * Indicate that the the currently authenticated user is playing your application.
       *
       * Create a request for the method "applications.played".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link Played#execute()} method to invoke the remote operation. <p> {@link
       * Played#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected Played() {
        super(Games.this, "POST", REST_PATH, null, Void.class);
      }

      @Override
      public Played setAlt(java.lang.String alt) {
        return (Played) super.setAlt(alt);
      }

      @Override
      public Played setFields(java.lang.String fields) {
        return (Played) super.setFields(fields);
      }

      @Override
      public Played setKey(java.lang.String key) {
        return (Played) super.setKey(key);
      }

      @Override
      public Played setOauthToken(java.lang.String oauthToken) {
        return (Played) super.setOauthToken(oauthToken);
      }

      @Override
      public Played setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Played) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Played setQuotaUser(java.lang.String quotaUser) {
        return (Played) super.setQuotaUser(quotaUser);
      }

      @Override
      public Played setUserIp(java.lang.String userIp) {
        return (Played) super.setUserIp(userIp);
      }

      @Override
      public Played set(String parameterName, Object value) {
        return (Played) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Leaderboards collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Games games = new Games(...);}
   *   {@code Games.Leaderboards.List request = games.leaderboards().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Leaderboards leaderboards() {
    return new Leaderboards();
  }

  /**
   * The "leaderboards" collection of methods.
   */
  public class Leaderboards {

    /**
     * Retrieves the metadata of the leaderboard with the given ID.
     *
     * Create a request for the method "leaderboards.get".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param leaderboardId The ID of the leaderboard.
     * @return the request
     */
    public Get get(java.lang.String leaderboardId) throws java.io.IOException {
      Get result = new Get(leaderboardId);
      initialize(result);
      return result;
    }

    public class Get extends GamesRequest<com.google.api.services.games.model.Leaderboard> {

      private static final String REST_PATH = "leaderboards/{leaderboardId}";

      /**
       * Retrieves the metadata of the leaderboard with the given ID.
       *
       * Create a request for the method "leaderboards.get".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param leaderboardId The ID of the leaderboard.
       * @since 1.13
       */
      protected Get(java.lang.String leaderboardId) {
        super(Games.this, "GET", REST_PATH, null, com.google.api.services.games.model.Leaderboard.class);
        this.leaderboardId = com.google.api.client.util.Preconditions.checkNotNull(leaderboardId, "Required parameter leaderboardId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the leaderboard. */
      @com.google.api.client.util.Key
      private java.lang.String leaderboardId;

      /** The ID of the leaderboard.
       */
      public java.lang.String getLeaderboardId() {
        return leaderboardId;
      }

      /** The ID of the leaderboard. */
      public Get setLeaderboardId(java.lang.String leaderboardId) {
        this.leaderboardId = leaderboardId;
        return this;
      }

      /** The preferred language to use for strings returned by this method. */
      @com.google.api.client.util.Key
      private java.lang.String language;

      /** The preferred language to use for strings returned by this method.
       */
      public java.lang.String getLanguage() {
        return language;
      }

      /** The preferred language to use for strings returned by this method. */
      public Get setLanguage(java.lang.String language) {
        this.language = language;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists all the leaderboard metadata for your application.
     *
     * Create a request for the method "leaderboards.list".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends GamesRequest<com.google.api.services.games.model.LeaderboardListResponse> {

      private static final String REST_PATH = "leaderboards";

      /**
       * Lists all the leaderboard metadata for your application.
       *
       * Create a request for the method "leaderboards.list".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Games.this, "GET", REST_PATH, null, com.google.api.services.games.model.LeaderboardListResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The token returned by the previous request. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token returned by the previous request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** The token returned by the previous request. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The maximum number of leaderboards to return in the response. For any response, the actual
       * number of leaderboards returned may be less than the specified maxResults.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** The maximum number of leaderboards to return in the response. For any response, the actual number
     of leaderboards returned may be less than the specified maxResults.

     [minimum: 1] [maximum: 100]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of leaderboards to return in the response. For any response, the actual
       * number of leaderboards returned may be less than the specified maxResults.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** The preferred language to use for strings returned by this method. */
      @com.google.api.client.util.Key
      private java.lang.String language;

      /** The preferred language to use for strings returned by this method.
       */
      public java.lang.String getLanguage() {
        return language;
      }

      /** The preferred language to use for strings returned by this method. */
      public List setLanguage(java.lang.String language) {
        this.language = language;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Players collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Games games = new Games(...);}
   *   {@code Games.Players.List request = games.players().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Players players() {
    return new Players();
  }

  /**
   * The "players" collection of methods.
   */
  public class Players {

    /**
     * Retrieves the Player resource with the given ID. To retrieve the player for the currently
     * authenticated user, set playerId to me.
     *
     * Create a request for the method "players.get".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param playerId A player ID. A value of me may be used in place of the authenticated player's ID.
     * @return the request
     */
    public Get get(java.lang.String playerId) throws java.io.IOException {
      Get result = new Get(playerId);
      initialize(result);
      return result;
    }

    public class Get extends GamesRequest<com.google.api.services.games.model.Player> {

      private static final String REST_PATH = "players/{playerId}";

      /**
       * Retrieves the Player resource with the given ID. To retrieve the player for the currently
       * authenticated user, set playerId to me.
       *
       * Create a request for the method "players.get".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param playerId A player ID. A value of me may be used in place of the authenticated player's ID.
       * @since 1.13
       */
      protected Get(java.lang.String playerId) {
        super(Games.this, "GET", REST_PATH, null, com.google.api.services.games.model.Player.class);
        this.playerId = com.google.api.client.util.Preconditions.checkNotNull(playerId, "Required parameter playerId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** A player ID. A value of me may be used in place of the authenticated player's ID. */
      @com.google.api.client.util.Key
      private java.lang.String playerId;

      /** A player ID. A value of me may be used in place of the authenticated player's ID.
       */
      public java.lang.String getPlayerId() {
        return playerId;
      }

      /** A player ID. A value of me may be used in place of the authenticated player's ID. */
      public Get setPlayerId(java.lang.String playerId) {
        this.playerId = playerId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Revisions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Games games = new Games(...);}
   *   {@code Games.Revisions.List request = games.revisions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Revisions revisions() {
    return new Revisions();
  }

  /**
   * The "revisions" collection of methods.
   */
  public class Revisions {

    /**
     * Checks whether the games client is out of date.
     *
     * Create a request for the method "revisions.check".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link Check#execute()} method to invoke the remote operation.
     *
     * @param clientRevision The revision of the client SDK used by your application.
     * @return the request
     */
    public Check check(java.lang.String clientRevision) throws java.io.IOException {
      Check result = new Check(clientRevision);
      initialize(result);
      return result;
    }

    public class Check extends GamesRequest<com.google.api.services.games.model.RevisionCheckResponse> {

      private static final String REST_PATH = "revisions/check";

      /**
       * Checks whether the games client is out of date.
       *
       * Create a request for the method "revisions.check".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link Check#execute()} method to invoke the remote operation. <p> {@link
       * Check#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param clientRevision The revision of the client SDK used by your application.
       * @since 1.13
       */
      protected Check(java.lang.String clientRevision) {
        super(Games.this, "GET", REST_PATH, null, com.google.api.services.games.model.RevisionCheckResponse.class);
        this.clientRevision = com.google.api.client.util.Preconditions.checkNotNull(clientRevision, "Required parameter clientRevision must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Check setAlt(java.lang.String alt) {
        return (Check) super.setAlt(alt);
      }

      @Override
      public Check setFields(java.lang.String fields) {
        return (Check) super.setFields(fields);
      }

      @Override
      public Check setKey(java.lang.String key) {
        return (Check) super.setKey(key);
      }

      @Override
      public Check setOauthToken(java.lang.String oauthToken) {
        return (Check) super.setOauthToken(oauthToken);
      }

      @Override
      public Check setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Check) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Check setQuotaUser(java.lang.String quotaUser) {
        return (Check) super.setQuotaUser(quotaUser);
      }

      @Override
      public Check setUserIp(java.lang.String userIp) {
        return (Check) super.setUserIp(userIp);
      }

      /** The revision of the client SDK used by your application. */
      @com.google.api.client.util.Key
      private java.lang.String clientRevision;

      /** The revision of the client SDK used by your application.
       */
      public java.lang.String getClientRevision() {
        return clientRevision;
      }

      /** The revision of the client SDK used by your application. */
      public Check setClientRevision(java.lang.String clientRevision) {
        this.clientRevision = clientRevision;
        return this;
      }

      @Override
      public Check set(String parameterName, Object value) {
        return (Check) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Rooms collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Games games = new Games(...);}
   *   {@code Games.Rooms.List request = games.rooms().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Rooms rooms() {
    return new Rooms();
  }

  /**
   * The "rooms" collection of methods.
   */
  public class Rooms {

    /**
     * Create a room. For internal use by the Games SDK only. Calling this method directly is
     * unsupported.
     *
     * Create a request for the method "rooms.create".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.games.model.RoomCreateRequest}
     * @return the request
     */
    public Create create(com.google.api.services.games.model.RoomCreateRequest content) throws java.io.IOException {
      Create result = new Create(content);
      initialize(result);
      return result;
    }

    public class Create extends GamesRequest<com.google.api.services.games.model.Room> {

      private static final String REST_PATH = "rooms/create";

      /**
       * Create a room. For internal use by the Games SDK only. Calling this method directly is
       * unsupported.
       *
       * Create a request for the method "rooms.create".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.games.model.RoomCreateRequest}
       * @since 1.13
       */
      protected Create(com.google.api.services.games.model.RoomCreateRequest content) {
        super(Games.this, "POST", REST_PATH, content, com.google.api.services.games.model.Room.class);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUserIp(java.lang.String userIp) {
        return (Create) super.setUserIp(userIp);
      }

      /** The preferred language to use for strings returned by this method. */
      @com.google.api.client.util.Key
      private java.lang.String language;

      /** The preferred language to use for strings returned by this method.
       */
      public java.lang.String getLanguage() {
        return language;
      }

      /** The preferred language to use for strings returned by this method. */
      public Create setLanguage(java.lang.String language) {
        this.language = language;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Decline an invitation to join a room. For internal use by the Games SDK only. Calling this method
     * directly is unsupported.
     *
     * Create a request for the method "rooms.decline".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link Decline#execute()} method to invoke the remote operation.
     *
     * @param roomId The ID of the room.
     * @return the request
     */
    public Decline decline(java.lang.String roomId) throws java.io.IOException {
      Decline result = new Decline(roomId);
      initialize(result);
      return result;
    }

    public class Decline extends GamesRequest<com.google.api.services.games.model.Room> {

      private static final String REST_PATH = "rooms/{roomId}/decline";

      /**
       * Decline an invitation to join a room. For internal use by the Games SDK only. Calling this
       * method directly is unsupported.
       *
       * Create a request for the method "rooms.decline".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link Decline#execute()} method to invoke the remote operation. <p>
       * {@link
       * Decline#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param roomId The ID of the room.
       * @since 1.13
       */
      protected Decline(java.lang.String roomId) {
        super(Games.this, "POST", REST_PATH, null, com.google.api.services.games.model.Room.class);
        this.roomId = com.google.api.client.util.Preconditions.checkNotNull(roomId, "Required parameter roomId must be specified.");
      }

      @Override
      public Decline setAlt(java.lang.String alt) {
        return (Decline) super.setAlt(alt);
      }

      @Override
      public Decline setFields(java.lang.String fields) {
        return (Decline) super.setFields(fields);
      }

      @Override
      public Decline setKey(java.lang.String key) {
        return (Decline) super.setKey(key);
      }

      @Override
      public Decline setOauthToken(java.lang.String oauthToken) {
        return (Decline) super.setOauthToken(oauthToken);
      }

      @Override
      public Decline setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Decline) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Decline setQuotaUser(java.lang.String quotaUser) {
        return (Decline) super.setQuotaUser(quotaUser);
      }

      @Override
      public Decline setUserIp(java.lang.String userIp) {
        return (Decline) super.setUserIp(userIp);
      }

      /** The ID of the room. */
      @com.google.api.client.util.Key
      private java.lang.String roomId;

      /** The ID of the room.
       */
      public java.lang.String getRoomId() {
        return roomId;
      }

      /** The ID of the room. */
      public Decline setRoomId(java.lang.String roomId) {
        this.roomId = roomId;
        return this;
      }

      @Override
      public Decline set(String parameterName, Object value) {
        return (Decline) super.set(parameterName, value);
      }
    }
    /**
     * Dismiss an invitation to join a room. For internal use by the Games SDK only. Calling this method
     * directly is unsupported.
     *
     * Create a request for the method "rooms.dismiss".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link Dismiss#execute()} method to invoke the remote operation.
     *
     * @param roomId The ID of the room.
     * @return the request
     */
    public Dismiss dismiss(java.lang.String roomId) throws java.io.IOException {
      Dismiss result = new Dismiss(roomId);
      initialize(result);
      return result;
    }

    public class Dismiss extends GamesRequest<Void> {

      private static final String REST_PATH = "rooms/{roomId}/dismiss";

      /**
       * Dismiss an invitation to join a room. For internal use by the Games SDK only. Calling this
       * method directly is unsupported.
       *
       * Create a request for the method "rooms.dismiss".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link Dismiss#execute()} method to invoke the remote operation. <p>
       * {@link
       * Dismiss#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param roomId The ID of the room.
       * @since 1.13
       */
      protected Dismiss(java.lang.String roomId) {
        super(Games.this, "POST", REST_PATH, null, Void.class);
        this.roomId = com.google.api.client.util.Preconditions.checkNotNull(roomId, "Required parameter roomId must be specified.");
      }

      @Override
      public Dismiss setAlt(java.lang.String alt) {
        return (Dismiss) super.setAlt(alt);
      }

      @Override
      public Dismiss setFields(java.lang.String fields) {
        return (Dismiss) super.setFields(fields);
      }

      @Override
      public Dismiss setKey(java.lang.String key) {
        return (Dismiss) super.setKey(key);
      }

      @Override
      public Dismiss setOauthToken(java.lang.String oauthToken) {
        return (Dismiss) super.setOauthToken(oauthToken);
      }

      @Override
      public Dismiss setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Dismiss) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Dismiss setQuotaUser(java.lang.String quotaUser) {
        return (Dismiss) super.setQuotaUser(quotaUser);
      }

      @Override
      public Dismiss setUserIp(java.lang.String userIp) {
        return (Dismiss) super.setUserIp(userIp);
      }

      /** The ID of the room. */
      @com.google.api.client.util.Key
      private java.lang.String roomId;

      /** The ID of the room.
       */
      public java.lang.String getRoomId() {
        return roomId;
      }

      /** The ID of the room. */
      public Dismiss setRoomId(java.lang.String roomId) {
        this.roomId = roomId;
        return this;
      }

      @Override
      public Dismiss set(String parameterName, Object value) {
        return (Dismiss) super.set(parameterName, value);
      }
    }
    /**
     * Get the data for a room.
     *
     * Create a request for the method "rooms.get".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param roomId The ID of the room.
     * @return the request
     */
    public Get get(java.lang.String roomId) throws java.io.IOException {
      Get result = new Get(roomId);
      initialize(result);
      return result;
    }

    public class Get extends GamesRequest<com.google.api.services.games.model.Room> {

      private static final String REST_PATH = "rooms/{roomId}";

      /**
       * Get the data for a room.
       *
       * Create a request for the method "rooms.get".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param roomId The ID of the room.
       * @since 1.13
       */
      protected Get(java.lang.String roomId) {
        super(Games.this, "GET", REST_PATH, null, com.google.api.services.games.model.Room.class);
        this.roomId = com.google.api.client.util.Preconditions.checkNotNull(roomId, "Required parameter roomId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the room. */
      @com.google.api.client.util.Key
      private java.lang.String roomId;

      /** The ID of the room.
       */
      public java.lang.String getRoomId() {
        return roomId;
      }

      /** The ID of the room. */
      public Get setRoomId(java.lang.String roomId) {
        this.roomId = roomId;
        return this;
      }

      /** Specify the preferred language to use to format room info. */
      @com.google.api.client.util.Key
      private java.lang.String language;

      /** Specify the preferred language to use to format room info.
       */
      public java.lang.String getLanguage() {
        return language;
      }

      /** Specify the preferred language to use to format room info. */
      public Get setLanguage(java.lang.String language) {
        this.language = language;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Join a room. For internal use by the Games SDK only. Calling this method directly is unsupported.
     *
     * Create a request for the method "rooms.join".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link Join#execute()} method to invoke the remote operation.
     *
     * @param roomId The ID of the room.
     * @param content the {@link com.google.api.services.games.model.RoomJoinRequest}
     * @return the request
     */
    public Join join(java.lang.String roomId, com.google.api.services.games.model.RoomJoinRequest content) throws java.io.IOException {
      Join result = new Join(roomId, content);
      initialize(result);
      return result;
    }

    public class Join extends GamesRequest<com.google.api.services.games.model.Room> {

      private static final String REST_PATH = "rooms/{roomId}/join";

      /**
       * Join a room. For internal use by the Games SDK only. Calling this method directly is
       * unsupported.
       *
       * Create a request for the method "rooms.join".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link Join#execute()} method to invoke the remote operation. <p> {@link
       * Join#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param roomId The ID of the room.
       * @param content the {@link com.google.api.services.games.model.RoomJoinRequest}
       * @since 1.13
       */
      protected Join(java.lang.String roomId, com.google.api.services.games.model.RoomJoinRequest content) {
        super(Games.this, "POST", REST_PATH, content, com.google.api.services.games.model.Room.class);
        this.roomId = com.google.api.client.util.Preconditions.checkNotNull(roomId, "Required parameter roomId must be specified.");
      }

      @Override
      public Join setAlt(java.lang.String alt) {
        return (Join) super.setAlt(alt);
      }

      @Override
      public Join setFields(java.lang.String fields) {
        return (Join) super.setFields(fields);
      }

      @Override
      public Join setKey(java.lang.String key) {
        return (Join) super.setKey(key);
      }

      @Override
      public Join setOauthToken(java.lang.String oauthToken) {
        return (Join) super.setOauthToken(oauthToken);
      }

      @Override
      public Join setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Join) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Join setQuotaUser(java.lang.String quotaUser) {
        return (Join) super.setQuotaUser(quotaUser);
      }

      @Override
      public Join setUserIp(java.lang.String userIp) {
        return (Join) super.setUserIp(userIp);
      }

      /** The ID of the room. */
      @com.google.api.client.util.Key
      private java.lang.String roomId;

      /** The ID of the room.
       */
      public java.lang.String getRoomId() {
        return roomId;
      }

      /** The ID of the room. */
      public Join setRoomId(java.lang.String roomId) {
        this.roomId = roomId;
        return this;
      }

      @Override
      public Join set(String parameterName, Object value) {
        return (Join) super.set(parameterName, value);
      }
    }
    /**
     * Leave a room. For internal use by the Games SDK only. Calling this method directly is
     * unsupported.
     *
     * Create a request for the method "rooms.leave".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link Leave#execute()} method to invoke the remote operation.
     *
     * @param roomId The ID of the room.
     * @param content the {@link com.google.api.services.games.model.RoomLeaveRequest}
     * @return the request
     */
    public Leave leave(java.lang.String roomId, com.google.api.services.games.model.RoomLeaveRequest content) throws java.io.IOException {
      Leave result = new Leave(roomId, content);
      initialize(result);
      return result;
    }

    public class Leave extends GamesRequest<com.google.api.services.games.model.Room> {

      private static final String REST_PATH = "rooms/{roomId}/leave";

      /**
       * Leave a room. For internal use by the Games SDK only. Calling this method directly is
       * unsupported.
       *
       * Create a request for the method "rooms.leave".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link Leave#execute()} method to invoke the remote operation. <p> {@link
       * Leave#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param roomId The ID of the room.
       * @param content the {@link com.google.api.services.games.model.RoomLeaveRequest}
       * @since 1.13
       */
      protected Leave(java.lang.String roomId, com.google.api.services.games.model.RoomLeaveRequest content) {
        super(Games.this, "POST", REST_PATH, content, com.google.api.services.games.model.Room.class);
        this.roomId = com.google.api.client.util.Preconditions.checkNotNull(roomId, "Required parameter roomId must be specified.");
      }

      @Override
      public Leave setAlt(java.lang.String alt) {
        return (Leave) super.setAlt(alt);
      }

      @Override
      public Leave setFields(java.lang.String fields) {
        return (Leave) super.setFields(fields);
      }

      @Override
      public Leave setKey(java.lang.String key) {
        return (Leave) super.setKey(key);
      }

      @Override
      public Leave setOauthToken(java.lang.String oauthToken) {
        return (Leave) super.setOauthToken(oauthToken);
      }

      @Override
      public Leave setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Leave) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Leave setQuotaUser(java.lang.String quotaUser) {
        return (Leave) super.setQuotaUser(quotaUser);
      }

      @Override
      public Leave setUserIp(java.lang.String userIp) {
        return (Leave) super.setUserIp(userIp);
      }

      /** The ID of the room. */
      @com.google.api.client.util.Key
      private java.lang.String roomId;

      /** The ID of the room.
       */
      public java.lang.String getRoomId() {
        return roomId;
      }

      /** The ID of the room. */
      public Leave setRoomId(java.lang.String roomId) {
        this.roomId = roomId;
        return this;
      }

      @Override
      public Leave set(String parameterName, Object value) {
        return (Leave) super.set(parameterName, value);
      }
    }
    /**
     * Returns invitations to join rooms.
     *
     * Create a request for the method "rooms.list".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends GamesRequest<com.google.api.services.games.model.RoomList> {

      private static final String REST_PATH = "rooms";

      /**
       * Returns invitations to join rooms.
       *
       * Create a request for the method "rooms.list".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Games.this, "GET", REST_PATH, null, com.google.api.services.games.model.RoomList.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The token returned by the previous request. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token returned by the previous request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** The token returned by the previous request. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The maximum number of rooms to return in the response, used for paging. For any response,
       * the actual number of rooms to return may be less than the specified maxResults.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** The maximum number of rooms to return in the response, used for paging. For any response, the
     actual number of rooms to return may be less than the specified maxResults.

     [minimum: 1] [maximum: 500]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of rooms to return in the response, used for paging. For any response,
       * the actual number of rooms to return may be less than the specified maxResults.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** The preferred language to use for strings returned by this method. */
      @com.google.api.client.util.Key
      private java.lang.String language;

      /** The preferred language to use for strings returned by this method.
       */
      public java.lang.String getLanguage() {
        return language;
      }

      /** The preferred language to use for strings returned by this method. */
      public List setLanguage(java.lang.String language) {
        this.language = language;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates sent by a client reporting the status of peers in a room. For internal use by the Games
     * SDK only. Calling this method directly is unsupported.
     *
     * Create a request for the method "rooms.reportStatus".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link ReportStatus#execute()} method to invoke the remote operation.
     *
     * @param roomId The ID of the room.
     * @param content the {@link com.google.api.services.games.model.RoomP2PStatuses}
     * @return the request
     */
    public ReportStatus reportStatus(java.lang.String roomId, com.google.api.services.games.model.RoomP2PStatuses content) throws java.io.IOException {
      ReportStatus result = new ReportStatus(roomId, content);
      initialize(result);
      return result;
    }

    public class ReportStatus extends GamesRequest<com.google.api.services.games.model.RoomStatus> {

      private static final String REST_PATH = "rooms/{roomId}/reportstatus";

      /**
       * Updates sent by a client reporting the status of peers in a room. For internal use by the Games
       * SDK only. Calling this method directly is unsupported.
       *
       * Create a request for the method "rooms.reportStatus".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link ReportStatus#execute()} method to invoke the remote operation. <p>
       * {@link
       * ReportStatus#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param roomId The ID of the room.
       * @param content the {@link com.google.api.services.games.model.RoomP2PStatuses}
       * @since 1.13
       */
      protected ReportStatus(java.lang.String roomId, com.google.api.services.games.model.RoomP2PStatuses content) {
        super(Games.this, "POST", REST_PATH, content, com.google.api.services.games.model.RoomStatus.class);
        this.roomId = com.google.api.client.util.Preconditions.checkNotNull(roomId, "Required parameter roomId must be specified.");
      }

      @Override
      public ReportStatus setAlt(java.lang.String alt) {
        return (ReportStatus) super.setAlt(alt);
      }

      @Override
      public ReportStatus setFields(java.lang.String fields) {
        return (ReportStatus) super.setFields(fields);
      }

      @Override
      public ReportStatus setKey(java.lang.String key) {
        return (ReportStatus) super.setKey(key);
      }

      @Override
      public ReportStatus setOauthToken(java.lang.String oauthToken) {
        return (ReportStatus) super.setOauthToken(oauthToken);
      }

      @Override
      public ReportStatus setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ReportStatus) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ReportStatus setQuotaUser(java.lang.String quotaUser) {
        return (ReportStatus) super.setQuotaUser(quotaUser);
      }

      @Override
      public ReportStatus setUserIp(java.lang.String userIp) {
        return (ReportStatus) super.setUserIp(userIp);
      }

      /** The ID of the room. */
      @com.google.api.client.util.Key
      private java.lang.String roomId;

      /** The ID of the room.
       */
      public java.lang.String getRoomId() {
        return roomId;
      }

      /** The ID of the room. */
      public ReportStatus setRoomId(java.lang.String roomId) {
        this.roomId = roomId;
        return this;
      }

      @Override
      public ReportStatus set(String parameterName, Object value) {
        return (ReportStatus) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Scores collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Games games = new Games(...);}
   *   {@code Games.Scores.List request = games.scores().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Scores scores() {
    return new Scores();
  }

  /**
   * The "scores" collection of methods.
   */
  public class Scores {

    /**
     * Get high scores and optionally, ranks in leaderboards for the currently authenticated player. For
     * a specific time span, leaderboardId can be set to ALL to retrieve data for all leaderboards in a
     * given time span.
     *
     * Create a request for the method "scores.get".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param playerId A player ID. A value of me may be used in place of the authenticated player's ID.
     * @param leaderboardId The ID of the leaderboard.
     * @param timeSpan The time span for the scores and ranks you're requesting.
     * @return the request
     */
    public Get get(java.lang.String playerId, java.lang.String leaderboardId, java.lang.String timeSpan) throws java.io.IOException {
      Get result = new Get(playerId, leaderboardId, timeSpan);
      initialize(result);
      return result;
    }

    public class Get extends GamesRequest<com.google.api.services.games.model.PlayerLeaderboardScoreListResponse> {

      private static final String REST_PATH = "players/{playerId}/leaderboards/{leaderboardId}/scores/{timeSpan}";

      /**
       * Get high scores and optionally, ranks in leaderboards for the currently authenticated player.
       * For a specific time span, leaderboardId can be set to ALL to retrieve data for all leaderboards
       * in a given time span.
       *
       * Create a request for the method "scores.get".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param playerId A player ID. A value of me may be used in place of the authenticated player's ID.
       * @param leaderboardId The ID of the leaderboard.
       * @param timeSpan The time span for the scores and ranks you're requesting.
       * @since 1.13
       */
      protected Get(java.lang.String playerId, java.lang.String leaderboardId, java.lang.String timeSpan) {
        super(Games.this, "GET", REST_PATH, null, com.google.api.services.games.model.PlayerLeaderboardScoreListResponse.class);
        this.playerId = com.google.api.client.util.Preconditions.checkNotNull(playerId, "Required parameter playerId must be specified.");
        this.leaderboardId = com.google.api.client.util.Preconditions.checkNotNull(leaderboardId, "Required parameter leaderboardId must be specified.");
        this.timeSpan = com.google.api.client.util.Preconditions.checkNotNull(timeSpan, "Required parameter timeSpan must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** A player ID. A value of me may be used in place of the authenticated player's ID. */
      @com.google.api.client.util.Key
      private java.lang.String playerId;

      /** A player ID. A value of me may be used in place of the authenticated player's ID.
       */
      public java.lang.String getPlayerId() {
        return playerId;
      }

      /** A player ID. A value of me may be used in place of the authenticated player's ID. */
      public Get setPlayerId(java.lang.String playerId) {
        this.playerId = playerId;
        return this;
      }

      /** The ID of the leaderboard. */
      @com.google.api.client.util.Key
      private java.lang.String leaderboardId;

      /** The ID of the leaderboard.
       */
      public java.lang.String getLeaderboardId() {
        return leaderboardId;
      }

      /** The ID of the leaderboard. */
      public Get setLeaderboardId(java.lang.String leaderboardId) {
        this.leaderboardId = leaderboardId;
        return this;
      }

      /** The time span for the scores and ranks you're requesting. */
      @com.google.api.client.util.Key
      private java.lang.String timeSpan;

      /** The time span for the scores and ranks you're requesting.
       */
      public java.lang.String getTimeSpan() {
        return timeSpan;
      }

      /** The time span for the scores and ranks you're requesting. */
      public Get setTimeSpan(java.lang.String timeSpan) {
        this.timeSpan = timeSpan;
        return this;
      }

      /** The types of ranks to return. If the parameter is omitted, no ranks will be returned. */
      @com.google.api.client.util.Key
      private java.lang.String includeRankType;

      /** The types of ranks to return. If the parameter is omitted, no ranks will be returned.
       */
      public java.lang.String getIncludeRankType() {
        return includeRankType;
      }

      /** The types of ranks to return. If the parameter is omitted, no ranks will be returned. */
      public Get setIncludeRankType(java.lang.String includeRankType) {
        this.includeRankType = includeRankType;
        return this;
      }

      /** The preferred language to use for strings returned by this method. */
      @com.google.api.client.util.Key
      private java.lang.String language;

      /** The preferred language to use for strings returned by this method.
       */
      public java.lang.String getLanguage() {
        return language;
      }

      /** The preferred language to use for strings returned by this method. */
      public Get setLanguage(java.lang.String language) {
        this.language = language;
        return this;
      }

      /**
       * The maximum number of leaderboard scores to return in the response. For any response, the
       * actual number of leaderboard scores returned may be less than the specified maxResults.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** The maximum number of leaderboard scores to return in the response. For any response, the actual
     number of leaderboard scores returned may be less than the specified maxResults.

     [minimum: 1] [maximum: 25]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of leaderboard scores to return in the response. For any response, the
       * actual number of leaderboard scores returned may be less than the specified maxResults.
       */
      public Get setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** The token returned by the previous request. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token returned by the previous request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** The token returned by the previous request. */
      public Get setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists the scores in a leaderboard, starting from the top.
     *
     * Create a request for the method "scores.list".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param leaderboardId The ID of the leaderboard.
     * @param collection The collection of scores you're requesting.
     * @param timeSpan The time span for the scores and ranks you're requesting.
     * @return the request
     */
    public List list(java.lang.String leaderboardId, java.lang.String collection, java.lang.String timeSpan) throws java.io.IOException {
      List result = new List(leaderboardId, collection, timeSpan);
      initialize(result);
      return result;
    }

    public class List extends GamesRequest<com.google.api.services.games.model.LeaderboardScores> {

      private static final String REST_PATH = "leaderboards/{leaderboardId}/scores/{collection}";

      /**
       * Lists the scores in a leaderboard, starting from the top.
       *
       * Create a request for the method "scores.list".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param leaderboardId The ID of the leaderboard.
       * @param collection The collection of scores you're requesting.
       * @param timeSpan The time span for the scores and ranks you're requesting.
       * @since 1.13
       */
      protected List(java.lang.String leaderboardId, java.lang.String collection, java.lang.String timeSpan) {
        super(Games.this, "GET", REST_PATH, null, com.google.api.services.games.model.LeaderboardScores.class);
        this.leaderboardId = com.google.api.client.util.Preconditions.checkNotNull(leaderboardId, "Required parameter leaderboardId must be specified.");
        this.collection = com.google.api.client.util.Preconditions.checkNotNull(collection, "Required parameter collection must be specified.");
        this.timeSpan = com.google.api.client.util.Preconditions.checkNotNull(timeSpan, "Required parameter timeSpan must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The ID of the leaderboard. */
      @com.google.api.client.util.Key
      private java.lang.String leaderboardId;

      /** The ID of the leaderboard.
       */
      public java.lang.String getLeaderboardId() {
        return leaderboardId;
      }

      /** The ID of the leaderboard. */
      public List setLeaderboardId(java.lang.String leaderboardId) {
        this.leaderboardId = leaderboardId;
        return this;
      }

      /** The collection of scores you're requesting. */
      @com.google.api.client.util.Key
      private java.lang.String collection;

      /** The collection of scores you're requesting.
       */
      public java.lang.String getCollection() {
        return collection;
      }

      /** The collection of scores you're requesting. */
      public List setCollection(java.lang.String collection) {
        this.collection = collection;
        return this;
      }

      /** The time span for the scores and ranks you're requesting. */
      @com.google.api.client.util.Key
      private java.lang.String timeSpan;

      /** The time span for the scores and ranks you're requesting.
       */
      public java.lang.String getTimeSpan() {
        return timeSpan;
      }

      /** The time span for the scores and ranks you're requesting. */
      public List setTimeSpan(java.lang.String timeSpan) {
        this.timeSpan = timeSpan;
        return this;
      }

      /** The preferred language to use for strings returned by this method. */
      @com.google.api.client.util.Key
      private java.lang.String language;

      /** The preferred language to use for strings returned by this method.
       */
      public java.lang.String getLanguage() {
        return language;
      }

      /** The preferred language to use for strings returned by this method. */
      public List setLanguage(java.lang.String language) {
        this.language = language;
        return this;
      }

      /**
       * The maximum number of leaderboard scores to return in the response. For any response, the
       * actual number of leaderboard scores returned may be less than the specified maxResults.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** The maximum number of leaderboard scores to return in the response. For any response, the actual
     number of leaderboard scores returned may be less than the specified maxResults.

     [minimum: 1] [maximum: 25]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of leaderboard scores to return in the response. For any response, the
       * actual number of leaderboard scores returned may be less than the specified maxResults.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** The token returned by the previous request. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token returned by the previous request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** The token returned by the previous request. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Lists the scores in a leaderboard around (and including) a player's score.
     *
     * Create a request for the method "scores.listWindow".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link ListWindow#execute()} method to invoke the remote operation.
     *
     * @param leaderboardId The ID of the leaderboard.
     * @param collection The collection of scores you're requesting.
     * @param timeSpan The time span for the scores and ranks you're requesting.
     * @return the request
     */
    public ListWindow listWindow(java.lang.String leaderboardId, java.lang.String collection, java.lang.String timeSpan) throws java.io.IOException {
      ListWindow result = new ListWindow(leaderboardId, collection, timeSpan);
      initialize(result);
      return result;
    }

    public class ListWindow extends GamesRequest<com.google.api.services.games.model.LeaderboardScores> {

      private static final String REST_PATH = "leaderboards/{leaderboardId}/window/{collection}";

      /**
       * Lists the scores in a leaderboard around (and including) a player's score.
       *
       * Create a request for the method "scores.listWindow".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link ListWindow#execute()} method to invoke the remote operation. <p>
       * {@link
       * ListWindow#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param leaderboardId The ID of the leaderboard.
       * @param collection The collection of scores you're requesting.
       * @param timeSpan The time span for the scores and ranks you're requesting.
       * @since 1.13
       */
      protected ListWindow(java.lang.String leaderboardId, java.lang.String collection, java.lang.String timeSpan) {
        super(Games.this, "GET", REST_PATH, null, com.google.api.services.games.model.LeaderboardScores.class);
        this.leaderboardId = com.google.api.client.util.Preconditions.checkNotNull(leaderboardId, "Required parameter leaderboardId must be specified.");
        this.collection = com.google.api.client.util.Preconditions.checkNotNull(collection, "Required parameter collection must be specified.");
        this.timeSpan = com.google.api.client.util.Preconditions.checkNotNull(timeSpan, "Required parameter timeSpan must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public ListWindow setAlt(java.lang.String alt) {
        return (ListWindow) super.setAlt(alt);
      }

      @Override
      public ListWindow setFields(java.lang.String fields) {
        return (ListWindow) super.setFields(fields);
      }

      @Override
      public ListWindow setKey(java.lang.String key) {
        return (ListWindow) super.setKey(key);
      }

      @Override
      public ListWindow setOauthToken(java.lang.String oauthToken) {
        return (ListWindow) super.setOauthToken(oauthToken);
      }

      @Override
      public ListWindow setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ListWindow) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ListWindow setQuotaUser(java.lang.String quotaUser) {
        return (ListWindow) super.setQuotaUser(quotaUser);
      }

      @Override
      public ListWindow setUserIp(java.lang.String userIp) {
        return (ListWindow) super.setUserIp(userIp);
      }

      /** The ID of the leaderboard. */
      @com.google.api.client.util.Key
      private java.lang.String leaderboardId;

      /** The ID of the leaderboard.
       */
      public java.lang.String getLeaderboardId() {
        return leaderboardId;
      }

      /** The ID of the leaderboard. */
      public ListWindow setLeaderboardId(java.lang.String leaderboardId) {
        this.leaderboardId = leaderboardId;
        return this;
      }

      /** The collection of scores you're requesting. */
      @com.google.api.client.util.Key
      private java.lang.String collection;

      /** The collection of scores you're requesting.
       */
      public java.lang.String getCollection() {
        return collection;
      }

      /** The collection of scores you're requesting. */
      public ListWindow setCollection(java.lang.String collection) {
        this.collection = collection;
        return this;
      }

      /** The time span for the scores and ranks you're requesting. */
      @com.google.api.client.util.Key
      private java.lang.String timeSpan;

      /** The time span for the scores and ranks you're requesting.
       */
      public java.lang.String getTimeSpan() {
        return timeSpan;
      }

      /** The time span for the scores and ranks you're requesting. */
      public ListWindow setTimeSpan(java.lang.String timeSpan) {
        this.timeSpan = timeSpan;
        return this;
      }

      /** The preferred language to use for strings returned by this method. */
      @com.google.api.client.util.Key
      private java.lang.String language;

      /** The preferred language to use for strings returned by this method.
       */
      public java.lang.String getLanguage() {
        return language;
      }

      /** The preferred language to use for strings returned by this method. */
      public ListWindow setLanguage(java.lang.String language) {
        this.language = language;
        return this;
      }

      /**
       * True if the top scores should be returned when the player is not in the leaderboard.
       * Defaults to true.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnTopIfAbsent;

      /** True if the top scores should be returned when the player is not in the leaderboard. Defaults to
     true.
       */
      public java.lang.Boolean getReturnTopIfAbsent() {
        return returnTopIfAbsent;
      }

      /**
       * True if the top scores should be returned when the player is not in the leaderboard.
       * Defaults to true.
       */
      public ListWindow setReturnTopIfAbsent(java.lang.Boolean returnTopIfAbsent) {
        this.returnTopIfAbsent = returnTopIfAbsent;
        return this;
      }

      /**
       * The preferred number of scores to return above the player's score. More scores may be
       * returned if the player is at the bottom of the leaderboard; fewer may be returned if the
       * player is at the top. Must be less than or equal to maxResults.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer resultsAbove;

      /** The preferred number of scores to return above the player's score. More scores may be returned if
     the player is at the bottom of the leaderboard; fewer may be returned if the player is at the top.
     Must be less than or equal to maxResults.
       */
      public java.lang.Integer getResultsAbove() {
        return resultsAbove;
      }

      /**
       * The preferred number of scores to return above the player's score. More scores may be
       * returned if the player is at the bottom of the leaderboard; fewer may be returned if the
       * player is at the top. Must be less than or equal to maxResults.
       */
      public ListWindow setResultsAbove(java.lang.Integer resultsAbove) {
        this.resultsAbove = resultsAbove;
        return this;
      }

      /**
       * The maximum number of leaderboard scores to return in the response. For any response, the
       * actual number of leaderboard scores returned may be less than the specified maxResults.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** The maximum number of leaderboard scores to return in the response. For any response, the actual
     number of leaderboard scores returned may be less than the specified maxResults.

     [minimum: 1] [maximum: 25]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of leaderboard scores to return in the response. For any response, the
       * actual number of leaderboard scores returned may be less than the specified maxResults.
       */
      public ListWindow setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** The token returned by the previous request. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token returned by the previous request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** The token returned by the previous request. */
      public ListWindow setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public ListWindow set(String parameterName, Object value) {
        return (ListWindow) super.set(parameterName, value);
      }
    }
    /**
     * Submits a score to the specified leaderboard.
     *
     * Create a request for the method "scores.submit".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link Submit#execute()} method to invoke the remote operation.
     *
     * @param leaderboardId The ID of the leaderboard.
     * @param score The score you're submitting. The submitted score is ignored if it is worse than a previously
     *        submitted score, where worse depends on the leaderboard sort order. The meaning of the
     *        score value depends on the leaderboard format type. For fixed-point, the score represents
     *        the raw value. For time, the score represents elapsed time in milliseconds. For currency,
     *        the score represents a value in micro units.
     * @return the request
     */
    public Submit submit(java.lang.String leaderboardId, java.lang.Long score) throws java.io.IOException {
      Submit result = new Submit(leaderboardId, score);
      initialize(result);
      return result;
    }

    public class Submit extends GamesRequest<com.google.api.services.games.model.PlayerScoreResponse> {

      private static final String REST_PATH = "leaderboards/{leaderboardId}/scores";

      /**
       * Submits a score to the specified leaderboard.
       *
       * Create a request for the method "scores.submit".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link Submit#execute()} method to invoke the remote operation. <p> {@link
       * Submit#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param leaderboardId The ID of the leaderboard.
       * @param score The score you're submitting. The submitted score is ignored if it is worse than a previously
     *        submitted score, where worse depends on the leaderboard sort order. The meaning of the
     *        score value depends on the leaderboard format type. For fixed-point, the score represents
     *        the raw value. For time, the score represents elapsed time in milliseconds. For currency,
     *        the score represents a value in micro units.
       * @since 1.13
       */
      protected Submit(java.lang.String leaderboardId, java.lang.Long score) {
        super(Games.this, "POST", REST_PATH, null, com.google.api.services.games.model.PlayerScoreResponse.class);
        this.leaderboardId = com.google.api.client.util.Preconditions.checkNotNull(leaderboardId, "Required parameter leaderboardId must be specified.");
        this.score = com.google.api.client.util.Preconditions.checkNotNull(score, "Required parameter score must be specified.");
      }

      @Override
      public Submit setAlt(java.lang.String alt) {
        return (Submit) super.setAlt(alt);
      }

      @Override
      public Submit setFields(java.lang.String fields) {
        return (Submit) super.setFields(fields);
      }

      @Override
      public Submit setKey(java.lang.String key) {
        return (Submit) super.setKey(key);
      }

      @Override
      public Submit setOauthToken(java.lang.String oauthToken) {
        return (Submit) super.setOauthToken(oauthToken);
      }

      @Override
      public Submit setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Submit) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Submit setQuotaUser(java.lang.String quotaUser) {
        return (Submit) super.setQuotaUser(quotaUser);
      }

      @Override
      public Submit setUserIp(java.lang.String userIp) {
        return (Submit) super.setUserIp(userIp);
      }

      /** The ID of the leaderboard. */
      @com.google.api.client.util.Key
      private java.lang.String leaderboardId;

      /** The ID of the leaderboard.
       */
      public java.lang.String getLeaderboardId() {
        return leaderboardId;
      }

      /** The ID of the leaderboard. */
      public Submit setLeaderboardId(java.lang.String leaderboardId) {
        this.leaderboardId = leaderboardId;
        return this;
      }

      /**
       * The score you're submitting. The submitted score is ignored if it is worse than a
       * previously submitted score, where worse depends on the leaderboard sort order. The meaning
       * of the score value depends on the leaderboard format type. For fixed-point, the score
       * represents the raw value. For time, the score represents elapsed time in milliseconds. For
       * currency, the score represents a value in micro units.
       */
      @com.google.api.client.util.Key
      private java.lang.Long score;

      /** The score you're submitting. The submitted score is ignored if it is worse than a previously
     submitted score, where worse depends on the leaderboard sort order. The meaning of the score value
     depends on the leaderboard format type. For fixed-point, the score represents the raw value. For
     time, the score represents elapsed time in milliseconds. For currency, the score represents a value
     in micro units.
       */
      public java.lang.Long getScore() {
        return score;
      }

      /**
       * The score you're submitting. The submitted score is ignored if it is worse than a
       * previously submitted score, where worse depends on the leaderboard sort order. The meaning
       * of the score value depends on the leaderboard format type. For fixed-point, the score
       * represents the raw value. For time, the score represents elapsed time in milliseconds. For
       * currency, the score represents a value in micro units.
       */
      public Submit setScore(java.lang.Long score) {
        this.score = score;
        return this;
      }

      /** The preferred language to use for strings returned by this method. */
      @com.google.api.client.util.Key
      private java.lang.String language;

      /** The preferred language to use for strings returned by this method.
       */
      public java.lang.String getLanguage() {
        return language;
      }

      /** The preferred language to use for strings returned by this method. */
      public Submit setLanguage(java.lang.String language) {
        this.language = language;
        return this;
      }

      @Override
      public Submit set(String parameterName, Object value) {
        return (Submit) super.set(parameterName, value);
      }
    }
    /**
     * Submits multiple scores to leaderboards.
     *
     * Create a request for the method "scores.submitMultiple".
     *
     * This request holds the parameters needed by the the games server.  After setting any optional
     * parameters, call the {@link SubmitMultiple#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.games.model.PlayerScoreSubmissionList}
     * @return the request
     */
    public SubmitMultiple submitMultiple(com.google.api.services.games.model.PlayerScoreSubmissionList content) throws java.io.IOException {
      SubmitMultiple result = new SubmitMultiple(content);
      initialize(result);
      return result;
    }

    public class SubmitMultiple extends GamesRequest<com.google.api.services.games.model.PlayerScoreListResponse> {

      private static final String REST_PATH = "leaderboards/scores";

      /**
       * Submits multiple scores to leaderboards.
       *
       * Create a request for the method "scores.submitMultiple".
       *
       * This request holds the parameters needed by the the games server.  After setting any optional
       * parameters, call the {@link SubmitMultiple#execute()} method to invoke the remote operation.
       * <p> {@link SubmitMultiple#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param content the {@link com.google.api.services.games.model.PlayerScoreSubmissionList}
       * @since 1.13
       */
      protected SubmitMultiple(com.google.api.services.games.model.PlayerScoreSubmissionList content) {
        super(Games.this, "POST", REST_PATH, content, com.google.api.services.games.model.PlayerScoreListResponse.class);
      }

      @Override
      public SubmitMultiple setAlt(java.lang.String alt) {
        return (SubmitMultiple) super.setAlt(alt);
      }

      @Override
      public SubmitMultiple setFields(java.lang.String fields) {
        return (SubmitMultiple) super.setFields(fields);
      }

      @Override
      public SubmitMultiple setKey(java.lang.String key) {
        return (SubmitMultiple) super.setKey(key);
      }

      @Override
      public SubmitMultiple setOauthToken(java.lang.String oauthToken) {
        return (SubmitMultiple) super.setOauthToken(oauthToken);
      }

      @Override
      public SubmitMultiple setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SubmitMultiple) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SubmitMultiple setQuotaUser(java.lang.String quotaUser) {
        return (SubmitMultiple) super.setQuotaUser(quotaUser);
      }

      @Override
      public SubmitMultiple setUserIp(java.lang.String userIp) {
        return (SubmitMultiple) super.setUserIp(userIp);
      }

      /** The preferred language to use for strings returned by this method. */
      @com.google.api.client.util.Key
      private java.lang.String language;

      /** The preferred language to use for strings returned by this method.
       */
      public java.lang.String getLanguage() {
        return language;
      }

      /** The preferred language to use for strings returned by this method. */
      public SubmitMultiple setLanguage(java.lang.String language) {
        this.language = language;
        return this;
      }

      @Override
      public SubmitMultiple set(String parameterName, Object value) {
        return (SubmitMultiple) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Games}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Games}. */
    @Override
    public Games build() {
      return new Games(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link GamesRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setGamesRequestInitializer(
        GamesRequestInitializer gamesRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(gamesRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
