/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.games;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.games.GamesRequest;
import com.google.api.services.games.GamesRequestInitializer;
import com.google.api.services.games.model.AchievementDefinitionsListResponse;
import com.google.api.services.games.model.AchievementIncrementResponse;
import com.google.api.services.games.model.AchievementRevealResponse;
import com.google.api.services.games.model.AchievementUnlockResponse;
import com.google.api.services.games.model.Application;
import com.google.api.services.games.model.Leaderboard;
import com.google.api.services.games.model.LeaderboardListResponse;
import com.google.api.services.games.model.LeaderboardScores;
import com.google.api.services.games.model.Player;
import com.google.api.services.games.model.PlayerAchievementListResponse;
import com.google.api.services.games.model.PlayerLeaderboardScoreListResponse;
import com.google.api.services.games.model.PlayerScoreListResponse;
import com.google.api.services.games.model.PlayerScoreResponse;
import com.google.api.services.games.model.PlayerScoreSubmissionList;
import com.google.api.services.games.model.RevisionCheckResponse;
import com.google.api.services.games.model.Room;
import com.google.api.services.games.model.RoomCreateRequest;
import com.google.api.services.games.model.RoomJoinRequest;
import com.google.api.services.games.model.RoomLeaveRequest;
import com.google.api.services.games.model.RoomList;
import com.google.api.services.games.model.RoomP2PStatuses;
import com.google.api.services.games.model.RoomStatus;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Games
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "games/v1/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/games/v1/";

    public Games(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Games(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public AchievementDefinitions achievementDefinitions() {
        return new AchievementDefinitions();
    }

    public Achievements achievements() {
        return new Achievements();
    }

    public Applications applications() {
        return new Applications();
    }

    public Leaderboards leaderboards() {
        return new Leaderboards();
    }

    public Players players() {
        return new Players();
    }

    public Revisions revisions() {
        return new Revisions();
    }

    public Rooms rooms() {
        return new Rooms();
    }

    public Scores scores() {
        return new Scores();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION == 14 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need version 1.14 of google-api-client to run version 1.14.2-beta of the Google Play Game Services API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Games.DEFAULT_ROOT_URL, Games.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Games build() {
            return new Games(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setGamesRequestInitializer(GamesRequestInitializer gamesRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)gamesRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Scores {
        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Games.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2, String string3) throws IOException {
            List list = new List(string, string2, string3);
            Games.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public ListWindow listWindow(String string, String string2, String string3) throws IOException {
            ListWindow listWindow = new ListWindow(string, string2, string3);
            Games.this.initialize((AbstractGoogleClientRequest<?>)listWindow);
            return listWindow;
        }

        public Submit submit(String string, Long l) throws IOException {
            Submit submit = new Submit(string, l);
            Games.this.initialize((AbstractGoogleClientRequest<?>)submit);
            return submit;
        }

        public SubmitMultiple submitMultiple(PlayerScoreSubmissionList playerScoreSubmissionList) throws IOException {
            SubmitMultiple submitMultiple = new SubmitMultiple(playerScoreSubmissionList);
            Games.this.initialize((AbstractGoogleClientRequest<?>)submitMultiple);
            return submitMultiple;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SubmitMultiple
        extends GamesRequest<PlayerScoreListResponse> {
            private static final String REST_PATH = "leaderboards/scores";
            @Key
            private String language;

            protected SubmitMultiple(PlayerScoreSubmissionList playerScoreSubmissionList) {
                super(Games.this, "POST", REST_PATH, (Object)playerScoreSubmissionList, PlayerScoreListResponse.class);
            }

            public SubmitMultiple setAlt(String string) {
                return (SubmitMultiple)super.setAlt(string);
            }

            public SubmitMultiple setFields(String string) {
                return (SubmitMultiple)super.setFields(string);
            }

            public SubmitMultiple setKey(String string) {
                return (SubmitMultiple)super.setKey(string);
            }

            public SubmitMultiple setOauthToken(String string) {
                return (SubmitMultiple)super.setOauthToken(string);
            }

            public SubmitMultiple setPrettyPrint(Boolean bl) {
                return (SubmitMultiple)super.setPrettyPrint(bl);
            }

            public SubmitMultiple setQuotaUser(String string) {
                return (SubmitMultiple)super.setQuotaUser(string);
            }

            public SubmitMultiple setUserIp(String string) {
                return (SubmitMultiple)super.setUserIp(string);
            }

            public String getLanguage() {
                return this.language;
            }

            public SubmitMultiple setLanguage(String string) {
                this.language = string;
                return this;
            }

            @Override
            public SubmitMultiple set(String string, Object object) {
                return (SubmitMultiple)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Submit
        extends GamesRequest<PlayerScoreResponse> {
            private static final String REST_PATH = "leaderboards/{leaderboardId}/scores";
            @Key
            private String leaderboardId;
            @Key
            private Long score;
            @Key
            private String language;

            protected Submit(String string, Long l) {
                super(Games.this, "POST", REST_PATH, null, PlayerScoreResponse.class);
                this.leaderboardId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter leaderboardId must be specified.");
                this.score = (Long)Preconditions.checkNotNull((Object)l, (Object)"Required parameter score must be specified.");
            }

            public Submit setAlt(String string) {
                return (Submit)super.setAlt(string);
            }

            public Submit setFields(String string) {
                return (Submit)super.setFields(string);
            }

            public Submit setKey(String string) {
                return (Submit)super.setKey(string);
            }

            public Submit setOauthToken(String string) {
                return (Submit)super.setOauthToken(string);
            }

            public Submit setPrettyPrint(Boolean bl) {
                return (Submit)super.setPrettyPrint(bl);
            }

            public Submit setQuotaUser(String string) {
                return (Submit)super.setQuotaUser(string);
            }

            public Submit setUserIp(String string) {
                return (Submit)super.setUserIp(string);
            }

            public String getLeaderboardId() {
                return this.leaderboardId;
            }

            public Submit setLeaderboardId(String string) {
                this.leaderboardId = string;
                return this;
            }

            public Long getScore() {
                return this.score;
            }

            public Submit setScore(Long l) {
                this.score = l;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Submit setLanguage(String string) {
                this.language = string;
                return this;
            }

            @Override
            public Submit set(String string, Object object) {
                return (Submit)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListWindow
        extends GamesRequest<LeaderboardScores> {
            private static final String REST_PATH = "leaderboards/{leaderboardId}/window/{collection}";
            @Key
            private String leaderboardId;
            @Key
            private String collection;
            @Key
            private String timeSpan;
            @Key
            private String language;
            @Key
            private Boolean returnTopIfAbsent;
            @Key
            private Integer resultsAbove;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected ListWindow(String string, String string2, String string3) {
                super(Games.this, "GET", REST_PATH, null, LeaderboardScores.class);
                this.leaderboardId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter leaderboardId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter collection must be specified.");
                this.timeSpan = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter timeSpan must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListWindow setAlt(String string) {
                return (ListWindow)super.setAlt(string);
            }

            public ListWindow setFields(String string) {
                return (ListWindow)super.setFields(string);
            }

            public ListWindow setKey(String string) {
                return (ListWindow)super.setKey(string);
            }

            public ListWindow setOauthToken(String string) {
                return (ListWindow)super.setOauthToken(string);
            }

            public ListWindow setPrettyPrint(Boolean bl) {
                return (ListWindow)super.setPrettyPrint(bl);
            }

            public ListWindow setQuotaUser(String string) {
                return (ListWindow)super.setQuotaUser(string);
            }

            public ListWindow setUserIp(String string) {
                return (ListWindow)super.setUserIp(string);
            }

            public String getLeaderboardId() {
                return this.leaderboardId;
            }

            public ListWindow setLeaderboardId(String string) {
                this.leaderboardId = string;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public ListWindow setCollection(String string) {
                this.collection = string;
                return this;
            }

            public String getTimeSpan() {
                return this.timeSpan;
            }

            public ListWindow setTimeSpan(String string) {
                this.timeSpan = string;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public ListWindow setLanguage(String string) {
                this.language = string;
                return this;
            }

            public Boolean getReturnTopIfAbsent() {
                return this.returnTopIfAbsent;
            }

            public ListWindow setReturnTopIfAbsent(Boolean bl) {
                this.returnTopIfAbsent = bl;
                return this;
            }

            public Integer getResultsAbove() {
                return this.resultsAbove;
            }

            public ListWindow setResultsAbove(Integer n) {
                this.resultsAbove = n;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public ListWindow setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListWindow setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public ListWindow set(String string, Object object) {
                return (ListWindow)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends GamesRequest<LeaderboardScores> {
            private static final String REST_PATH = "leaderboards/{leaderboardId}/scores/{collection}";
            @Key
            private String leaderboardId;
            @Key
            private String collection;
            @Key
            private String timeSpan;
            @Key
            private String language;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List(String string, String string2, String string3) {
                super(Games.this, "GET", REST_PATH, null, LeaderboardScores.class);
                this.leaderboardId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter leaderboardId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter collection must be specified.");
                this.timeSpan = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter timeSpan must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getLeaderboardId() {
                return this.leaderboardId;
            }

            public List setLeaderboardId(String string) {
                this.leaderboardId = string;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public List setCollection(String string) {
                this.collection = string;
                return this;
            }

            public String getTimeSpan() {
                return this.timeSpan;
            }

            public List setTimeSpan(String string) {
                this.timeSpan = string;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public List setLanguage(String string) {
                this.language = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends GamesRequest<PlayerLeaderboardScoreListResponse> {
            private static final String REST_PATH = "players/{playerId}/leaderboards/{leaderboardId}/scores/{timeSpan}";
            @Key
            private String playerId;
            @Key
            private String leaderboardId;
            @Key
            private String timeSpan;
            @Key
            private String includeRankType;
            @Key
            private String language;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected Get(String string, String string2, String string3) {
                super(Games.this, "GET", REST_PATH, null, PlayerLeaderboardScoreListResponse.class);
                this.playerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter playerId must be specified.");
                this.leaderboardId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter leaderboardId must be specified.");
                this.timeSpan = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter timeSpan must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getPlayerId() {
                return this.playerId;
            }

            public Get setPlayerId(String string) {
                this.playerId = string;
                return this;
            }

            public String getLeaderboardId() {
                return this.leaderboardId;
            }

            public Get setLeaderboardId(String string) {
                this.leaderboardId = string;
                return this;
            }

            public String getTimeSpan() {
                return this.timeSpan;
            }

            public Get setTimeSpan(String string) {
                this.timeSpan = string;
                return this;
            }

            public String getIncludeRankType() {
                return this.includeRankType;
            }

            public Get setIncludeRankType(String string) {
                this.includeRankType = string;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Get setLanguage(String string) {
                this.language = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Get setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Get setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Rooms {
        public Create create(RoomCreateRequest roomCreateRequest) throws IOException {
            Create create = new Create(roomCreateRequest);
            Games.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Decline decline(String string) throws IOException {
            Decline decline = new Decline(string);
            Games.this.initialize((AbstractGoogleClientRequest<?>)decline);
            return decline;
        }

        public Dismiss dismiss(String string) throws IOException {
            Dismiss dismiss = new Dismiss(string);
            Games.this.initialize((AbstractGoogleClientRequest<?>)dismiss);
            return dismiss;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Games.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Join join(String string, RoomJoinRequest roomJoinRequest) throws IOException {
            Join join = new Join(string, roomJoinRequest);
            Games.this.initialize((AbstractGoogleClientRequest<?>)join);
            return join;
        }

        public Leave leave(String string, RoomLeaveRequest roomLeaveRequest) throws IOException {
            Leave leave = new Leave(string, roomLeaveRequest);
            Games.this.initialize((AbstractGoogleClientRequest<?>)leave);
            return leave;
        }

        public List list() throws IOException {
            List list = new List();
            Games.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public ReportStatus reportStatus(String string, RoomP2PStatuses roomP2PStatuses) throws IOException {
            ReportStatus reportStatus = new ReportStatus(string, roomP2PStatuses);
            Games.this.initialize((AbstractGoogleClientRequest<?>)reportStatus);
            return reportStatus;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ReportStatus
        extends GamesRequest<RoomStatus> {
            private static final String REST_PATH = "rooms/{roomId}/reportstatus";
            @Key
            private String roomId;

            protected ReportStatus(String string, RoomP2PStatuses roomP2PStatuses) {
                super(Games.this, "POST", REST_PATH, (Object)roomP2PStatuses, RoomStatus.class);
                this.roomId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter roomId must be specified.");
            }

            public ReportStatus setAlt(String string) {
                return (ReportStatus)super.setAlt(string);
            }

            public ReportStatus setFields(String string) {
                return (ReportStatus)super.setFields(string);
            }

            public ReportStatus setKey(String string) {
                return (ReportStatus)super.setKey(string);
            }

            public ReportStatus setOauthToken(String string) {
                return (ReportStatus)super.setOauthToken(string);
            }

            public ReportStatus setPrettyPrint(Boolean bl) {
                return (ReportStatus)super.setPrettyPrint(bl);
            }

            public ReportStatus setQuotaUser(String string) {
                return (ReportStatus)super.setQuotaUser(string);
            }

            public ReportStatus setUserIp(String string) {
                return (ReportStatus)super.setUserIp(string);
            }

            public String getRoomId() {
                return this.roomId;
            }

            public ReportStatus setRoomId(String string) {
                this.roomId = string;
                return this;
            }

            @Override
            public ReportStatus set(String string, Object object) {
                return (ReportStatus)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends GamesRequest<RoomList> {
            private static final String REST_PATH = "rooms";
            @Key
            private String pageToken;
            @Key
            private Integer maxResults;
            @Key
            private String language;

            protected List() {
                super(Games.this, "GET", REST_PATH, null, RoomList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public List setLanguage(String string) {
                this.language = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Leave
        extends GamesRequest<Room> {
            private static final String REST_PATH = "rooms/{roomId}/leave";
            @Key
            private String roomId;

            protected Leave(String string, RoomLeaveRequest roomLeaveRequest) {
                super(Games.this, "POST", REST_PATH, (Object)roomLeaveRequest, Room.class);
                this.roomId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter roomId must be specified.");
            }

            public Leave setAlt(String string) {
                return (Leave)super.setAlt(string);
            }

            public Leave setFields(String string) {
                return (Leave)super.setFields(string);
            }

            public Leave setKey(String string) {
                return (Leave)super.setKey(string);
            }

            public Leave setOauthToken(String string) {
                return (Leave)super.setOauthToken(string);
            }

            public Leave setPrettyPrint(Boolean bl) {
                return (Leave)super.setPrettyPrint(bl);
            }

            public Leave setQuotaUser(String string) {
                return (Leave)super.setQuotaUser(string);
            }

            public Leave setUserIp(String string) {
                return (Leave)super.setUserIp(string);
            }

            public String getRoomId() {
                return this.roomId;
            }

            public Leave setRoomId(String string) {
                this.roomId = string;
                return this;
            }

            @Override
            public Leave set(String string, Object object) {
                return (Leave)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Join
        extends GamesRequest<Room> {
            private static final String REST_PATH = "rooms/{roomId}/join";
            @Key
            private String roomId;

            protected Join(String string, RoomJoinRequest roomJoinRequest) {
                super(Games.this, "POST", REST_PATH, (Object)roomJoinRequest, Room.class);
                this.roomId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter roomId must be specified.");
            }

            public Join setAlt(String string) {
                return (Join)super.setAlt(string);
            }

            public Join setFields(String string) {
                return (Join)super.setFields(string);
            }

            public Join setKey(String string) {
                return (Join)super.setKey(string);
            }

            public Join setOauthToken(String string) {
                return (Join)super.setOauthToken(string);
            }

            public Join setPrettyPrint(Boolean bl) {
                return (Join)super.setPrettyPrint(bl);
            }

            public Join setQuotaUser(String string) {
                return (Join)super.setQuotaUser(string);
            }

            public Join setUserIp(String string) {
                return (Join)super.setUserIp(string);
            }

            public String getRoomId() {
                return this.roomId;
            }

            public Join setRoomId(String string) {
                this.roomId = string;
                return this;
            }

            @Override
            public Join set(String string, Object object) {
                return (Join)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends GamesRequest<Room> {
            private static final String REST_PATH = "rooms/{roomId}";
            @Key
            private String roomId;
            @Key
            private String language;

            protected Get(String string) {
                super(Games.this, "GET", REST_PATH, null, Room.class);
                this.roomId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter roomId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getRoomId() {
                return this.roomId;
            }

            public Get setRoomId(String string) {
                this.roomId = string;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Get setLanguage(String string) {
                this.language = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Dismiss
        extends GamesRequest<Void> {
            private static final String REST_PATH = "rooms/{roomId}/dismiss";
            @Key
            private String roomId;

            protected Dismiss(String string) {
                super(Games.this, "POST", REST_PATH, null, Void.class);
                this.roomId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter roomId must be specified.");
            }

            public Dismiss setAlt(String string) {
                return (Dismiss)super.setAlt(string);
            }

            public Dismiss setFields(String string) {
                return (Dismiss)super.setFields(string);
            }

            public Dismiss setKey(String string) {
                return (Dismiss)super.setKey(string);
            }

            public Dismiss setOauthToken(String string) {
                return (Dismiss)super.setOauthToken(string);
            }

            public Dismiss setPrettyPrint(Boolean bl) {
                return (Dismiss)super.setPrettyPrint(bl);
            }

            public Dismiss setQuotaUser(String string) {
                return (Dismiss)super.setQuotaUser(string);
            }

            public Dismiss setUserIp(String string) {
                return (Dismiss)super.setUserIp(string);
            }

            public String getRoomId() {
                return this.roomId;
            }

            public Dismiss setRoomId(String string) {
                this.roomId = string;
                return this;
            }

            @Override
            public Dismiss set(String string, Object object) {
                return (Dismiss)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Decline
        extends GamesRequest<Room> {
            private static final String REST_PATH = "rooms/{roomId}/decline";
            @Key
            private String roomId;

            protected Decline(String string) {
                super(Games.this, "POST", REST_PATH, null, Room.class);
                this.roomId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter roomId must be specified.");
            }

            public Decline setAlt(String string) {
                return (Decline)super.setAlt(string);
            }

            public Decline setFields(String string) {
                return (Decline)super.setFields(string);
            }

            public Decline setKey(String string) {
                return (Decline)super.setKey(string);
            }

            public Decline setOauthToken(String string) {
                return (Decline)super.setOauthToken(string);
            }

            public Decline setPrettyPrint(Boolean bl) {
                return (Decline)super.setPrettyPrint(bl);
            }

            public Decline setQuotaUser(String string) {
                return (Decline)super.setQuotaUser(string);
            }

            public Decline setUserIp(String string) {
                return (Decline)super.setUserIp(string);
            }

            public String getRoomId() {
                return this.roomId;
            }

            public Decline setRoomId(String string) {
                this.roomId = string;
                return this;
            }

            @Override
            public Decline set(String string, Object object) {
                return (Decline)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends GamesRequest<Room> {
            private static final String REST_PATH = "rooms/create";
            @Key
            private String language;

            protected Create(RoomCreateRequest roomCreateRequest) {
                super(Games.this, "POST", REST_PATH, (Object)roomCreateRequest, Room.class);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUserIp(String string) {
                return (Create)super.setUserIp(string);
            }

            public String getLanguage() {
                return this.language;
            }

            public Create setLanguage(String string) {
                this.language = string;
                return this;
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class Revisions {
        public Check check(String string) throws IOException {
            Check check = new Check(string);
            Games.this.initialize((AbstractGoogleClientRequest<?>)check);
            return check;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Check
        extends GamesRequest<RevisionCheckResponse> {
            private static final String REST_PATH = "revisions/check";
            @Key
            private String clientRevision;

            protected Check(String string) {
                super(Games.this, "GET", REST_PATH, null, RevisionCheckResponse.class);
                this.clientRevision = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter clientRevision must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Check setAlt(String string) {
                return (Check)super.setAlt(string);
            }

            public Check setFields(String string) {
                return (Check)super.setFields(string);
            }

            public Check setKey(String string) {
                return (Check)super.setKey(string);
            }

            public Check setOauthToken(String string) {
                return (Check)super.setOauthToken(string);
            }

            public Check setPrettyPrint(Boolean bl) {
                return (Check)super.setPrettyPrint(bl);
            }

            public Check setQuotaUser(String string) {
                return (Check)super.setQuotaUser(string);
            }

            public Check setUserIp(String string) {
                return (Check)super.setUserIp(string);
            }

            public String getClientRevision() {
                return this.clientRevision;
            }

            public Check setClientRevision(String string) {
                this.clientRevision = string;
                return this;
            }

            @Override
            public Check set(String string, Object object) {
                return (Check)super.set(string, object);
            }
        }
    }

    public class Players {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Games.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends GamesRequest<Player> {
            private static final String REST_PATH = "players/{playerId}";
            @Key
            private String playerId;

            protected Get(String string) {
                super(Games.this, "GET", REST_PATH, null, Player.class);
                this.playerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter playerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getPlayerId() {
                return this.playerId;
            }

            public Get setPlayerId(String string) {
                this.playerId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Leaderboards {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Games.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            Games.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends GamesRequest<LeaderboardListResponse> {
            private static final String REST_PATH = "leaderboards";
            @Key
            private String pageToken;
            @Key
            private Integer maxResults;
            @Key
            private String language;

            protected List() {
                super(Games.this, "GET", REST_PATH, null, LeaderboardListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public List setLanguage(String string) {
                this.language = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends GamesRequest<Leaderboard> {
            private static final String REST_PATH = "leaderboards/{leaderboardId}";
            @Key
            private String leaderboardId;
            @Key
            private String language;

            protected Get(String string) {
                super(Games.this, "GET", REST_PATH, null, Leaderboard.class);
                this.leaderboardId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter leaderboardId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getLeaderboardId() {
                return this.leaderboardId;
            }

            public Get setLeaderboardId(String string) {
                this.leaderboardId = string;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Get setLanguage(String string) {
                this.language = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Applications {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Games.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Played played() throws IOException {
            Played played = new Played();
            Games.this.initialize((AbstractGoogleClientRequest<?>)played);
            return played;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Played
        extends GamesRequest<Void> {
            private static final String REST_PATH = "applications/played";

            protected Played() {
                super(Games.this, "POST", REST_PATH, null, Void.class);
            }

            public Played setAlt(String string) {
                return (Played)super.setAlt(string);
            }

            public Played setFields(String string) {
                return (Played)super.setFields(string);
            }

            public Played setKey(String string) {
                return (Played)super.setKey(string);
            }

            public Played setOauthToken(String string) {
                return (Played)super.setOauthToken(string);
            }

            public Played setPrettyPrint(Boolean bl) {
                return (Played)super.setPrettyPrint(bl);
            }

            public Played setQuotaUser(String string) {
                return (Played)super.setQuotaUser(string);
            }

            public Played setUserIp(String string) {
                return (Played)super.setUserIp(string);
            }

            @Override
            public Played set(String string, Object object) {
                return (Played)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends GamesRequest<Application> {
            private static final String REST_PATH = "applications/{applicationId}";
            @Key
            private String applicationId;
            @Key
            private String platformType;
            @Key
            private String language;

            protected Get(String string) {
                super(Games.this, "GET", REST_PATH, null, Application.class);
                this.applicationId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter applicationId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getApplicationId() {
                return this.applicationId;
            }

            public Get setApplicationId(String string) {
                this.applicationId = string;
                return this;
            }

            public String getPlatformType() {
                return this.platformType;
            }

            public Get setPlatformType(String string) {
                this.platformType = string;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Get setLanguage(String string) {
                this.language = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Achievements {
        public Increment increment(String string, Integer n) throws IOException {
            Increment increment = new Increment(string, n);
            Games.this.initialize((AbstractGoogleClientRequest<?>)increment);
            return increment;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Games.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Reveal reveal(String string) throws IOException {
            Reveal reveal = new Reveal(string);
            Games.this.initialize((AbstractGoogleClientRequest<?>)reveal);
            return reveal;
        }

        public Unlock unlock(String string) throws IOException {
            Unlock unlock = new Unlock(string);
            Games.this.initialize((AbstractGoogleClientRequest<?>)unlock);
            return unlock;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Unlock
        extends GamesRequest<AchievementUnlockResponse> {
            private static final String REST_PATH = "achievements/{achievementId}/unlock";
            @Key
            private String achievementId;

            protected Unlock(String string) {
                super(Games.this, "POST", REST_PATH, null, AchievementUnlockResponse.class);
                this.achievementId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter achievementId must be specified.");
            }

            public Unlock setAlt(String string) {
                return (Unlock)super.setAlt(string);
            }

            public Unlock setFields(String string) {
                return (Unlock)super.setFields(string);
            }

            public Unlock setKey(String string) {
                return (Unlock)super.setKey(string);
            }

            public Unlock setOauthToken(String string) {
                return (Unlock)super.setOauthToken(string);
            }

            public Unlock setPrettyPrint(Boolean bl) {
                return (Unlock)super.setPrettyPrint(bl);
            }

            public Unlock setQuotaUser(String string) {
                return (Unlock)super.setQuotaUser(string);
            }

            public Unlock setUserIp(String string) {
                return (Unlock)super.setUserIp(string);
            }

            public String getAchievementId() {
                return this.achievementId;
            }

            public Unlock setAchievementId(String string) {
                this.achievementId = string;
                return this;
            }

            @Override
            public Unlock set(String string, Object object) {
                return (Unlock)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Reveal
        extends GamesRequest<AchievementRevealResponse> {
            private static final String REST_PATH = "achievements/{achievementId}/reveal";
            @Key
            private String achievementId;

            protected Reveal(String string) {
                super(Games.this, "POST", REST_PATH, null, AchievementRevealResponse.class);
                this.achievementId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter achievementId must be specified.");
            }

            public Reveal setAlt(String string) {
                return (Reveal)super.setAlt(string);
            }

            public Reveal setFields(String string) {
                return (Reveal)super.setFields(string);
            }

            public Reveal setKey(String string) {
                return (Reveal)super.setKey(string);
            }

            public Reveal setOauthToken(String string) {
                return (Reveal)super.setOauthToken(string);
            }

            public Reveal setPrettyPrint(Boolean bl) {
                return (Reveal)super.setPrettyPrint(bl);
            }

            public Reveal setQuotaUser(String string) {
                return (Reveal)super.setQuotaUser(string);
            }

            public Reveal setUserIp(String string) {
                return (Reveal)super.setUserIp(string);
            }

            public String getAchievementId() {
                return this.achievementId;
            }

            public Reveal setAchievementId(String string) {
                this.achievementId = string;
                return this;
            }

            @Override
            public Reveal set(String string, Object object) {
                return (Reveal)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends GamesRequest<PlayerAchievementListResponse> {
            private static final String REST_PATH = "players/{playerId}/achievements";
            @Key
            private String playerId;
            @Key
            private String pageToken;
            @Key
            private String state;
            @Key
            private Integer maxResults;
            @Key
            private String language;

            protected List(String string) {
                super(Games.this, "GET", REST_PATH, null, PlayerAchievementListResponse.class);
                this.playerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter playerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPlayerId() {
                return this.playerId;
            }

            public List setPlayerId(String string) {
                this.playerId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getState() {
                return this.state;
            }

            public List setState(String string) {
                this.state = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public List setLanguage(String string) {
                this.language = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Increment
        extends GamesRequest<AchievementIncrementResponse> {
            private static final String REST_PATH = "achievements/{achievementId}/increment";
            @Key
            private String achievementId;
            @Key
            private Integer stepsToIncrement;
            @Key
            private Long requestId;

            protected Increment(String string, Integer n) {
                super(Games.this, "POST", REST_PATH, null, AchievementIncrementResponse.class);
                this.achievementId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter achievementId must be specified.");
                this.stepsToIncrement = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter stepsToIncrement must be specified.");
            }

            public Increment setAlt(String string) {
                return (Increment)super.setAlt(string);
            }

            public Increment setFields(String string) {
                return (Increment)super.setFields(string);
            }

            public Increment setKey(String string) {
                return (Increment)super.setKey(string);
            }

            public Increment setOauthToken(String string) {
                return (Increment)super.setOauthToken(string);
            }

            public Increment setPrettyPrint(Boolean bl) {
                return (Increment)super.setPrettyPrint(bl);
            }

            public Increment setQuotaUser(String string) {
                return (Increment)super.setQuotaUser(string);
            }

            public Increment setUserIp(String string) {
                return (Increment)super.setUserIp(string);
            }

            public String getAchievementId() {
                return this.achievementId;
            }

            public Increment setAchievementId(String string) {
                this.achievementId = string;
                return this;
            }

            public Integer getStepsToIncrement() {
                return this.stepsToIncrement;
            }

            public Increment setStepsToIncrement(Integer n) {
                this.stepsToIncrement = n;
                return this;
            }

            public Long getRequestId() {
                return this.requestId;
            }

            public Increment setRequestId(Long l) {
                this.requestId = l;
                return this;
            }

            @Override
            public Increment set(String string, Object object) {
                return (Increment)super.set(string, object);
            }
        }
    }

    public class AchievementDefinitions {
        public List list() throws IOException {
            List list = new List();
            Games.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends GamesRequest<AchievementDefinitionsListResponse> {
            private static final String REST_PATH = "achievements";
            @Key
            private String pageToken;
            @Key
            private Integer maxResults;
            @Key
            private String language;

            protected List() {
                super(Games.this, "GET", REST_PATH, null, AchievementDefinitionsListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public List setLanguage(String string) {
                this.language = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }
}

