/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-08-03 17:34:38 UTC)
 * on 2015-09-01 at 03:26:55 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for an event period update resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventRecordRequest extends com.google.api.client.json.GenericJson {

  /**
   * The current time when this update was sent, in milliseconds, since 1970 UTC (Unix Epoch).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long currentTimeMillis;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#eventRecordRequest.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The request ID used to identify this attempt to record events.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long requestId;

  /**
   * A list of the time period updates being made in this request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<EventPeriodUpdate> timePeriods;

  static {
    // hack to force ProGuard to consider EventPeriodUpdate used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(EventPeriodUpdate.class);
  }

  /**
   * The current time when this update was sent, in milliseconds, since 1970 UTC (Unix Epoch).
   * @return value or {@code null} for none
   */
  public java.lang.Long getCurrentTimeMillis() {
    return currentTimeMillis;
  }

  /**
   * The current time when this update was sent, in milliseconds, since 1970 UTC (Unix Epoch).
   * @param currentTimeMillis currentTimeMillis or {@code null} for none
   */
  public EventRecordRequest setCurrentTimeMillis(java.lang.Long currentTimeMillis) {
    this.currentTimeMillis = currentTimeMillis;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#eventRecordRequest.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#eventRecordRequest.
   * @param kind kind or {@code null} for none
   */
  public EventRecordRequest setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The request ID used to identify this attempt to record events.
   * @return value or {@code null} for none
   */
  public java.lang.Long getRequestId() {
    return requestId;
  }

  /**
   * The request ID used to identify this attempt to record events.
   * @param requestId requestId or {@code null} for none
   */
  public EventRecordRequest setRequestId(java.lang.Long requestId) {
    this.requestId = requestId;
    return this;
  }

  /**
   * A list of the time period updates being made in this request.
   * @return value or {@code null} for none
   */
  public java.util.List<EventPeriodUpdate> getTimePeriods() {
    return timePeriods;
  }

  /**
   * A list of the time period updates being made in this request.
   * @param timePeriods timePeriods or {@code null} for none
   */
  public EventRecordRequest setTimePeriods(java.util.List<EventPeriodUpdate> timePeriods) {
    this.timePeriods = timePeriods;
    return this;
  }

  @Override
  public EventRecordRequest set(String fieldName, Object value) {
    return (EventRecordRequest) super.set(fieldName, value);
  }

  @Override
  public EventRecordRequest clone() {
    return (EventRecordRequest) super.clone();
  }

}
