/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-08-03 17:34:38 UTC)
 * on 2015-09-01 at 03:26:55 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for the metagame config resource
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MetagameConfig extends com.google.api.client.json.GenericJson {

  /**
   * Current version of the metagame configuration data. When this data is updated, the version
   * number will be increased by one.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer currentVersion;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#metagameConfig.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The list of player levels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PlayerLevel> playerLevels;

  /**
   * Current version of the metagame configuration data. When this data is updated, the version
   * number will be increased by one.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCurrentVersion() {
    return currentVersion;
  }

  /**
   * Current version of the metagame configuration data. When this data is updated, the version
   * number will be increased by one.
   * @param currentVersion currentVersion or {@code null} for none
   */
  public MetagameConfig setCurrentVersion(java.lang.Integer currentVersion) {
    this.currentVersion = currentVersion;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#metagameConfig.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#metagameConfig.
   * @param kind kind or {@code null} for none
   */
  public MetagameConfig setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The list of player levels.
   * @return value or {@code null} for none
   */
  public java.util.List<PlayerLevel> getPlayerLevels() {
    return playerLevels;
  }

  /**
   * The list of player levels.
   * @param playerLevels playerLevels or {@code null} for none
   */
  public MetagameConfig setPlayerLevels(java.util.List<PlayerLevel> playerLevels) {
    this.playerLevels = playerLevels;
    return this;
  }

  @Override
  public MetagameConfig set(String fieldName, Object value) {
    return (MetagameConfig) super.set(fieldName, value);
  }

  @Override
  public MetagameConfig clone() {
    return (MetagameConfig) super.clone();
  }

}
