/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-08-03 17:34:38 UTC)
 * on 2015-09-01 at 03:26:55 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for a rematch response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TurnBasedMatchRematch extends com.google.api.client.json.GenericJson {

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatchRematch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The old match that the rematch was created from; will be updated such that the rematchId field
   * will point at the new match.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TurnBasedMatch previousMatch;

  /**
   * The newly created match; a rematch of the old match with the same participants.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TurnBasedMatch rematch;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatchRematch.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#turnBasedMatchRematch.
   * @param kind kind or {@code null} for none
   */
  public TurnBasedMatchRematch setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The old match that the rematch was created from; will be updated such that the rematchId field
   * will point at the new match.
   * @return value or {@code null} for none
   */
  public TurnBasedMatch getPreviousMatch() {
    return previousMatch;
  }

  /**
   * The old match that the rematch was created from; will be updated such that the rematchId field
   * will point at the new match.
   * @param previousMatch previousMatch or {@code null} for none
   */
  public TurnBasedMatchRematch setPreviousMatch(TurnBasedMatch previousMatch) {
    this.previousMatch = previousMatch;
    return this;
  }

  /**
   * The newly created match; a rematch of the old match with the same participants.
   * @return value or {@code null} for none
   */
  public TurnBasedMatch getRematch() {
    return rematch;
  }

  /**
   * The newly created match; a rematch of the old match with the same participants.
   * @param rematch rematch or {@code null} for none
   */
  public TurnBasedMatchRematch setRematch(TurnBasedMatch rematch) {
    this.rematch = rematch;
    return this;
  }

  @Override
  public TurnBasedMatchRematch set(String fieldName, Object value) {
    return (TurnBasedMatchRematch) super.set(fieldName, value);
  }

  @Override
  public TurnBasedMatchRematch clone() {
    return (TurnBasedMatchRematch) super.clone();
  }

}
