/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-11-16 19:10:01 UTC)
 * on 2015-12-08 at 04:54:24 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for 1P/3P metadata about the player's experience.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PlayerExperienceInfo extends com.google.api.client.json.GenericJson {

  /**
   * The current number of experience points for the player.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long currentExperiencePoints;

  /**
   * The current level of the player.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PlayerLevel currentLevel;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#playerExperienceInfo.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The timestamp when the player was leveled up, in millis since Unix epoch UTC.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long lastLevelUpTimestampMillis;

  /**
   * The next level of the player. If the current level is the maximum level, this should be same as
   * the current level.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PlayerLevel nextLevel;

  /**
   * The current number of experience points for the player.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCurrentExperiencePoints() {
    return currentExperiencePoints;
  }

  /**
   * The current number of experience points for the player.
   * @param currentExperiencePoints currentExperiencePoints or {@code null} for none
   */
  public PlayerExperienceInfo setCurrentExperiencePoints(java.lang.Long currentExperiencePoints) {
    this.currentExperiencePoints = currentExperiencePoints;
    return this;
  }

  /**
   * The current level of the player.
   * @return value or {@code null} for none
   */
  public PlayerLevel getCurrentLevel() {
    return currentLevel;
  }

  /**
   * The current level of the player.
   * @param currentLevel currentLevel or {@code null} for none
   */
  public PlayerExperienceInfo setCurrentLevel(PlayerLevel currentLevel) {
    this.currentLevel = currentLevel;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#playerExperienceInfo.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#playerExperienceInfo.
   * @param kind kind or {@code null} for none
   */
  public PlayerExperienceInfo setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The timestamp when the player was leveled up, in millis since Unix epoch UTC.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLastLevelUpTimestampMillis() {
    return lastLevelUpTimestampMillis;
  }

  /**
   * The timestamp when the player was leveled up, in millis since Unix epoch UTC.
   * @param lastLevelUpTimestampMillis lastLevelUpTimestampMillis or {@code null} for none
   */
  public PlayerExperienceInfo setLastLevelUpTimestampMillis(java.lang.Long lastLevelUpTimestampMillis) {
    this.lastLevelUpTimestampMillis = lastLevelUpTimestampMillis;
    return this;
  }

  /**
   * The next level of the player. If the current level is the maximum level, this should be same as
   * the current level.
   * @return value or {@code null} for none
   */
  public PlayerLevel getNextLevel() {
    return nextLevel;
  }

  /**
   * The next level of the player. If the current level is the maximum level, this should be same as
   * the current level.
   * @param nextLevel nextLevel or {@code null} for none
   */
  public PlayerExperienceInfo setNextLevel(PlayerLevel nextLevel) {
    this.nextLevel = nextLevel;
    return this;
  }

  @Override
  public PlayerExperienceInfo set(String fieldName, Object value) {
    return (PlayerExperienceInfo) super.set(fieldName, value);
  }

  @Override
  public PlayerExperienceInfo clone() {
    return (PlayerExperienceInfo) super.clone();
  }

}
