/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-30 at 00:49:31 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for metadata about a player playing a game with the currently
 * authenticated user.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Played extends com.google.api.client.json.GenericJson {

  /**
   * True if the player was auto-matched with the currently authenticated user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoMatched;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string games#played.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The last time the player played the game in milliseconds since the epoch in UTC.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long timeMillis;

  /**
   * True if the player was auto-matched with the currently authenticated user.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoMatched() {
    return autoMatched;
  }

  /**
   * True if the player was auto-matched with the currently authenticated user.
   * @param autoMatched autoMatched or {@code null} for none
   */
  public Played setAutoMatched(java.lang.Boolean autoMatched) {
    this.autoMatched = autoMatched;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string games#played.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string games#played.
   * @param kind kind or {@code null} for none
   */
  public Played setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The last time the player played the game in milliseconds since the epoch in UTC.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTimeMillis() {
    return timeMillis;
  }

  /**
   * The last time the player played the game in milliseconds since the epoch in UTC.
   * @param timeMillis timeMillis or {@code null} for none
   */
  public Played setTimeMillis(java.lang.Long timeMillis) {
    this.timeMillis = timeMillis;
    return this;
  }

  @Override
  public Played set(String fieldName, Object value) {
    return (Played) super.set(fieldName, value);
  }

  @Override
  public Played clone() {
    return (Played) super.clone();
  }

}
