/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-30 at 00:49:31 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.games.model;

/**
 * This is a JSON template for an event status resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Game Services API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PlayerEvent extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the event definition.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String definitionId;

  /**
   * The current number of times this event has occurred, as a string. The formatting of this string
   * depends on the configuration of your event in the Play Games Developer Console.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formattedNumEvents;

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#playerEvent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The current number of times this event has occurred.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numEvents;

  /**
   * The ID of the player.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String playerId;

  /**
   * The ID of the event definition.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefinitionId() {
    return definitionId;
  }

  /**
   * The ID of the event definition.
   * @param definitionId definitionId or {@code null} for none
   */
  public PlayerEvent setDefinitionId(java.lang.String definitionId) {
    this.definitionId = definitionId;
    return this;
  }

  /**
   * The current number of times this event has occurred, as a string. The formatting of this string
   * depends on the configuration of your event in the Play Games Developer Console.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormattedNumEvents() {
    return formattedNumEvents;
  }

  /**
   * The current number of times this event has occurred, as a string. The formatting of this string
   * depends on the configuration of your event in the Play Games Developer Console.
   * @param formattedNumEvents formattedNumEvents or {@code null} for none
   */
  public PlayerEvent setFormattedNumEvents(java.lang.String formattedNumEvents) {
    this.formattedNumEvents = formattedNumEvents;
    return this;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#playerEvent.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Uniquely identifies the type of this resource. Value is always the fixed string
   * games#playerEvent.
   * @param kind kind or {@code null} for none
   */
  public PlayerEvent setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The current number of times this event has occurred.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumEvents() {
    return numEvents;
  }

  /**
   * The current number of times this event has occurred.
   * @param numEvents numEvents or {@code null} for none
   */
  public PlayerEvent setNumEvents(java.lang.Long numEvents) {
    this.numEvents = numEvents;
    return this;
  }

  /**
   * The ID of the player.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlayerId() {
    return playerId;
  }

  /**
   * The ID of the player.
   * @param playerId playerId or {@code null} for none
   */
  public PlayerEvent setPlayerId(java.lang.String playerId) {
    this.playerId = playerId;
    return this;
  }

  @Override
  public PlayerEvent set(String fieldName, Object value) {
    return (PlayerEvent) super.set(fieldName, value);
  }

  @Override
  public PlayerEvent clone() {
    return (PlayerEvent) super.clone();
  }

}
